/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.graphchi.walks;

import edu.cmu.graphchi.ChiLogger;
import edu.cmu.graphchi.ChiVertex;
import edu.cmu.graphchi.EdgeDirection;
import edu.cmu.graphchi.GraphChiContext;
import edu.cmu.graphchi.GraphChiProgram;
import edu.cmu.graphchi.datablocks.BytesToValueConverter;
import edu.cmu.graphchi.engine.GraphChiEngine;
import edu.cmu.graphchi.engine.VertexInterval;
import edu.cmu.graphchi.preprocessing.VertexIdTranslate;
import edu.cmu.graphchi.walks.DrunkardDriver;
import edu.cmu.graphchi.walks.DrunkardFactory;
import edu.cmu.graphchi.walks.DrunkardJob;
import edu.cmu.graphchi.walks.LocalWalkBuffer;
import edu.cmu.graphchi.walks.WalkUpdateFunction;
import edu.cmu.graphchi.walks.distributions.RemoteDrunkardCompanion;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class DrunkardMobEngine<VertexDataType, EdgeDataType> {
    private GraphChiEngine<VertexDataType, EdgeDataType> engine;
    private List<DrunkardDriver> drivers;
    private static Logger logger = ChiLogger.getLogger("drunkardmob-engine");
    private DrunkardFactory<VertexDataType, EdgeDataType> factory;

    public DrunkardMobEngine(String string, int n, DrunkardFactory<VertexDataType, EdgeDataType> drunkardFactory) throws IOException {
        this.createGraphChiEngine(string, n);
        this.drivers = new ArrayList<DrunkardDriver>();
        this.factory = drunkardFactory;
        this.engine.setDisableInedges(true);
        this.engine.setDisableOutEdges(true);
        this.engine.setModifiesInedges(false);
        this.engine.setModifiesOutedges(false);
    }

    private void createGraphChiEngine(String string, int n) throws IOException {
        this.engine = new GraphChiEngine(string, n);
        this.engine.setOnlyAdjacency(true);
        this.engine.setVertexDataConverter(null);
        this.engine.setEdataConverter(null);
    }

    public GraphChiEngine<VertexDataType, EdgeDataType> getEngine() {
        return this.engine;
    }

    public DrunkardJob getJob(String string) {
        for (DrunkardDriver drunkardDriver : this.drivers) {
            if (!drunkardDriver.getJob().getName().equals(string)) continue;
            return drunkardDriver.getJob();
        }
        return null;
    }

    public void setEdataConverter(BytesToValueConverter<EdgeDataType> bytesToValueConverter) {
        this.engine.setEdataConverter(bytesToValueConverter);
        if (bytesToValueConverter != null) {
            this.engine.setOnlyAdjacency(false);
        } else {
            this.engine.setOnlyAdjacency(true);
        }
    }

    public void setVertexDataConverter(BytesToValueConverter<VertexDataType> bytesToValueConverter) {
        this.engine.setVertexDataConverter(bytesToValueConverter);
    }

    public DrunkardJob addJob(String string, EdgeDirection edgeDirection, WalkUpdateFunction<VertexDataType, EdgeDataType> walkUpdateFunction, RemoteDrunkardCompanion remoteDrunkardCompanion) {
        switch (edgeDirection) {
            case IN_AND_OUT_EDGES: {
                this.engine.setDisableInedges(false);
                this.engine.setDisableOutEdges(false);
                break;
            }
            case IN_EDGES: {
                this.engine.setDisableInedges(false);
                break;
            }
            case OUT_EDGES: {
                this.engine.setDisableOutEdges(false);
            }
        }
        DrunkardJob drunkardJob = new DrunkardJob(string, remoteDrunkardCompanion, this.engine.numVertices(), this.factory);
        this.drivers.add(this.factory.createDrunkardDriver(drunkardJob, walkUpdateFunction));
        return drunkardJob;
    }

    public void run(int n) throws IOException, RemoteException {
        this.engine.setEnableScheduler(true);
        int n2 = 1200;
        if (System.getProperty("membudget") != null) {
            n2 = Integer.parseInt(System.getProperty("membudget"));
        }
        this.engine.setMemoryBudgetMb(n2);
        this.engine.setEnableDeterministicExecution(false);
        this.engine.setAutoLoadNext(false);
        this.engine.setVertexDataConverter(null);
        this.engine.setMaxWindow(10000000);
        long l = System.currentTimeMillis();
        for (DrunkardDriver drunkardDriver : this.drivers) {
            if (drunkardDriver.getJob().getWalkManager() == null) {
                throw new IllegalStateException("You need to configure walks by calling DrunkardJob.configureXXX()");
            }
            drunkardDriver.initWalks();
        }
        long l2 = System.currentTimeMillis() - l;
        logger.info("Starting running drunkard jobs (" + this.drivers.size() + " jobs)");
        this.engine.run(new GraphChiDrunkardWrapper(), n);
        for (DrunkardDriver drunkardDriver : this.drivers) {
            drunkardDriver.spinUntilFinish();
        }
    }

    public VertexIdTranslate getVertexIdTranslate() {
        return this.engine.getVertexIdTranslate();
    }

    protected class GraphChiDrunkardWrapper
    implements GraphChiProgram<VertexDataType, EdgeDataType> {
        long iterationStart;

        @Override
        public void update(ChiVertex<VertexDataType, EdgeDataType> chiVertex, GraphChiContext graphChiContext) {
            try {
                ArrayList<Object> arrayList;
                if (graphChiContext.getThreadLocal() == null) {
                    arrayList = new ArrayList<Object>(DrunkardMobEngine.this.drivers.size());
                    for (Object object : DrunkardMobEngine.this.drivers) {
                        Object object2 = DrunkardMobEngine.this.factory.createLocalWalkBuffer();
                        ((DrunkardDriver)object).addLocalBuffer((LocalWalkBuffer)object2);
                        arrayList.add(object2);
                    }
                    graphChiContext.setThreadLocal(arrayList);
                }
                arrayList = (ArrayList<Object>)graphChiContext.getThreadLocal();
                int n = 0;
                for (Object object2 : DrunkardMobEngine.this.drivers) {
                    ((DrunkardDriver)object2).update(chiVertex, graphChiContext, (LocalWalkBuffer)arrayList.get(n++));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        @Override
        public void beginIteration(GraphChiContext graphChiContext) {
            this.iterationStart = System.currentTimeMillis();
            for (DrunkardDriver drunkardDriver : DrunkardMobEngine.this.drivers) {
                drunkardDriver.beginIteration(graphChiContext);
            }
        }

        @Override
        public void endIteration(GraphChiContext graphChiContext) {
            for (DrunkardDriver drunkardDriver : DrunkardMobEngine.this.drivers) {
                drunkardDriver.endIteration(graphChiContext);
            }
            long l = System.currentTimeMillis() - this.iterationStart;
        }

        @Override
        public void beginInterval(GraphChiContext graphChiContext, VertexInterval vertexInterval) {
            for (DrunkardDriver drunkardDriver : DrunkardMobEngine.this.drivers) {
                drunkardDriver.beginInterval(graphChiContext, vertexInterval);
            }
        }

        @Override
        public void endInterval(GraphChiContext graphChiContext, VertexInterval vertexInterval) {
            for (DrunkardDriver drunkardDriver : DrunkardMobEngine.this.drivers) {
                drunkardDriver.endInterval(graphChiContext, vertexInterval);
            }
        }

        @Override
        public void beginSubInterval(GraphChiContext graphChiContext, VertexInterval vertexInterval) {
            for (DrunkardDriver drunkardDriver : DrunkardMobEngine.this.drivers) {
                drunkardDriver.beginSubInterval(graphChiContext, vertexInterval);
            }
        }

        @Override
        public void endSubInterval(GraphChiContext graphChiContext, VertexInterval vertexInterval) {
            for (DrunkardDriver drunkardDriver : DrunkardMobEngine.this.drivers) {
                drunkardDriver.endSubInterval(graphChiContext, vertexInterval);
            }
        }
    }
}

