/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.graphchi.walks;

import edu.cmu.graphchi.GraphChiContext;
import edu.cmu.graphchi.preprocessing.VertexIdTranslate;
import edu.cmu.graphchi.walks.DrunkardContext;
import edu.cmu.graphchi.walks.DrunkardDriver;
import edu.cmu.graphchi.walks.DrunkardJob;
import edu.cmu.graphchi.walks.GrabbedBucketConsumer;
import edu.cmu.graphchi.walks.IntDrunkardContext;
import edu.cmu.graphchi.walks.IntDumperThread;
import edu.cmu.graphchi.walks.IntLocalWalkBuffer;
import edu.cmu.graphchi.walks.IntWalkManager;
import edu.cmu.graphchi.walks.LocalWalkBuffer;
import edu.cmu.graphchi.walks.WalkUpdateFunction;

public class IntDrunkardDriver<VertexDataType, EdgeDataType>
extends DrunkardDriver<VertexDataType, EdgeDataType>
implements GrabbedBucketConsumer {
    IntDrunkardDriver(DrunkardJob drunkardJob, WalkUpdateFunction<VertexDataType, EdgeDataType> walkUpdateFunction) {
        super(drunkardJob, walkUpdateFunction);
    }

    @Override
    protected IntDumperThread createDumperThread() {
        return new IntDumperThread(this.bucketQueue, this.pendingWalksToSubmit, this.finished, this.job);
    }

    @Override
    protected DrunkardContext createDrunkardContext(int n, final GraphChiContext graphChiContext, LocalWalkBuffer localWalkBuffer) {
        final IntWalkManager intWalkManager = (IntWalkManager)this.job.getWalkManager();
        final boolean bl = intWalkManager.isSource(n);
        final int n2 = bl ? intWalkManager.getVertexSourceIdx(n) : -1;
        final IntLocalWalkBuffer intLocalWalkBuffer = (IntLocalWalkBuffer)localWalkBuffer;
        return new IntDrunkardContext(){

            @Override
            public boolean isSource() {
                return bl;
            }

            @Override
            public int sourceIndex() {
                return n2;
            }

            @Override
            public int getIteration() {
                return graphChiContext.getIteration();
            }

            @Override
            public void forwardWalkTo(int n, int n22, boolean bl2) {
                intLocalWalkBuffer.add(n, n22, bl2);
            }

            @Override
            public void resetWalk(int n, boolean bl2) {
                this.forwardWalkTo(n, intWalkManager.getSourceVertex(n), bl2);
            }

            @Override
            public boolean getTrackBit(int n) {
                return intWalkManager.trackBit(n);
            }

            @Override
            public boolean isWalkStartedFromVertex(int n) {
                return n2 == intWalkManager.sourceIdx(n);
            }

            @Override
            public VertexIdTranslate getVertexIdTranslate() {
                return this.getVertexIdTranslate();
            }
        };
    }
}

