/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.graphchi.walks;

import edu.cmu.graphchi.walks.BucketsToSend;
import edu.cmu.graphchi.walks.DrunkardJob;
import edu.cmu.graphchi.walks.DumperThread;
import edu.cmu.graphchi.walks.IntWalkArray;
import edu.cmu.graphchi.walks.IntWalkManager;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class IntDumperThread
extends DumperThread {
    private final DrunkardJob job;
    private int[] walks = new int[262144];
    private int[] vertices = new int[262144];
    private int idx = 0;

    public IntDumperThread(LinkedBlockingQueue<BucketsToSend> linkedBlockingQueue, AtomicLong atomicLong, AtomicBoolean atomicBoolean, DrunkardJob drunkardJob) {
        super(linkedBlockingQueue, atomicLong, atomicBoolean);
        this.job = drunkardJob;
    }

    @Override
    protected void processWalks(BucketsToSend bucketsToSend, int n) {
        IntWalkManager intWalkManager = (IntWalkManager)this.job.getWalkManager();
        IntWalkArray intWalkArray = (IntWalkArray)bucketsToSend.walks;
        int n2 = intWalkArray.getArray()[n];
        int n3 = intWalkManager.off(n2) + bucketsToSend.firstVertex;
        boolean bl = intWalkManager.trackBit(n2);
        if (!bl) {
            return;
        }
        this.walks[this.idx] = n2;
        this.vertices[this.idx] = n3;
        ++this.idx;
        if (this.idx >= this.walks.length) {
            try {
                this.job.getCompanion().processWalks(new IntWalkArray(this.walks), this.vertices);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.idx = 0;
        }
    }

    @Override
    protected void sendRest() {
        try {
            int[] nArray = new int[this.idx];
            int[] nArray2 = new int[this.idx];
            System.arraycopy(this.walks, 0, nArray, 0, this.idx);
            System.arraycopy(this.vertices, 0, nArray2, 0, this.idx);
            this.job.getCompanion().processWalks(new IntWalkArray(nArray), nArray2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

