/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.graphchi.walks;

import edu.cmu.graphchi.GraphChiContext;
import edu.cmu.graphchi.preprocessing.VertexIdTranslate;
import edu.cmu.graphchi.walks.DrunkardContext;
import edu.cmu.graphchi.walks.DrunkardDriver;
import edu.cmu.graphchi.walks.DrunkardJob;
import edu.cmu.graphchi.walks.GrabbedBucketConsumer;
import edu.cmu.graphchi.walks.LocalWalkBuffer;
import edu.cmu.graphchi.walks.LongDrunkardContext;
import edu.cmu.graphchi.walks.LongDumperThread;
import edu.cmu.graphchi.walks.LongLocalWalkBuffer;
import edu.cmu.graphchi.walks.LongWalkManager;
import edu.cmu.graphchi.walks.WalkUpdateFunction;

public class LongDrunkardDriver<VertexDataType, EdgeDataType>
extends DrunkardDriver<VertexDataType, EdgeDataType>
implements GrabbedBucketConsumer {
    public LongDrunkardDriver(DrunkardJob drunkardJob, WalkUpdateFunction<VertexDataType, EdgeDataType> walkUpdateFunction) {
        super(drunkardJob, walkUpdateFunction);
    }

    @Override
    protected LongDumperThread createDumperThread() {
        return new LongDumperThread(this.bucketQueue, this.pendingWalksToSubmit, this.finished, this.job);
    }

    @Override
    protected DrunkardContext createDrunkardContext(int n, final GraphChiContext graphChiContext, LocalWalkBuffer localWalkBuffer) {
        final LongWalkManager longWalkManager = (LongWalkManager)this.job.getWalkManager();
        final boolean bl = longWalkManager.isSource(n);
        final int n2 = bl ? longWalkManager.getVertexSourceIdx(n) : -1;
        final LongLocalWalkBuffer longLocalWalkBuffer = (LongLocalWalkBuffer)localWalkBuffer;
        return new LongDrunkardContext(){

            @Override
            public boolean isSource() {
                return bl;
            }

            @Override
            public int sourceIndex() {
                return n2;
            }

            @Override
            public int getIteration() {
                return graphChiContext.getIteration();
            }

            @Override
            public void forwardWalkTo(long l, int n, boolean bl2) {
                longLocalWalkBuffer.add(l, n, bl2);
            }

            @Override
            public void resetWalk(long l, boolean bl2) {
                this.forwardWalkTo(l, longWalkManager.getSourceVertex(l), bl2);
            }

            @Override
            public boolean getTrackBit(long l) {
                return longWalkManager.trackBit(l);
            }

            @Override
            public boolean isWalkStartedFromVertex(long l) {
                return n2 == longWalkManager.sourceIdx(l);
            }

            @Override
            public VertexIdTranslate getVertexIdTranslate() {
                return this.getVertexIdTranslate();
            }
        };
    }
}

