/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.graphchi.walks;

import edu.cmu.graphchi.walks.BucketsToSend;
import edu.cmu.graphchi.walks.DrunkardJob;
import edu.cmu.graphchi.walks.DumperThread;
import edu.cmu.graphchi.walks.LongWalkArray;
import edu.cmu.graphchi.walks.LongWalkManager;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class LongDumperThread
extends DumperThread {
    protected final DrunkardJob job;
    protected long[] walks = new long[262144];
    protected int[] vertices = new int[262144];
    protected int idx = 0;

    public LongDumperThread(LinkedBlockingQueue<BucketsToSend> linkedBlockingQueue, AtomicLong atomicLong, AtomicBoolean atomicBoolean, DrunkardJob drunkardJob) {
        super(linkedBlockingQueue, atomicLong, atomicBoolean);
        this.job = drunkardJob;
    }

    @Override
    protected void processWalks(BucketsToSend bucketsToSend, int n) {
        LongWalkArray longWalkArray = (LongWalkArray)bucketsToSend.walks;
        long l = longWalkArray.getArray()[n];
        LongWalkManager longWalkManager = (LongWalkManager)this.job.getWalkManager();
        int n2 = longWalkManager.off(l) + bucketsToSend.firstVertex;
        boolean bl = longWalkManager.trackBit(l);
        if (!bl) {
            return;
        }
        this.walks[this.idx] = l;
        this.vertices[this.idx] = n2;
        ++this.idx;
        if (this.idx >= this.walks.length) {
            try {
                this.job.getCompanion().processWalks(new LongWalkArray(this.walks), this.vertices);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.idx = 0;
        }
    }

    @Override
    protected void sendRest() {
        try {
            long[] lArray = new long[this.idx];
            int[] nArray = new int[this.idx];
            System.arraycopy(this.walks, 0, lArray, 0, this.idx);
            System.arraycopy(this.vertices, 0, nArray, 0, this.idx);
            this.job.getCompanion().processWalks(new LongWalkArray(lArray), nArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

