/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.graphchi.walks;

import com.yammer.metrics.core.TimerContext;
import edu.cmu.graphchi.ChiLogger;
import edu.cmu.graphchi.Scheduler;
import edu.cmu.graphchi.engine.VertexInterval;
import edu.cmu.graphchi.walks.LongWalkArray;
import edu.cmu.graphchi.walks.WalkArray;
import edu.cmu.graphchi.walks.WalkManager;
import edu.cmu.graphchi.walks.WalkSnapshot;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.BitSet;
import java.util.logging.Logger;

public class LongWalkManager
extends WalkManager {
    protected long[][] walks;
    private static final Logger logger = ChiLogger.getLogger("long-walk-manager");

    public LongWalkManager(int n, int n2) {
        super(n, n2);
    }

    @Override
    protected void setSourceAndBucketBits() {
        this.MAX_SOURCES = 0x1000000;
        this.bucketSize = 128;
    }

    protected long encode(int n, boolean bl, int n2) {
        assert (n2 < 128);
        int n3 = bl ? 1 : 0;
        return (n & 0xFFFFFF) << 8 | (n2 & 0x7F) << 1 | n3;
    }

    protected long encodeV(int n, boolean bl, int n2) {
        return this.encode(n, bl, n2 % this.bucketSize);
    }

    protected long encodeNewWalk(int n, int n2, boolean bl) {
        return this.encode(n, bl, n2 % this.bucketSize);
    }

    public int sourceIdx(long l) {
        return (int)((l & 0xFFFFFFFFFFFFFF00L) >> 8) & 0xFFFFFF;
    }

    public boolean trackBit(long l) {
        return (l & 1L) != 0L;
    }

    public int off(long l) {
        return (int)(l >> 1) & 0x7F;
    }

    protected long reencodeWalk(long l, int n, boolean bl) {
        int n2 = n / this.bucketSize;
        return this.encode(this.sourceIdx(l), bl, n % this.bucketSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveWalk(long l, int n, boolean bl) {
        int n2 = n / this.bucketSize;
        Object object = this.bucketLocks[n2];
        synchronized (object) {
            this.moveWalkUnsafe(l, n, bl);
        }
    }

    public void moveWalkUnsafe(long l, int n, boolean bl) {
        l = this.reencodeWalk(l, n, bl);
        int n2 = n / this.bucketSize;
        int n3 = this.walkIndices[n2];
        if (n3 == 0) {
            this.walks[n2] = new long[initialSize];
        } else if (n3 == this.walks[n2].length) {
            long[] lArray = new long[this.walks[n2].length * 3 / 2];
            System.arraycopy(this.walks[n2], 0, lArray, 0, this.walks[n2].length);
            this.walks[n2] = lArray;
        }
        this.walks[n2][n3] = l;
        int n4 = n2;
        this.walkIndices[n4] = this.walkIndices[n4] + 1;
    }

    @Override
    protected void expandCapacity(int n, int n2) {
        if (this.walks[n] != null) {
            int n3 = this.walks[n].length + n2;
            if (this.walks[n].length < n3) {
                long[] lArray = new long[n3];
                System.arraycopy(this.walks[n], 0, lArray, 0, this.walks[n].length);
                this.walks[n] = lArray;
            }
        } else {
            this.walks[n] = new long[n2];
        }
    }

    @Override
    public void initializeWalks() {
        int n;
        int n2;
        int n3;
        this.walks = new long[1 + this.numVertices / this.bucketSize][];
        this.bucketLocks = new Object[this.walks.length];
        for (n3 = 0; n3 < this.bucketLocks.length; ++n3) {
            this.bucketLocks[n3] = new Object();
        }
        this.walkIndices = new int[this.walks.length];
        for (n3 = 0; n3 < this.walks.length; ++n3) {
            this.walks[n3] = null;
            this.walkIndices[n3] = 0;
        }
        if (this.sourceSeqIdx < this.sources.length) {
            logger.info("Truncating...");
            int[] nArray = new int[this.sourceSeqIdx];
            System.arraycopy(this.sources, 0, nArray, 0, this.sourceSeqIdx);
            this.sources = nArray;
        }
        logger.info("Calculate sizes. Walks length:" + this.walks.length);
        int[] nArray = new int[this.walks.length];
        for (n2 = 0; n2 < this.sourceSeqIdx; ++n2) {
            n = this.sources[n2];
            int n4 = n / this.bucketSize;
            nArray[n4] = nArray[n4] + this.sourceWalkCounts[n2];
        }
        logger.info("Expand capacities");
        for (n2 = 0; n2 < this.walks.length; ++n2) {
            this.expandCapacity(n2, nArray[n2]);
        }
        logger.info("Allocating walks");
        for (n2 = 0; n2 < this.sourceSeqIdx; ++n2) {
            n = this.sources[n2];
            int n5 = this.sourceWalkCounts[n2];
            int n6 = n / this.bucketSize;
            int n7 = this.walkIndices[n6];
            for (int i = 0; i < n5; ++i) {
                this.walks[n6][n7++] = this.encodeNewWalk(n2, n, false);
            }
            int n8 = n6;
            this.walkIndices[n8] = this.walkIndices[n8] + n5;
            if (n2 % 100000 != 0) continue;
            logger.info(n2 + " / " + this.sourceSeqIdx);
        }
        this.sourceWalkCounts = null;
        logger.info("Set bitset...");
        for (n2 = 0; n2 < this.sourceSeqIdx; ++n2) {
            this.sourceBitSet.set(this.sources[n2], true);
        }
    }

    @Override
    public WalkSnapshot grabSnapshot(final int n, final int n2) {
        final int n3 = n / this.bucketSize;
        final int n4 = n2 / this.bucketSize;
        final boolean[] blArray = new boolean[n4 - n3 + 1];
        final boolean[] blArray2 = new boolean[1 + n2 - n];
        for (int i = n3; i <= n4; ++i) {
            blArray[i - n3] = false;
        }
        final long[][] lArrayArray = new long[n2 - n + 1][];
        return new WalkSnapshot(){

            @Override
            public void clear(int n5) {
                lArrayArray[n5 - n] = null;
            }

            @Override
            public void restoreUngrabbed() {
                TimerContext timerContext = LongWalkManager.this.restore.time();
                int n5 = n;
                int n22 = 0;
                for (long[] lArray : lArrayArray) {
                    if (lArray != null && !blArray2[n5 - n]) {
                        for (int i = 0; i < lArray.length; ++i) {
                            long l = lArray[i];
                            LongWalkManager.this.moveWalk(l, n5, LongWalkManager.this.trackBit(l));
                            ++n22;
                        }
                    }
                    ++n5;
                }
                logger.info("Restored " + n22);
                timerContext.stop();
            }

            @Override
            public long numWalks() {
                long l = 0L;
                for (int i = n3; i <= n4; ++i) {
                    l += (long)LongWalkManager.this.walks[i].length;
                }
                return l;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public WalkArray getWalksAtVertex(int n13, boolean bl) {
                int n22 = n13 / LongWalkManager.this.bucketSize;
                int n32 = n22 - n / LongWalkManager.this.bucketSize;
                blArray2[n13 - n] = true;
                if (blArray[n32]) {
                    long[] lArray = lArrayArray[n13 - n];
                    if (lArray == null) {
                        return null;
                    }
                    return new LongWalkArray(lArrayArray[n13 - n]);
                }
                TimerContext timerContext = LongWalkManager.this.grabTimer.time();
                long[] lArray = null;
                int n42 = 0;
                Object object = LongWalkManager.this.bucketLocks[n22];
                synchronized (object) {
                    if (!blArray[n32]) {
                        int n5 = LongWalkManager.this.bucketSize * n22;
                        n42 = LongWalkManager.this.walkIndices[n22];
                        lArray = LongWalkManager.this.walks[n22];
                        if (lArray != null) {
                            int n6;
                            int n7;
                            LongWalkManager.this.walks[n22] = null;
                            LongWalkManager.this.walkIndices[n22] = 0;
                            int[] nArray = new int[LongWalkManager.this.bucketSize];
                            int[] nArray2 = new int[LongWalkManager.this.bucketSize];
                            for (n7 = 0; n7 < n42; ++n7) {
                                long l = lArray[n7];
                                int n8 = LongWalkManager.this.off(l);
                                nArray[n8] = nArray[n8] + 1;
                            }
                            n7 = n5 - n;
                            for (n6 = 0; n6 < nArray.length; ++n6) {
                                if (nArray[n6] <= 0 || n6 < -n7 || n6 + n7 >= lArrayArray.length) continue;
                                lArrayArray[n6 + n7] = new long[nArray[n6]];
                            }
                            for (n6 = 0; n6 < n42; ++n6) {
                                long l = lArray[n6];
                                int n9 = n5 + LongWalkManager.this.off(l);
                                if (n9 >= n && n9 <= n2) {
                                    int n10 = n9 - n;
                                    int n11 = n9 - n5;
                                    lArrayArray[n10][nArray2[n11]] = l;
                                    int n12 = n11;
                                    nArray2[n12] = nArray2[n12] + 1;
                                    continue;
                                }
                                LongWalkManager.this.moveWalk(l, n9, LongWalkManager.this.trackBit(l));
                            }
                        }
                        blArray[n32] = true;
                    }
                }
                if (LongWalkManager.this.bucketConsumer != null && lArray != null && n42 > 0) {
                    LongWalkManager.this.bucketConsumer.consume(n22 * LongWalkManager.this.bucketSize, new LongWalkArray(lArray), n42);
                    if (n42 > 1000000) {
                        LongWalkManager.this.log(n22 * LongWalkManager.this.bucketSize + " - " + (n22 + 1) * LongWalkManager.this.bucketSize + ", " + n42);
                    }
                }
                timerContext.stop();
                object = lArrayArray[n13 - n];
                if (object == null) {
                    return null;
                }
                return new LongWalkArray(lArrayArray[n13 - n]);
            }

            @Override
            public int getFirstVertex() {
                return n;
            }

            @Override
            public int getLastVertex() {
                return n2;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dumpToFile(WalkSnapshot walkSnapshot, String string) throws IOException {
        TimerContext timerContext = this.dumpTimer.time();
        String string2 = string.intern();
        synchronized (string2) {
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(new File(string), true)));
            for (int i = walkSnapshot.getFirstVertex(); i <= walkSnapshot.getLastVertex(); ++i) {
                long[] lArray = ((LongWalkArray)walkSnapshot.getWalksAtVertex(i, false)).getArray();
                if (lArray == null) continue;
                for (int j = 0; j < lArray.length; ++j) {
                    long l = lArray[j];
                    int n = this.sources[this.sourceIdx(l)];
                    dataOutputStream.writeLong(n);
                    dataOutputStream.writeInt(i);
                }
            }
            dataOutputStream.flush();
            dataOutputStream.close();
        }
        timerContext.stop();
    }

    public int getSourceVertex(long l) {
        return this.sources[this.sourceIdx(l)];
    }

    @Override
    public void populateSchedulerForInterval(Scheduler scheduler, VertexInterval vertexInterval) {
        TimerContext timerContext = this.schedulePopulate.time();
        int n = vertexInterval.getFirstVertex() / this.bucketSize;
        int n2 = vertexInterval.getLastVertex() / this.bucketSize;
        block0: for (int i = n; i <= n2; ++i) {
            int n3 = i * this.bucketSize;
            long[] lArray = this.walks[i];
            if (lArray == null) continue;
            BitSet bitSet = new BitSet(this.bucketSize);
            int n4 = 0;
            for (int j = 0; j < lArray.length; ++j) {
                int n5 = this.off(lArray[j]);
                if (bitSet.get(n5)) continue;
                bitSet.set(n5, true);
                scheduler.addTask(n3 + n5);
                if (++n4 == this.bucketSize) continue block0;
            }
        }
        timerContext.stop();
    }
}

