/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.graphchi.walks;

import edu.cmu.graphchi.ChiVertex;
import edu.cmu.graphchi.EdgeDirection;
import java.util.Arrays;
import java.util.Random;

public class WeightedHopper {
    public static <VT> int[] generateRandomHopsOut(Random random, ChiVertex<VT, Float> chiVertex, int n) {
        int n2 = chiVertex.numOutEdges();
        float[] fArray = new float[n2];
        float f = 0.0f;
        for (int i = 0; i < n2; ++i) {
            float f2 = chiVertex.getOutEdgeValue(i).floatValue();
            fArray[i] = f + f2;
            f += f2;
        }
        int[] nArray = new int[n];
        block1: for (int i = 0; i < n; ++i) {
            int n3;
            float f3 = f * random.nextFloat();
            if (n2 > 32) {
                n3 = Arrays.binarySearch(fArray, f3);
                if (n3 < 0) {
                    n3 = -(n3 + 1);
                }
                nArray[i] = n3;
                continue;
            }
            for (n3 = 0; n3 < n2; ++n3) {
                if (!(fArray[n3] > f3)) continue;
                nArray[i] = n3;
                continue block1;
            }
        }
        return nArray;
    }

    public static <VT> int[] generateRandomHopsAliasMethodOut(Random random, ChiVertex<VT, Float> chiVertex, int n) {
        return WeightedHopper.generateRandomHopsAliasMethod(random, chiVertex, n, EdgeDirection.OUT_EDGES, null);
    }

    public static <VT> int[] generateRandomHopsAliasMethod(Random random, ChiVertex<VT, Float> chiVertex, int n, EdgeDirection edgeDirection, EdgeWeightMap edgeWeightMap) {
        int n2;
        int n3;
        int n4 = 0;
        switch (edgeDirection) {
            case IN_AND_OUT_EDGES: {
                n4 = chiVertex.numEdges();
                break;
            }
            case OUT_EDGES: {
                n4 = chiVertex.numOutEdges();
                break;
            }
            case IN_EDGES: {
                n4 = chiVertex.numInEdges();
            }
        }
        float[] fArray = new float[n4];
        int[] nArray = new int[n4];
        float f = 0.0f;
        for (int i = 0; i < n4; ++i) {
            float f2 = 0.0f;
            switch (edgeDirection) {
                case IN_AND_OUT_EDGES: {
                    f2 = chiVertex.edge(i).getValue().floatValue();
                    break;
                }
                case OUT_EDGES: {
                    f2 = chiVertex.getOutEdgeValue(i).floatValue();
                    break;
                }
                case IN_EDGES: {
                    f2 = chiVertex.inEdge(i).getValue().floatValue();
                }
            }
            if (edgeWeightMap != null) {
                f2 = edgeWeightMap.map(f2);
            }
            f += f2;
            fArray[i] = f2;
        }
        int[] nArray2 = new int[n4];
        int[] nArray3 = new int[n4];
        int n5 = 0;
        int n6 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            fArray[n3] = fArray[n3] / f * (float)n4;
            if (fArray[n3] < 1.0f) {
                nArray3[n6++] = n3;
            } else {
                nArray2[n5++] = n3;
            }
            nArray[n3] = -1;
        }
        while (n5 > 0 && n6 > 0) {
            n3 = nArray3[--n6];
            nArray[n3] = n2 = nArray2[--n5];
            fArray[n2] = fArray[n2] - (1.0f - fArray[n3]);
            if (fArray[n2] < 1.0f) {
                nArray3[n6++] = n2;
                continue;
            }
            nArray2[n5++] = n2;
        }
        while (n5 > 0) {
            fArray[nArray2[--n5]] = 1.0f;
        }
        while (n6 > 0) {
            fArray[nArray3[--n6]] = 1.0f;
        }
        int[] nArray4 = new int[n];
        for (n2 = 0; n2 < n; ++n2) {
            int n7 = random.nextInt(n4);
            float f3 = random.nextFloat();
            if (f3 < fArray[n7]) {
                nArray4[n2] = n7;
                continue;
            }
            nArray4[n2] = nArray[n7];
            if (nArray4[n2] >= 0) continue;
            nArray4[n2] = n7;
        }
        return nArray4;
    }

    public static interface EdgeWeightMap {
        public float map(float var1);
    }
}

