/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.graphchi.walks.distributions;

import edu.cmu.graphchi.ChiLogger;
import edu.cmu.graphchi.util.IdCount;
import edu.cmu.graphchi.util.IntegerBuffer;
import edu.cmu.graphchi.walks.WalkArray;
import edu.cmu.graphchi.walks.distributions.DiscreteDistribution;
import edu.cmu.graphchi.walks.distributions.IntDrunkardCompanion;
import edu.cmu.graphchi.walks.distributions.RemoteDrunkardCompanion;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.UnicastRemoteObject;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

public abstract class DrunkardCompanion
extends UnicastRemoteObject
implements RemoteDrunkardCompanion {
    protected static final int BUFFER_CAPACITY = 128;
    protected static final int BUFFER_MAX = 128;
    protected int[] sourceVertexIds;
    protected Object[] distrLocks;
    boolean isLowInMemory = false;
    protected DiscreteDistribution[] distributions;
    protected IntegerBuffer[] buffers;
    protected AtomicInteger outstanding = new AtomicInteger(0);
    protected ExecutorService parallelExecutor;
    protected long maxMemoryBytes;
    protected LinkedBlockingQueue<WalkSubmission> pendingQueue = new LinkedBlockingQueue();
    protected static Logger logger = ChiLogger.getLogger("drunkardcompanion");
    protected Timer timer = new Timer(true);
    private boolean closed = false;

    private long memoryAuditReport() {
        long l;
        long l2 = 0L;
        l2 += (long)(this.sourceVertexIds.length * 4);
        l2 += (long)(this.distrLocks.length * 4);
        long l3 = 0L;
        long l4 = 0L;
        for (IntegerBuffer integerBuffer : this.buffers) {
            l = integerBuffer.memorySizeEst();
            l3 += l;
            l4 = Math.max(l4, l);
        }
        long l5 = 0L;
        long l6 = 0L;
        l = 0L;
        for (DiscreteDistribution discreteDistribution : this.distributions) {
            long l7 = discreteDistribution.memorySizeEst();
            l5 += l7;
            l6 = Math.max(l7, l6);
            l += (long)(discreteDistribution.avoidCount() * 6);
        }
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
        logger.info("======= MEMORY REPORT ======");
        logger.info("Companion internal: " + numberFormat.format((double)l2 / 1024.0 / 1024.0) + " mb");
        logger.info("Buffer mem: " + numberFormat.format((double)l3 / 1024.0 / 1024.0) + " mb");
        logger.info("Avg bytes per buffer: " + numberFormat.format((double)l3 * 1.0 / (double)this.buffers.length / 1024.0) + " kb");
        logger.info("Max buffer was: " + numberFormat.format((double)l4 / 1024.0) + "kb");
        logger.info("Distribution mem: " + numberFormat.format((double)l5 / 1024.0 / 1024.0) + " mb");
        logger.info("- of which avoids: " + numberFormat.format((double)l / 1024.0 / 1024.0) + " mb");
        logger.info("Avg bytes per distribution: " + numberFormat.format((double)l5 * 1.0 / (double)this.distributions.length / 1024.0) + " kb");
        logger.info("Max distribution: " + numberFormat.format((double)l6 / 1024.0) + " kb");
        long l8 = l2 + l3 + l5;
        logger.info("** Total:  " + numberFormat.format((double)l8 / 1024.0 / 1024.0 / 1024.0) + " GB (low-mem limit " + (double)Runtime.getRuntime().maxMemory() * 0.25 / 1024.0 / 1024.0 / 1024.0 + "GB)");
        boolean bl = this.isLowInMemory = l8 > this.maxMemoryBytes;
        if (this.isLowInMemory) {
            this.compactMemoryUsage();
        }
        return l8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compactMemoryUsage() {
        long l = 0L;
        long l2 = 0L;
        for (int i = 0; i < this.distributions.length; ++i) {
            DiscreteDistribution discreteDistribution;
            DiscreteDistribution discreteDistribution2;
            Object object = this.distrLocks[i];
            synchronized (object) {
                discreteDistribution2 = this.distributions[i];
                this.distributions[i] = discreteDistribution = discreteDistribution2.filteredAndShift(2);
            }
            l += (long)discreteDistribution2.memorySizeEst();
            l2 += (long)discreteDistribution.memorySizeEst();
        }
        logger.info("** Compacted: " + (double)l / 1024.0 / 1024.0 / 1024.0 + " GB --> " + (double)l2 / 1024.0 / 1024.0 / 1024.0 + " GB");
    }

    public DrunkardCompanion(final int n, long l) throws RemoteException {
        this.maxMemoryBytes = l;
        this.parallelExecutor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        int n2 = 0;
        while (n2 < n) {
            final int n3 = n2++;
            Thread thread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        long l = 0L;
                        while (!DrunkardCompanion.this.closed) {
                            WalkSubmission walkSubmission = DrunkardCompanion.this.pendingQueue.poll(2000L, TimeUnit.MILLISECONDS);
                            if (walkSubmission != null) {
                                DrunkardCompanion.this._processWalks(walkSubmission.walks, walkSubmission.atVertices);
                                l += (long)walkSubmission.walks.size();
                            }
                            if (DrunkardCompanion.this.sourceVertexIds == null || l <= (long)(DrunkardCompanion.this.sourceVertexIds.length * 10) && (walkSubmission != null || l <= 100000L)) continue;
                            logger.fine("Purge:" + l);
                            l = 0L;
                            for (int i = n3; i < DrunkardCompanion.this.sourceVertexIds.length; i += n) {
                                if (DrunkardCompanion.this.buffers[i].size() < 128 && !DrunkardCompanion.this.closed) continue;
                                DrunkardCompanion.this.outstanding.incrementAndGet();
                                final IntegerBuffer integerBuffer = DrunkardCompanion.this.buffers[i];
                                final int n2 = i;
                                IntegerBuffer integerBuffer2 = DrunkardCompanion.this.buffers[i];
                                synchronized (integerBuffer2) {
                                    DrunkardCompanion.this.buffers[i] = new IntegerBuffer(128);
                                }
                                DrunkardCompanion.this.parallelExecutor.submit(new Runnable(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public void run() {
                                        try {
                                            int[] nArray = integerBuffer.toIntArray();
                                            Arrays.sort(nArray);
                                            DiscreteDistribution discreteDistribution = new DiscreteDistribution(nArray);
                                            DrunkardCompanion.this.mergeWith(n2, discreteDistribution);
                                        }
                                        catch (Exception exception) {
                                            exception.printStackTrace();
                                        }
                                        finally {
                                            DrunkardCompanion.this.outstanding.decrementAndGet();
                                        }
                                    }
                                });
                            }
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
            thread.setDaemon(true);
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeWith(int n, DiscreteDistribution discreteDistribution) {
        Object object = this.distrLocks[n];
        synchronized (object) {
            this.distributions[n] = DiscreteDistribution.merge(this.distributions[n], discreteDistribution);
        }
    }

    @Override
    public void setAvoidList(int n, int[] nArray) throws RemoteException {
        Arrays.sort(nArray);
        DiscreteDistribution discreteDistribution = DiscreteDistribution.createAvoidanceDistribution(nArray);
        this.mergeWith(n, discreteDistribution);
    }

    @Override
    public void setSources(int[] nArray) throws RemoteException {
        this.timer.cancel();
        this.timer = new Timer(true);
        logger.info("Initializing sources...");
        this.buffers = new IntegerBuffer[nArray.length];
        this.sourceVertexIds = new int[nArray.length];
        this.distrLocks = new Object[nArray.length];
        this.distributions = new DiscreteDistribution[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            this.distrLocks[i] = new Object();
            this.sourceVertexIds[i] = nArray[i];
            this.buffers[i] = new IntegerBuffer(128);
            this.distributions[i] = DiscreteDistribution.createAvoidanceDistribution(new int[]{nArray[i]});
        }
        logger.info("Done...");
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                DrunkardCompanion.this.memoryAuditReport();
            }
        }, 5000L, 60000L);
    }

    protected abstract void _processWalks(WalkArray var1, int[] var2);

    @Override
    public IdCount[] getTop(int n, int n2) throws RemoteException {
        int n3;
        int n4 = n3 = this.sourceVertexIds == null ? -1 : Arrays.binarySearch(this.sourceVertexIds, n);
        if (n3 >= 0) {
            int[] nArray = this.buffers[n3].toIntArray();
            this.drainBuffer(n3);
            return this.distributions[n3].getTop(n2);
        }
        throw new IllegalArgumentException("Vertex not found from memory. ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drainBuffer(int n) {
        IntegerBuffer integerBuffer = this.buffers[n];
        synchronized (integerBuffer) {
            int[] nArray = this.buffers[n].toIntArray();
            this.buffers[n] = new IntegerBuffer(128);
            Arrays.sort(nArray);
            DiscreteDistribution discreteDistribution = new DiscreteDistribution(nArray);
            this.mergeWith(n, discreteDistribution);
        }
    }

    @Override
    public void processWalks(WalkArray walkArray, int[] nArray) throws RemoteException {
        try {
            this.pendingQueue.put(new WalkSubmission(walkArray, nArray));
            int n = this.pendingQueue.size();
            if (n > 50 && n % 20 == 0) {
                logger.info("Warning, pending queue size: " + n);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void outputDistributions(String string) throws RemoteException {
        this.outputDistributions(string, 10);
    }

    @Override
    public void outputDistributions(String string, int n) throws RemoteException {
        logger.info("Waiting for processing to finish");
        while (this.outstanding.get() > 0) {
            logger.info("...");
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        logger.info("Write output...");
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(new File(string))));
            for (int i = 0; i < this.sourceVertexIds.length; ++i) {
                int n2 = this.sourceVertexIds[i];
                this.drainBuffer(i);
                DiscreteDistribution discreteDistribution = this.distributions[i];
                IdCount[] idCountArray = discreteDistribution.getTop(n);
                dataOutputStream.writeInt(n2);
                int n3 = 0;
                for (IdCount idCount : idCountArray) {
                    dataOutputStream.writeInt(idCount.id);
                    dataOutputStream.writeInt(idCount.count);
                    ++n3;
                }
                while (n3 < n) {
                    ++n3;
                    dataOutputStream.writeInt(-1);
                    dataOutputStream.writeInt(-1);
                }
            }
            dataOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void close() {
        this.closed = true;
        this.timer.cancel();
    }

    public static void main(String[] stringArray) throws Exception {
        Double d = Double.parseDouble(stringArray[0]);
        String string = stringArray[1];
        try {
            LocateRegistry.createRegistry(1099);
        }
        catch (Exception exception) {
            logger.info("Registry already created?");
        }
        Naming.rebind(string, new IntDrunkardCompanion(4, (long)((double)Runtime.getRuntime().maxMemory() * 0.75)));
        logger.info("Prune fraction: " + d);
    }

    protected static class WalkSubmission {
        WalkArray walks;
        int[] atVertices;

        private WalkSubmission(WalkArray walkArray, int[] nArray) {
            this.walks = walkArray;
            this.atVertices = nArray;
        }
    }
}

