/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class BufferedDataInputStream
extends BufferedInputStream
implements DataInput {
    private long bufferOffset = 0L;
    private int primitiveArrayCount;
    byte[] savedIntByte = new byte[4];

    public BufferedDataInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public BufferedDataInputStream(InputStream inputStream, int n) {
        super(inputStream, n);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n2 > 0) {
            int n4 = super.read(byArray, n + n3, n2);
            if (n4 <= 0) {
                if (n3 == 0) {
                    throw new EOFException();
                }
                return n3;
            }
            n2 -= n4;
            n3 += n4;
        }
        return n3;
    }

    @Override
    public int read() throws IOException {
        return super.read();
    }

    @Override
    public long skip(long l) throws IOException {
        long l2 = 0L;
        while (l > 0L) {
            long l3 = super.skip(l);
            if (l3 == 0L) {
                return l2;
            }
            l -= l3;
            l2 += l3;
        }
        return l2;
    }

    @Override
    public boolean readBoolean() throws IOException {
        int n = this.read();
        return n == 1;
    }

    @Override
    public byte readByte() throws IOException {
        return (byte)this.read();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.read() & 0xFF;
    }

    @Override
    public int readInt() throws IOException {
        byte[] byArray = new byte[4];
        if (this.read(byArray, 0, 4) < 4) {
            throw new EOFException();
        }
        int n = byArray[0] << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
        return n;
    }

    public int readIntReversed() throws IOException {
        this.read(this.savedIntByte, 0, 4);
        int n = this.savedIntByte[3] << 24 | (this.savedIntByte[2] & 0xFF) << 16 | (this.savedIntByte[1] & 0xFF) << 8 | this.savedIntByte[0] & 0xFF;
        return n;
    }

    @Override
    public short readShort() throws IOException {
        byte[] byArray = new byte[2];
        if (this.read(byArray, 0, 2) < 2) {
            throw new EOFException();
        }
        short s = (short)(byArray[0] << 8 | byArray[1] & 0xFF);
        return s;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        byte[] byArray = new byte[2];
        if (this.read(byArray, 0, 2) < 2) {
            throw new EOFException();
        }
        return (byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF;
    }

    @Override
    public char readChar() throws IOException {
        byte[] byArray = new byte[2];
        if (this.read(byArray, 0, 2) < 2) {
            throw new EOFException();
        }
        char c = (char)(byArray[0] << 8 | byArray[1] & 0xFF);
        return c;
    }

    @Override
    public long readLong() throws IOException {
        byte[] byArray = new byte[8];
        if (this.read(byArray, 0, 8) < 8) {
            throw new EOFException();
        }
        int n = byArray[0] << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
        int n2 = byArray[4] << 24 | (byArray[5] & 0xFF) << 16 | (byArray[6] & 0xFF) << 8 | byArray[7] & 0xFF;
        return (long)n << 32 | (long)n2 & 0xFFFFFFFFL;
    }

    @Override
    public float readFloat() throws IOException {
        byte[] byArray = new byte[4];
        if (this.read(byArray, 0, 4) < 4) {
            throw new EOFException();
        }
        int n = byArray[0] << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
        return Float.intBitsToFloat(n);
    }

    @Override
    public double readDouble() throws IOException {
        byte[] byArray = new byte[8];
        if (this.read(byArray, 0, 8) < 8) {
            throw new EOFException();
        }
        int n = byArray[0] << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
        int n2 = byArray[4] << 24 | (byArray[5] & 0xFF) << 16 | (byArray[6] & 0xFF) << 8 | byArray[7] & 0xFF;
        return Double.longBitsToDouble((long)n << 32 | (long)n2 & 0xFFFFFFFFL);
    }

    @Override
    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    @Override
    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IOException("Attempt to read outside byte array");
        }
        if (this.read(byArray, n, n2) < n2) {
            throw new EOFException();
        }
    }

    @Override
    public int skipBytes(int n) throws IOException {
        if (this.skip(n) < (long)n) {
            throw new EOFException();
        }
        return n;
    }

    @Override
    public String readUTF() throws IOException {
        DataInputStream dataInputStream = new DataInputStream(this);
        return dataInputStream.readUTF();
    }

    @Override
    public String readLine() throws IOException {
        DataInputStream dataInputStream = new DataInputStream(this);
        return dataInputStream.readLine();
    }

    public int readPrimitiveArray(Object object) throws IOException {
        this.primitiveArrayCount = 0;
        return this.primitiveArrayRecurse(object);
    }

    protected int primitiveArrayRecurse(Object object) throws IOException {
        if (object == null) {
            return this.primitiveArrayCount;
        }
        String string = object.getClass().getName();
        if (string.charAt(0) != '[') {
            throw new IOException("Invalid object passed to BufferedDataInputStream.readArray:" + string);
        }
        if (string.charAt(1) == '[') {
            for (int i = 0; i < ((Object[])object).length; ++i) {
                this.primitiveArrayRecurse(((Object[])object)[i]);
            }
        } else {
            switch (string.charAt(1)) {
                case 'Z': {
                    this.primitiveArrayCount += this.readBooleanArray((boolean[])object);
                    break;
                }
                case 'B': {
                    int n = this.read((byte[])object, 0, ((byte[])object).length);
                    if (n < ((byte[])object).length) {
                        this.primitiveArrayCount += n;
                        this.primitiveEOFThrower();
                    }
                    this.primitiveArrayCount += n;
                    break;
                }
                case 'C': {
                    this.primitiveArrayCount += this.readCharArray((char[])object);
                    break;
                }
                case 'S': {
                    this.primitiveArrayCount += this.readShortArray((short[])object);
                    break;
                }
                case 'I': {
                    this.primitiveArrayCount += this.readIntArray((int[])object);
                    break;
                }
                case 'J': {
                    this.primitiveArrayCount += this.readLongArray((long[])object);
                    break;
                }
                case 'F': {
                    this.primitiveArrayCount += this.readFloatArray((float[])object);
                    break;
                }
                case 'D': {
                    this.primitiveArrayCount += this.readDoubleArray((double[])object);
                    break;
                }
                case 'L': {
                    if (string.equals("[Ljava.lang.Object;")) {
                        for (int i = 0; i < ((Object[])object).length; ++i) {
                            this.primitiveArrayRecurse(((Object[])object)[i]);
                        }
                        break;
                    }
                    throw new IOException("Invalid object passed to BufferedDataInputStream.readArray: " + string);
                }
                default: {
                    throw new IOException("Invalid object passed to BufferedDataInputStream.readArray: " + string);
                }
            }
        }
        return this.primitiveArrayCount;
    }

    protected int readBooleanArray(boolean[] blArray) throws IOException {
        byte[] byArray = new byte[blArray.length];
        if (this.read(byArray, 0, byArray.length) < byArray.length) {
            this.primitiveEOFThrower();
        }
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = byArray[i] == 1;
        }
        return byArray.length;
    }

    protected int readShortArray(short[] sArray) throws IOException {
        if (sArray.length == 0) {
            return 0;
        }
        byte[] byArray = new byte[2 * sArray.length];
        if (this.read(byArray, 0, byArray.length) < byArray.length) {
            this.primitiveEOFThrower();
        }
        char c = (char)(byArray[0] << 8 | byArray[1]);
        for (int i = 0; i < sArray.length; ++i) {
            sArray[i] = (short)(byArray[2 * i] << 8 | byArray[2 * i + 1] & 0xFF);
        }
        return byArray.length;
    }

    protected int readCharArray(char[] cArray) throws IOException {
        byte[] byArray = new byte[2 * cArray.length];
        if (this.read(byArray, 0, byArray.length) < byArray.length) {
            this.primitiveEOFThrower();
        }
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = (char)(byArray[2 * i] << 8 | byArray[2 * i + 1] & 0xFF);
        }
        return byArray.length;
    }

    protected int readIntArray(int[] nArray) throws IOException {
        byte[] byArray = new byte[4 * nArray.length];
        if (this.read(byArray, 0, byArray.length) < byArray.length) {
            this.primitiveEOFThrower();
        }
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = byArray[4 * i] << 24 | (byArray[4 * i + 1] & 0xFF) << 16 | (byArray[4 * i + 2] & 0xFF) << 8 | byArray[4 * i + 3] & 0xFF;
        }
        return byArray.length;
    }

    protected int readLongArray(long[] lArray) throws IOException {
        byte[] byArray = new byte[8 * lArray.length];
        if (this.read(byArray, 0, byArray.length) < byArray.length) {
            this.primitiveEOFThrower();
        }
        for (int i = 0; i < lArray.length; ++i) {
            int n = byArray[8 * i] << 24 | (byArray[8 * i + 1] & 0xFF) << 16 | (byArray[8 * i + 2] & 0xFF) << 8 | byArray[8 * i + 3] & 0xFF;
            int n2 = byArray[8 * i + 4] << 24 | (byArray[8 * i + 5] & 0xFF) << 16 | (byArray[8 * i + 6] & 0xFF) << 8 | byArray[8 * i + 7] & 0xFF;
            lArray[i] = (long)n << 32 | (long)n2 & 0xFFFFFFFFL;
        }
        return byArray.length;
    }

    protected int readFloatArray(float[] fArray) throws IOException {
        byte[] byArray = new byte[4 * fArray.length];
        if (this.read(byArray, 0, byArray.length) < byArray.length) {
            this.primitiveEOFThrower();
        }
        for (int i = 0; i < fArray.length; ++i) {
            int n = byArray[4 * i] << 24 | (byArray[4 * i + 1] & 0xFF) << 16 | (byArray[4 * i + 2] & 0xFF) << 8 | byArray[4 * i + 3] & 0xFF;
            fArray[i] = Float.intBitsToFloat(n);
        }
        return byArray.length;
    }

    protected int readDoubleArray(double[] dArray) throws IOException {
        byte[] byArray = new byte[8 * dArray.length];
        if (this.read(byArray, 0, byArray.length) < byArray.length) {
            this.primitiveEOFThrower();
        }
        for (int i = 0; i < dArray.length; ++i) {
            int n = byArray[8 * i] << 24 | (byArray[8 * i + 1] & 0xFF) << 16 | (byArray[8 * i + 2] & 0xFF) << 8 | byArray[8 * i + 3] & 0xFF;
            int n2 = byArray[8 * i + 4] << 24 | (byArray[8 * i + 5] & 0xFF) << 16 | (byArray[8 * i + 6] & 0xFF) << 8 | byArray[8 * i + 7] & 0xFF;
            dArray[i] = Double.longBitsToDouble((long)n << 32 | (long)n2 & 0xFFFFFFFFL);
        }
        return byArray.length;
    }

    protected void primitiveEOFThrower() throws EOFException {
        throw new EOFException("EOF on primitive array read after " + this.primitiveArrayCount + " bytes.");
    }

    public void printStatus() {
        System.out.println("BufferedDataInputStream:");
        System.out.println("    count=" + this.count);
        System.out.println("      pos=" + this.pos);
    }

    public String toString() {
        return "BufferedDataInputStream[count=" + this.count + ",pos=" + this.pos + "]";
    }
}

