/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.io;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class RandomAccessFile
implements DataInput,
DataOutput {
    public static final int BIG_ENDIAN = 0;
    public static final int LITTLE_ENDIAN = 1;
    protected static boolean debugLeaks = false;
    protected static boolean debugAccess = false;
    protected static Set<String> allFiles = new HashSet<String>();
    protected static List<String> openFiles = Collections.synchronizedList(new ArrayList());
    private static AtomicInteger debug_nseeks = new AtomicInteger();
    private static AtomicLong debug_nbytes = new AtomicLong();
    protected static boolean showOpen = false;
    protected static boolean showRead = false;
    protected static final int defaultBufferSize = 262144;
    protected String location;
    protected java.io.RandomAccessFile file;
    protected FileChannel fileChannel;
    protected long filePosition;
    protected byte[] buffer;
    protected long bufferStart;
    protected long dataEnd;
    protected int dataSize;
    protected boolean endOfFile;
    protected boolean readonly;
    protected boolean bigEndian;
    boolean bufferModified = false;
    private long minLength = 0L;
    boolean extendMode = false;

    public static boolean getDebugLeaks() {
        return debugLeaks;
    }

    public static void setDebugLeaks(boolean bl) {
        debugLeaks = bl;
    }

    public static List<String> getOpenFiles() {
        return openFiles;
    }

    public static List<String> getAllFiles() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (null == allFiles) {
            return null;
        }
        Iterator<String> iterator = allFiles.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public static void setDebugAccess(boolean bl) {
        debugAccess = bl;
        if (bl) {
            debug_nseeks = new AtomicInteger();
            debug_nbytes = new AtomicLong();
        }
    }

    public static int getDebugNseeks() {
        return debug_nseeks == null ? 0 : debug_nseeks.intValue();
    }

    public static long getDebugNbytes() {
        return debug_nbytes == null ? 0L : debug_nbytes.longValue();
    }

    protected RandomAccessFile(int n) {
        this.file = null;
        this.readonly = true;
        this.init(n);
    }

    public RandomAccessFile(String string, String string2) throws IOException {
        this(string, string2, 262144);
        this.location = string;
    }

    public RandomAccessFile(String string, String string2, int n) throws IOException {
        this.location = string;
        if (debugLeaks) {
            allFiles.add(string);
        }
        this.file = new java.io.RandomAccessFile(string, string2);
        this.readonly = string2.equals("r");
        this.init(n);
        if (debugLeaks) {
            openFiles.add(string);
            if (showOpen) {
                System.out.println("  open " + string);
            }
        }
    }

    public java.io.RandomAccessFile getRandomAccessFile() {
        return this.file;
    }

    private void init(int n) {
        this.bufferStart = 0L;
        this.dataEnd = 0L;
        this.dataSize = 0;
        this.filePosition = 0L;
        this.buffer = new byte[n];
        this.endOfFile = false;
    }

    public void setBufferSize(int n) {
        this.init(n);
    }

    public int getBufferSize() {
        return this.buffer.length;
    }

    public void close() throws IOException {
        if (debugLeaks) {
            openFiles.remove(this.location);
            if (showOpen) {
                System.out.println("  close " + this.location);
            }
        }
        if (this.file == null) {
            return;
        }
        this.flush();
        long l = this.file.length();
        if (!this.readonly && this.minLength != 0L && this.minLength != l) {
            this.file.setLength(this.minLength);
        }
        this.file.close();
        this.file = null;
    }

    public boolean isAtEndOfFile() {
        return this.endOfFile;
    }

    public void seek(long l) throws IOException {
        if (l >= this.bufferStart && l < this.dataEnd) {
            this.filePosition = l;
            return;
        }
        this.readBuffer(l);
    }

    protected void readBuffer(long l) throws IOException {
        if (this.bufferModified) {
            this.flush();
        }
        this.bufferStart = l;
        this.filePosition = l;
        this.dataSize = this.read_(l, this.buffer, 0, this.buffer.length);
        if (this.dataSize <= 0) {
            this.dataSize = 0;
            this.endOfFile = true;
        } else {
            this.endOfFile = false;
        }
        this.dataEnd = this.bufferStart + (long)this.dataSize;
    }

    public long getFilePointer() throws IOException {
        return this.filePosition;
    }

    public String getLocation() {
        return this.location;
    }

    public long length() throws IOException {
        long l = this.file.length();
        if (l < this.dataEnd) {
            return this.dataEnd;
        }
        return l;
    }

    public void order(int n) {
        if (n < 0) {
            return;
        }
        this.bigEndian = n == 0;
    }

    public FileDescriptor getFD() throws IOException {
        return this.file == null ? null : this.file.getFD();
    }

    public void flush() throws IOException {
        if (this.bufferModified) {
            this.file.seek(this.bufferStart);
            this.file.write(this.buffer, 0, this.dataSize);
            this.bufferModified = false;
        }
    }

    public void setMinLength(long l) {
        this.minLength = l;
    }

    public void setExtendMode() {
        this.extendMode = true;
    }

    public int read() throws IOException {
        if (this.filePosition < this.dataEnd) {
            int n = (int)(this.filePosition - this.bufferStart);
            ++this.filePosition;
            return this.buffer[n] & 0xFF;
        }
        if (this.endOfFile) {
            return -1;
        }
        this.seek(this.filePosition);
        return this.read();
    }

    protected int readBytes(byte[] byArray, int n, int n2) throws IOException {
        if (this.endOfFile) {
            return -1;
        }
        int n3 = (int)(this.dataEnd - this.filePosition);
        if (n3 < 1) {
            this.seek(this.filePosition);
            return this.readBytes(byArray, n, n2);
        }
        int n4 = n3 >= n2 ? n2 : n3;
        System.arraycopy(this.buffer, (int)(this.filePosition - this.bufferStart), byArray, n, n4);
        this.filePosition += (long)n4;
        if (n4 < n2) {
            int n5 = n2 - n4;
            if (n5 > this.buffer.length) {
                n5 = this.read_(this.filePosition, byArray, n + n4, n2 - n4);
            } else {
                this.seek(this.filePosition);
                if (!this.endOfFile) {
                    n5 = n5 > this.dataSize ? this.dataSize : n5;
                    System.arraycopy(this.buffer, 0, byArray, n + n4, n5);
                } else {
                    n5 = -1;
                }
            }
            if (n5 > 0) {
                this.filePosition += (long)n5;
                return n4 + n5;
            }
        }
        return n4;
    }

    public long readToByteChannel(WritableByteChannel writableByteChannel, long l, long l2) throws IOException {
        if (this.fileChannel == null) {
            this.fileChannel = this.file.getChannel();
        }
        long l3 = l2;
        while (l3 > 0L) {
            long l4 = this.fileChannel.transferTo(l, l3, writableByteChannel);
            l3 -= l4;
            l += l4;
        }
        return l2 - l3;
    }

    protected int read_(long l, byte[] byArray, int n, int n2) throws IOException {
        this.file.seek(l);
        int n3 = this.file.read(byArray, n, n2);
        if (debugAccess) {
            if (showRead) {
                System.out.println(" **read_ " + this.location + " = " + n2 + " bytes at " + l + "; block = " + l / (long)this.buffer.length);
            }
            debug_nseeks.incrementAndGet();
            debug_nbytes.addAndGet(n2);
        }
        if (this.extendMode && n3 < n2) {
            n3 = n2;
        }
        return n3;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.readBytes(byArray, n, n2);
    }

    public int read(byte[] byArray) throws IOException {
        return this.readBytes(byArray, 0, byArray.length);
    }

    public byte[] readBytes(int n) throws IOException {
        byte[] byArray = new byte[n];
        this.readFully(byArray);
        return byArray;
    }

    @Override
    public final void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    @Override
    public final void readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        for (int i = 0; i < n2; i += n3) {
            n3 = this.read(byArray, n + i, n2 - i);
            if (n3 >= 0) continue;
            throw new EOFException();
        }
    }

    @Override
    public int skipBytes(int n) throws IOException {
        this.seek(this.getFilePointer() + (long)n);
        return n;
    }

    public void unread() {
        --this.filePosition;
    }

    @Override
    public void write(int n) throws IOException {
        if (this.filePosition < this.dataEnd) {
            int n2 = (int)(this.filePosition - this.bufferStart);
            this.buffer[n2] = (byte)n;
            this.bufferModified = true;
            ++this.filePosition;
        } else if (this.dataSize != this.buffer.length) {
            int n3 = (int)(this.filePosition - this.bufferStart);
            this.buffer[n3] = (byte)n;
            this.bufferModified = true;
            ++this.filePosition;
            ++this.dataSize;
            ++this.dataEnd;
        } else {
            this.seek(this.filePosition);
            this.write(n);
        }
    }

    public void writeBytes(byte[] byArray, int n, int n2) throws IOException {
        if (n2 < this.buffer.length) {
            long l;
            int n3 = 0;
            int n4 = 0;
            if (this.filePosition >= this.bufferStart) {
                n3 = (int)(this.bufferStart + (long)this.buffer.length - this.filePosition);
            }
            if (n3 > 0) {
                n4 = n3 > n2 ? n2 : n3;
                System.arraycopy(byArray, n, this.buffer, (int)(this.filePosition - this.bufferStart), n4);
                this.bufferModified = true;
                l = this.filePosition + (long)n4;
                this.dataEnd = l > this.dataEnd ? l : this.dataEnd;
                this.dataSize = (int)(this.dataEnd - this.bufferStart);
                this.filePosition += (long)n4;
            }
            if (n4 < n2) {
                this.seek(this.filePosition);
                System.arraycopy(byArray, n + n4, this.buffer, (int)(this.filePosition - this.bufferStart), n2 - n4);
                this.bufferModified = true;
                l = this.filePosition + (long)(n2 - n4);
                this.dataEnd = l > this.dataEnd ? l : this.dataEnd;
                this.dataSize = (int)(this.dataEnd - this.bufferStart);
                this.filePosition += (long)(n2 - n4);
            }
        } else {
            if (this.bufferModified) {
                this.flush();
            }
            this.file.seek(this.filePosition);
            this.file.write(byArray, n, n2);
            this.filePosition += (long)n2;
            this.bufferStart = this.filePosition;
            this.dataSize = 0;
            this.dataEnd = this.bufferStart + (long)this.dataSize;
        }
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.writeBytes(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.writeBytes(byArray, n, n2);
    }

    @Override
    public final boolean readBoolean() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n != 0;
    }

    @Override
    public final byte readByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return (byte)n;
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    @Override
    public final short readShort() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        if (this.bigEndian) {
            return (short)((n2 << 8) + n);
        }
        return (short)((n << 8) + n2);
    }

    public final void readShort(short[] sArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            sArray[n + i] = this.readShort();
        }
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        if (this.bigEndian) {
            return (n2 << 8) + n;
        }
        return (n << 8) + n2;
    }

    @Override
    public final char readChar() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        if (this.bigEndian) {
            return (char)((n2 << 8) + n);
        }
        return (char)((n << 8) + n2);
    }

    @Override
    public final int readInt() throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = this.read();
        if ((n4 | (n3 = this.read()) | (n2 = this.read()) | (n = this.read())) < 0) {
            throw new EOFException();
        }
        if (this.bigEndian) {
            return (n4 << 24) + (n3 << 16) + (n2 << 8) + n;
        }
        return (n << 24) + (n2 << 16) + (n3 << 8) + n4;
    }

    public final int readIntUnbuffered(long l) throws IOException {
        byte[] byArray = new byte[4];
        this.read_(l, byArray, 0, 4);
        int n = byArray[0] & 0xFF;
        int n2 = byArray[1] & 0xFF;
        int n3 = byArray[2] & 0xFF;
        int n4 = byArray[3] & 0xFF;
        if ((n | n2 | n3 | n4) < 0) {
            throw new EOFException();
        }
        if (this.bigEndian) {
            return (n << 24) + (n2 << 16) + (n3 << 8) + n4;
        }
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + n;
    }

    public final void readInt(int[] nArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            nArray[n + i] = this.readInt();
        }
    }

    @Override
    public final long readLong() throws IOException {
        if (this.bigEndian) {
            return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
        }
        return ((long)this.readInt() & 0xFFFFFFFFL) + ((long)this.readInt() << 32);
    }

    public final void readLong(long[] lArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            lArray[n + i] = this.readLong();
        }
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final void readFloat(float[] fArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            fArray[n + i] = Float.intBitsToFloat(this.readInt());
        }
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final void readDouble(double[] dArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            dArray[n + i] = Double.longBitsToDouble(this.readLong());
        }
    }

    @Override
    public final String readLine() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = -1;
        boolean bl = false;
        block4: while (!bl) {
            n = this.read();
            switch (n) {
                case -1: 
                case 10: {
                    bl = true;
                    continue block4;
                }
                case 13: {
                    bl = true;
                    long l = this.getFilePointer();
                    if (this.read() == 10) continue block4;
                    this.seek(l);
                    continue block4;
                }
            }
            stringBuffer.append((char)n);
        }
        if (n == -1 && stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    @Override
    public final String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    public String readString(int n) throws IOException {
        byte[] byArray = new byte[n];
        this.readFully(byArray);
        return new String(byArray);
    }

    @Override
    public final void writeBoolean(boolean bl) throws IOException {
        this.write(bl ? 1 : 0);
    }

    public final void writeBoolean(boolean[] blArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            this.writeBoolean(blArray[n + i]);
        }
    }

    @Override
    public final void writeByte(int n) throws IOException {
        this.write(n);
    }

    @Override
    public final void writeShort(int n) throws IOException {
        this.write(n >>> 8 & 0xFF);
        this.write(n & 0xFF);
    }

    public final void writeShort(short[] sArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            this.writeShort(sArray[n + i]);
        }
    }

    @Override
    public final void writeChar(int n) throws IOException {
        this.write(n >>> 8 & 0xFF);
        this.write(n & 0xFF);
    }

    public final void writeChar(char[] cArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            this.writeChar(cArray[n + i]);
        }
    }

    @Override
    public final void writeInt(int n) throws IOException {
        this.write(n >>> 24 & 0xFF);
        this.write(n >>> 16 & 0xFF);
        this.write(n >>> 8 & 0xFF);
        this.write(n & 0xFF);
    }

    public final void writeInt(int[] nArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            this.writeInt(nArray[n + i]);
        }
    }

    @Override
    public final void writeLong(long l) throws IOException {
        this.write((int)(l >>> 56) & 0xFF);
        this.write((int)(l >>> 48) & 0xFF);
        this.write((int)(l >>> 40) & 0xFF);
        this.write((int)(l >>> 32) & 0xFF);
        this.write((int)(l >>> 24) & 0xFF);
        this.write((int)(l >>> 16) & 0xFF);
        this.write((int)(l >>> 8) & 0xFF);
        this.write((int)l & 0xFF);
    }

    public final void writeLong(long[] lArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            this.writeLong(lArray[n + i]);
        }
    }

    @Override
    public final void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public final void writeFloat(float[] fArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            this.writeFloat(fArray[n + i]);
        }
    }

    @Override
    public final void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public final void writeDouble(double[] dArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            this.writeDouble(dArray[n + i]);
        }
    }

    @Override
    public final void writeBytes(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.write((byte)string.charAt(i));
        }
    }

    public final void writeBytes(char[] cArray, int n, int n2) throws IOException {
        for (int i = n; i < n2; ++i) {
            this.write((byte)cArray[i]);
        }
    }

    @Override
    public final void writeChars(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            this.write(c >>> 8 & 0xFF);
            this.write(c & 0xFF);
        }
    }

    @Override
    public final void writeUTF(String string) throws IOException {
        char c;
        int n;
        int n2 = string.length();
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            c = string.charAt(n);
            if (c >= '\u0001' && c <= '\u007f') {
                ++n3;
                continue;
            }
            if (c > '\u07ff') {
                n3 += 3;
                continue;
            }
            n3 += 2;
        }
        if (n3 > 65535) {
            throw new UTFDataFormatException();
        }
        this.write(n3 >>> 8 & 0xFF);
        this.write(n3 & 0xFF);
        for (n = 0; n < n2; ++n) {
            c = string.charAt(n);
            if (c >= '\u0001' && c <= '\u007f') {
                this.write(c);
                continue;
            }
            if (c > '\u07ff') {
                this.write(0xE0 | c >> 12 & 0xF);
                this.write(0x80 | c >> 6 & 0x3F);
                this.write(0x80 | c & 0x3F);
                continue;
            }
            this.write(0xC0 | c >> 6 & 0x1F);
            this.write(0x80 | c & 0x3F);
        }
    }

    public String toString() {
        return "fp=" + this.filePosition + ", bs=" + this.bufferStart + ", de=" + this.dataEnd + ", ds=" + this.dataSize + ", bl=" + this.buffer.length + ", readonly=" + this.readonly + ", bm=" + this.bufferModified;
    }
}

