/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.graphchi.topic_pagerank;

import com.twitter.graphchi.topic_pagerank.PersonalizedPagerank;
import com.twitter.graphchi.topic_pagerank.PersonalizedPagerank$;
import edu.cmu.graphchi.ChiFilenames;
import edu.cmu.graphchi.datablocks.IntConverter;
import edu.cmu.graphchi.engine.auxdata.DegreeData;
import edu.cmu.graphchi.engine.auxdata.VertexData;
import edu.cmu.graphchi.scala.GraphChiSquared;
import edu.cmu.graphchi.scala.VertexInfo;
import edu.cmu.graphchi.util.IdFloat;
import edu.cmu.graphchi.util.Toplist;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.util.TreeSet;
import scala.Array$;
import scala.Function1;
import scala.Function3;
import scala.Function5;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.JavaConversions$;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.package$;
import scala.reflect.ClassManifestFactory$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class PersonalizedPagerank$ {
    public static final PersonalizedPagerank$ MODULE$;
    private final float RESETPROB;
    private PersonalizedPagerank.TopicInfo[] topicInfos;

    static {
        new PersonalizedPagerank$();
    }

    public float RESETPROB() {
        return this.RESETPROB;
    }

    public PersonalizedPagerank.TopicInfo[] topicInfos() {
        return this.topicInfos;
    }

    public void topicInfos_$eq(PersonalizedPagerank.TopicInfo[] x$1) {
        this.topicInfos = x$1;
    }

    public float resetProbability(VertexInfo<Integer, Float> v, int computationId, int numVertices) {
        return (Predef$.MODULE$.Integer2int(v.value()) & 1 << computationId) == 0 ? 0.0f : 1.0f;
    }

    public int initialize(String initfile) {
        File dir = new File(new File(initfile).getAbsolutePath()).getParentFile();
        this.topicInfos_$eq((PersonalizedPagerank.TopicInfo[])Source$.MODULE$.fromFile(initfile, Codec$.MODULE$.fallbackSystemCodec()).getLines().filter((Function1)new Serializable(){

            public final boolean apply(String x$1) {
                return x$1.indexOf("\t") > 0;
            }
        }).map((Function1)new Serializable(dir){
            private final File dir$1;

            public final PersonalizedPagerank.TopicInfo apply(String line) {
                String[] toks = line.split("\t");
                return new PersonalizedPagerank.TopicInfo(toks[0], new StringBuilder().append((Object)this.dir$1.getAbsolutePath()).append((Object)"/").append((Object)toks[1]).toString());
            }
            {
                this.dir$1 = dir$1;
            }
        }).toArray(ClassTag$.MODULE$.apply(PersonalizedPagerank.TopicInfo.class)));
        Predef$.MODULE$.println((Object)this.topicInfos());
        return Predef$.MODULE$.refArrayOps((Object[])this.topicInfos()).size();
    }

    public <T> void initVertexData(String graphname, GraphChiSquared<T> graphchiSqr) {
        File vertexDataFile = new File(ChiFilenames.getFilenameOfVertexData(graphname, new IntConverter(), false));
        Object object = vertexDataFile.exists() ? BoxesRunTime.boxToBoolean((boolean)vertexDataFile.delete()) : BoxedUnit.UNIT;
        int[] vertexVals = VertexData.createIntArray(graphchiSqr.numVertices());
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.topicInfos()).zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), Predef$.MODULE$.refArrayOps((Object[])this.topicInfos()).size()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(graphchiSqr, vertexVals){
            public final GraphChiSquared graphchiSqr$1;
            public final int[] vertexVals$1;

            public final void apply(Tuple2<PersonalizedPagerank.TopicInfo, Object> x) {
                Tuple2<PersonalizedPagerank.TopicInfo, Object> tuple2 = x;
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    PersonalizedPagerank.TopicInfo topicInfo = (PersonalizedPagerank.TopicInfo)tuple2._1();
                    int compidx = tuple2._2$mcI$sp();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)topicInfo, (Object)BoxesRunTime.boxToInteger((int)compidx));
                    PersonalizedPagerank.TopicInfo topicInfo2 = (PersonalizedPagerank.TopicInfo)tuple23._1();
                    int compidx2 = tuple23._2$mcI$sp();
                    Source$.MODULE$.fromFile(topicInfo2.seedFile(), Codec$.MODULE$.fallbackSystemCodec()).getLines().filter((Function1)new Serializable(this){

                        public final boolean apply(String x$3) {
                            return x$3.length() > 0;
                        }
                    }).foreach((Function1)new Serializable(this, compidx2){
                        private final /* synthetic */ anonfun.initVertexData.2 $outer;
                        private final int compidx$1;

                        public final void apply(String line) {
                            int vertexId = Integer.parseInt(line.split("\t")[0]);
                            if (vertexId < this.$outer.vertexVals$1.length) {
                                this.$outer.vertexVals$1[vertexId] = this.$outer.vertexVals$1[vertexId] | 1 << this.compidx$1;
                                this.$outer.graphchiSqr$1.initValue(this.compidx$1, vertexId, Predef$.MODULE$.float2Float(PersonalizedPagerank$.MODULE$.RESETPROB()));
                            } else {
                                Predef$.MODULE$.println((Object)new Tuple2((Object)"Warning: too large vertex-id in topic top:", (Object)BoxesRunTime.boxToInteger((int)vertexId)));
                            }
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.compidx$1 = compidx$1;
                        }
                    });
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.graphchiSqr$1 = graphchiSqr$1;
                this.vertexVals$1 = vertexVals$1;
            }
        });
        DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(vertexDataFile)));
        Predef$.MODULE$.intArrayOps(vertexVals).foreach((Function1)new Serializable(dos){
            private final DataOutputStream dos$1;

            public final void apply(int v) {
                this.apply$mcVI$sp(v);
            }

            public void apply$mcVI$sp(int v) {
                this.dos$1.writeInt(v);
            }
            {
                this.dos$1 = dos$1;
            }
        });
        dos.close();
    }

    public void main(String[] args) {
        String graphname = args[0];
        int nshards = Integer.parseInt(args[1]);
        int niters = Integer.parseInt(args[2]);
        String initfile = args[3];
        int nComputations = this.initialize(initfile);
        GraphChiSquared<Float> graphchiSqr = new GraphChiSquared<Float>(graphname, nshards, nComputations, ClassManifestFactory$.MODULE$.classType(Float.class));
        int numVertices = graphchiSqr.numVertices();
        ChiFilenames.vertexDataSuffix = new StringBuilder().append((Object)".seeded.").append((Object)BoxesRunTime.boxToInteger((int)ChiFilenames.getPid())).toString();
        Predef$.MODULE$.println((Object)new Tuple3((Object)"Initializing... Starting ", (Object)BoxesRunTime.boxToInteger((int)nComputations), (Object)" computations"));
        this.initVertexData(graphname, graphchiSqr);
        Predef$.MODULE$.println((Object)"Done initializing");
        graphchiSqr.compute(niters, Predef$.MODULE$.float2Float(0.0f), (Function5<VertexInfo<Integer, Float>, Object, Float, Float, Object, Float>)new Serializable(){

            public final Float apply(VertexInfo<Integer, Float> v, int vertexId, Float neighborVal, Float gather, int compid) {
                return Predef$.MODULE$.float2Float(Predef$.MODULE$.Float2float(gather) + Predef$.MODULE$.Float2float(neighborVal));
            }
        }, (Function3<VertexInfo<Integer, Float>, Float, Object, Float>)new Serializable(numVertices){
            private final int numVertices$1;

            public final Float apply(VertexInfo<Integer, Float> v, Float gather, int compid) {
                return Predef$.MODULE$.float2Float((PersonalizedPagerank$.MODULE$.RESETPROB() * PersonalizedPagerank$.MODULE$.resetProbability(v, compid, this.numVertices$1) + (1.0f - PersonalizedPagerank$.MODULE$.RESETPROB()) * Predef$.MODULE$.Float2float(gather)) / (float)v.numOutEdges());
            }
            {
                this.numVertices$1 = numVertices$1;
            }
        }, (Function1<VertexInfo<Integer, Float>, Object>)new Serializable(){

            public final boolean apply(VertexInfo<Integer, Float> v) {
                return v.numOutEdges() > 0;
            }
        });
        Predef$.MODULE$.println((Object)"Scale by outdegree");
        DegreeData degreeData = new DegreeData(graphname);
        int chunk = 1000000;
        for (int i = 0; i < numVertices; i += chunk) {
            int last = package$.MODULE$.min(i + chunk - 1, numVertices - 1);
            degreeData.load(i, last);
            for (int j = i; j < last; ++j) {
                int outdeg = degreeData.getDegree((int)j).outDegree;
                graphchiSqr.getVertexMatrix().multiplyRow(j, outdeg);
            }
        }
        Predef$.MODULE$.println((Object)"Ready, writing toplists...");
        int ntop = 10000;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nComputations).foreach$mVc$sp((Function1)new Serializable(graphchiSqr, ntop){
            private final GraphChiSquared graphchiSqr$2;
            private final int ntop$1;

            public final void apply(int icomp) {
                this.apply$mcVI$sp(icomp);
            }

            public void apply$mcVI$sp(int icomp) {
                TreeSet<IdFloat> topList = Toplist.topList(this.graphchiSqr$2.getVertexMatrix(), icomp, this.ntop$1);
                String outputfile = new StringBuilder().append((Object)"toplist.").append((Object)PersonalizedPagerank$.MODULE$.topicInfos()[icomp].topicName()).append((Object)".tsv").toString();
                BufferedWriter writer = new BufferedWriter(new FileWriter(new File(outputfile)));
                JavaConversions$.MODULE$.asScalaSet(topList).foreach((Function1)new Serializable(this, writer, icomp){
                    private final BufferedWriter writer$1;
                    private final int icomp$1;

                    public final void apply(IdFloat item) {
                        this.writer$1.write(new StringBuilder().append(item.getVertexId()).append((Object)"\t").append((Object)PersonalizedPagerank$.MODULE$.topicInfos()[this.icomp$1].topicName()).append((Object)"\t").append((Object)BoxesRunTime.boxToFloat((float)item.getValue())).append((Object)"\n").toString());
                    }
                    {
                        this.writer$1 = writer$1;
                        this.icomp$1 = icomp$1;
                    }
                });
                writer.close();
            }
            {
                this.graphchiSqr$2 = graphchiSqr$2;
                this.ntop$1 = ntop$1;
            }
        });
        new File(ChiFilenames.getFilenameOfVertexData(graphname, new IntConverter(), false)).delete();
    }

    private PersonalizedPagerank$() {
        MODULE$ = this;
        this.RESETPROB = 0.15f;
        this.topicInfos = null;
    }
}

