/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.graphchi.topic_pagerank;

import com.twitter.graphchi.topic_pagerank.SumAndNormalizer;
import com.twitter.graphchi.topic_pagerank.WeightedPersonalizedPagerank;
import com.twitter.graphchi.topic_pagerank.WeightedPersonalizedPagerank$;
import edu.cmu.graphchi.ChiFilenames;
import edu.cmu.graphchi.datablocks.IntConverter;
import edu.cmu.graphchi.engine.auxdata.VertexData;
import edu.cmu.graphchi.scala.GraphChiSquared;
import edu.cmu.graphchi.scala.VertexInfo;
import edu.cmu.graphchi.util.HugeFloatMatrix;
import edu.cmu.graphchi.util.IdFloat;
import edu.cmu.graphchi.util.Toplist;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.TreeSet;
import scala.Array$;
import scala.Function1;
import scala.Function3;
import scala.Function5;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.JavaConversions$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassManifestFactory$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class WeightedPersonalizedPagerank$ {
    public static final WeightedPersonalizedPagerank$ MODULE$;
    private final float RESETPROB;
    private HugeFloatMatrix weights;
    private WeightedPersonalizedPagerank.TopicInfo[] topicInfos;

    static {
        new WeightedPersonalizedPagerank$();
    }

    public float RESETPROB() {
        return this.RESETPROB;
    }

    public HugeFloatMatrix weights() {
        return this.weights;
    }

    public void weights_$eq(HugeFloatMatrix x$1) {
        this.weights = x$1;
    }

    public WeightedPersonalizedPagerank.TopicInfo[] topicInfos() {
        return this.topicInfos;
    }

    public void topicInfos_$eq(WeightedPersonalizedPagerank.TopicInfo[] x$1) {
        this.topicInfos = x$1;
    }

    public int initialize(String initfile) {
        File dir = new File(new File(initfile).getAbsolutePath()).getParentFile();
        this.topicInfos_$eq((WeightedPersonalizedPagerank.TopicInfo[])Source$.MODULE$.fromFile(initfile, Codec$.MODULE$.fallbackSystemCodec()).getLines().filter((Function1)new Serializable(){

            public final boolean apply(String x$1) {
                return x$1.indexOf("\t") > 0;
            }
        }).map((Function1)new Serializable(dir){
            private final File dir$1;

            public final WeightedPersonalizedPagerank.TopicInfo apply(String line) {
                String[] toks = line.split("\t");
                return new WeightedPersonalizedPagerank.TopicInfo(toks[0], new StringBuilder().append((Object)this.dir$1.getAbsolutePath()).append((Object)"/").append((Object)toks[1]).toString());
            }
            {
                this.dir$1 = dir$1;
            }
        }).toArray(ClassTag$.MODULE$.apply(WeightedPersonalizedPagerank.TopicInfo.class)));
        Predef$.MODULE$.println((Object)this.topicInfos());
        return Predef$.MODULE$.refArrayOps((Object[])this.topicInfos()).size();
    }

    public <T> void initVertexData(String graphname, GraphChiSquared<T> graphchiSqr, float cutoff) {
        File vertexDataFile = new File(ChiFilenames.getFilenameOfVertexData(graphname, new IntConverter(), false));
        Object object = vertexDataFile.exists() ? BoxesRunTime.boxToBoolean((boolean)vertexDataFile.delete()) : BoxedUnit.UNIT;
        int[] vertexVals = VertexData.createIntArray(graphchiSqr.numVertices());
        this.weights_$eq(new HugeFloatMatrix(graphchiSqr.numVertices(), this.topicInfos().length));
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.topicInfos()).zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), Predef$.MODULE$.refArrayOps((Object[])this.topicInfos()).size()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(vertexVals){
            public final int[] vertexVals$1;

            public final void apply(Tuple2<WeightedPersonalizedPagerank.TopicInfo, Object> x) {
                Tuple2<WeightedPersonalizedPagerank.TopicInfo, Object> tuple2 = x;
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    WeightedPersonalizedPagerank.TopicInfo topicInfo = (WeightedPersonalizedPagerank.TopicInfo)tuple2._1();
                    int compidx = tuple2._2$mcI$sp();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)topicInfo, (Object)BoxesRunTime.boxToInteger((int)compidx));
                    WeightedPersonalizedPagerank.TopicInfo topicInfo2 = (WeightedPersonalizedPagerank.TopicInfo)tuple23._1();
                    int compidx2 = tuple23._2$mcI$sp();
                    String weightFile = topicInfo2.weightFile().split(":")[0];
                    boolean doSquare = topicInfo2.weightFile().contains(":sqr");
                    Predef$.MODULE$.println((Object)topicInfo2.weightFile());
                    if (doSquare) {
                        Predef$.MODULE$.println((Object)"Square weight...");
                    }
                    Source$.MODULE$.fromFile(weightFile, Codec$.MODULE$.fallbackSystemCodec()).getLines().filter((Function1)new Serializable(this){

                        public final boolean apply(String x$3) {
                            return x$3.length() > 0;
                        }
                    }).foreach((Function1)new Serializable(this, compidx2, doSquare){
                        private final /* synthetic */ anonfun.initVertexData.1 $outer;
                        private final int compidx$1;
                        private final boolean doSquare$1;

                        public final void apply(String line) {
                            String[] toks = line.split("\t");
                            int vertexId = Integer.parseInt(toks[0]);
                            float weight = Float.parseFloat(toks[2]);
                            if (vertexId < this.$outer.vertexVals$1.length) {
                                float oldWeight = WeightedPersonalizedPagerank$.MODULE$.weights().getValue(vertexId, this.compidx$1);
                                WeightedPersonalizedPagerank$.MODULE$.weights().setValue(vertexId, this.compidx$1, oldWeight + (this.doSquare$1 ? weight * weight : weight));
                            }
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.compidx$1 = compidx$1;
                            this.doSquare$1 = doSquare$1;
                        }
                    });
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.vertexVals$1 = vertexVals$1;
            }
        });
        this.weights().zeroLessThan(cutoff);
    }

    public void main(String[] args) {
        String graphname = args[0];
        int nshards = Integer.parseInt(args[1]);
        int niters = Integer.parseInt(args[2]);
        String initfile = args[3];
        float cutoff = new StringOps(Predef$.MODULE$.augmentString(args[4])).toFloat();
        int nComputations = this.initialize(initfile);
        GraphChiSquared<SumAndNormalizer> graphchiSqr = new GraphChiSquared<SumAndNormalizer>(graphname, nshards, nComputations, ClassManifestFactory$.MODULE$.classType(SumAndNormalizer.class));
        int numVertices = graphchiSqr.numVertices();
        ChiFilenames.vertexDataSuffix = new StringBuilder().append((Object)".multicomp.").append((Object)BoxesRunTime.boxToInteger((int)ChiFilenames.getPid())).toString();
        Predef$.MODULE$.println((Object)new Tuple3((Object)"Initializing... Starting ", (Object)BoxesRunTime.boxToInteger((int)nComputations), (Object)" computations on WEIGHTED personalized pagerank."));
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Using weight cutoff:").append((Object)BoxesRunTime.boxToFloat((float)cutoff)).toString());
        this.initVertexData(graphname, graphchiSqr, cutoff);
        Predef$.MODULE$.println((Object)"Done initializing");
        graphchiSqr.compute(niters, new SumAndNormalizer(Predef$.MODULE$.float2Float(0.0f), Predef$.MODULE$.float2Float(0.0f)), (Function5<VertexInfo<Integer, Float>, Object, Float, SumAndNormalizer, Object, SumAndNormalizer>)new Serializable(){

            public final SumAndNormalizer apply(VertexInfo<Integer, Float> v, int nbrId, Float neighborVal, SumAndNormalizer gather, int compid) {
                return gather.$plus(new SumAndNormalizer(neighborVal, Predef$.MODULE$.float2Float(0.0f)));
            }
        }, (Function5<VertexInfo<Integer, Float>, Object, Float, SumAndNormalizer, Object, SumAndNormalizer>)new Serializable(){

            public final SumAndNormalizer apply(VertexInfo<Integer, Float> v, int nbrId, Float neighborVal, SumAndNormalizer gather, int compid) {
                float w = WeightedPersonalizedPagerank$.MODULE$.weights().getValue(nbrId, compid);
                return gather.$plus(new SumAndNormalizer(Predef$.MODULE$.float2Float(0.0f), Predef$.MODULE$.float2Float(w)));
            }
        }, (Function3<VertexInfo<Integer, Float>, SumAndNormalizer, Object, Float>)new Serializable(){

            public final Float apply(VertexInfo<Integer, Float> v, SumAndNormalizer gather, int compid) {
                float newval;
                float incomingrank = WeightedPersonalizedPagerank$.MODULE$.weights().getValue(v.id(), compid) * Predef$.MODULE$.Float2float(gather.sum());
                float f = newval = Predef$.MODULE$.Float2float(gather.normalizer()) > 0.0f ? (WeightedPersonalizedPagerank$.MODULE$.RESETPROB() * WeightedPersonalizedPagerank$.MODULE$.weights().getValue(v.id(), compid) + (1.0f - WeightedPersonalizedPagerank$.MODULE$.RESETPROB()) * incomingrank) / Predef$.MODULE$.Float2float(gather.normalizer()) : WeightedPersonalizedPagerank$.MODULE$.RESETPROB() * WeightedPersonalizedPagerank$.MODULE$.weights().getValue(v.id(), compid) + (1.0f - WeightedPersonalizedPagerank$.MODULE$.RESETPROB()) * incomingrank;
                if ((double)newval > 1.0E10) {
                    Predef$.MODULE$.println((Object)"Too big value!");
                }
                return Predef$.MODULE$.float2Float(newval);
            }
        }, (Function1<VertexInfo<Integer, Float>, Object>)new Serializable(){

            public final boolean apply(VertexInfo<Integer, Float> v) {
                return v.numOutEdges() > 0;
            }
        });
        Predef$.MODULE$.println((Object)"Scale by multicomp outdegree");
        graphchiSqr.compute(1, new SumAndNormalizer(Predef$.MODULE$.float2Float(0.0f), Predef$.MODULE$.float2Float(0.0f)), (Function5<VertexInfo<Integer, Float>, Object, Float, SumAndNormalizer, Object, SumAndNormalizer>)new Serializable(){

            public final SumAndNormalizer apply(VertexInfo<Integer, Float> v, int nbrId, Float neighborVal, SumAndNormalizer gather, int compid) {
                return gather;
            }
        }, (Function5<VertexInfo<Integer, Float>, Object, Float, SumAndNormalizer, Object, SumAndNormalizer>)new Serializable(){

            public final SumAndNormalizer apply(VertexInfo<Integer, Float> v, int nbrId, Float neighborVal, SumAndNormalizer gather, int compid) {
                float w = WeightedPersonalizedPagerank$.MODULE$.weights().getValue(nbrId, compid);
                return gather.$plus(new SumAndNormalizer(Predef$.MODULE$.float2Float(0.0f), Predef$.MODULE$.float2Float(w)));
            }
        }, (Function3<VertexInfo<Integer, Float>, SumAndNormalizer, Object, Float>)new Serializable(graphchiSqr){
            private final GraphChiSquared graphchiSqr$1;

            public final Float apply(VertexInfo<Integer, Float> v, SumAndNormalizer gather, int compid) {
                return Predef$.MODULE$.Float2float(gather.normalizer()) > 0.0f ? Predef$.MODULE$.float2Float(this.graphchiSqr$1.getVertexMatrix().getValue(v.id(), compid) * Predef$.MODULE$.Float2float(gather.normalizer())) : Predef$.MODULE$.float2Float(this.graphchiSqr$1.getVertexMatrix().getValue(v.id(), compid));
            }
            {
                this.graphchiSqr$1 = graphchiSqr$1;
            }
        }, (Function1<VertexInfo<Integer, Float>, Object>)new Serializable(){

            public final boolean apply(VertexInfo<Integer, Float> v) {
                return v.numOutEdges() > 0;
            }
        });
        Predef$.MODULE$.println((Object)"Ready, writing toplists...");
        int ntop = 10000;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nComputations).foreach$mVc$sp((Function1)new Serializable(cutoff, graphchiSqr, ntop){
            private final float cutoff$1;
            private final GraphChiSquared graphchiSqr$1;
            private final int ntop$1;

            public final void apply(int icomp) {
                this.apply$mcVI$sp(icomp);
            }

            public void apply$mcVI$sp(int icomp) {
                TreeSet<IdFloat> topList = Toplist.topList(this.graphchiSqr$1.getVertexMatrix(), icomp, this.ntop$1);
                String outputfile = new StringBuilder().append((Object)"toplist.weightedPR.").append((Object)WeightedPersonalizedPagerank$.MODULE$.topicInfos()[icomp].topicName()).append((Object)"_cutoff_").append((Object)BoxesRunTime.boxToFloat((float)this.cutoff$1)).append((Object)".tsv").toString();
                BufferedWriter writer = new BufferedWriter(new FileWriter(new File(outputfile)));
                JavaConversions$.MODULE$.asScalaSet(topList).foreach((Function1)new Serializable(this, writer, icomp){
                    private final BufferedWriter writer$1;
                    private final int icomp$1;

                    public final void apply(IdFloat item) {
                        this.writer$1.write(new StringBuilder().append(item.getVertexId()).append((Object)"\t").append((Object)WeightedPersonalizedPagerank$.MODULE$.topicInfos()[this.icomp$1].topicName()).append((Object)"\t").append((Object)BoxesRunTime.boxToFloat((float)item.getValue())).append((Object)"\n").toString());
                    }
                    {
                        this.writer$1 = writer$1;
                        this.icomp$1 = icomp$1;
                    }
                });
                writer.close();
            }
            {
                this.cutoff$1 = cutoff$1;
                this.graphchiSqr$1 = graphchiSqr$1;
                this.ntop$1 = ntop$1;
            }
        });
        new File(ChiFilenames.getFilenameOfVertexData(graphname, new IntConverter(), false)).delete();
    }

    private WeightedPersonalizedPagerank$() {
        MODULE$ = this;
        this.RESETPROB = 0.15f;
        this.weights = null;
        this.topicInfos = null;
    }
}

