/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.pers.bipartite;

import edu.cmu.graphchi.ChiLogger;
import edu.cmu.graphchi.ChiVertex;
import edu.cmu.graphchi.GraphChiContext;
import edu.cmu.graphchi.GraphChiProgram;
import edu.cmu.graphchi.datablocks.FloatConverter;
import edu.cmu.graphchi.datablocks.FloatPair;
import edu.cmu.graphchi.datablocks.FloatPairConverter;
import edu.cmu.graphchi.engine.GraphChiEngine;
import edu.cmu.graphchi.engine.VertexInterval;
import edu.cmu.graphchi.hadoop.PigGraphChiBase;
import edu.cmu.graphchi.preprocessing.EdgeProcessor;
import edu.cmu.graphchi.preprocessing.FastSharder;
import edu.cmu.graphchi.preprocessing.VertexProcessor;
import edu.cmu.graphchi.util.IdFloat;
import edu.cmu.graphchi.vertexdata.ForeachCallback;
import edu.cmu.graphchi.vertexdata.VertexAggregator;
import edu.cmu.graphchi.vertexdata.VertexTransformCallBack;
import edu.cmu.graphchi.vertexdata.VertexTransformer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;

public class HITSSmallMem
extends PigGraphChiBase
implements GraphChiProgram<FloatPair, Float> {
    private static final int RIGHTSIDE = 0;
    private static final int LEFTSIDE = 1;
    private String graphName;
    private static final Logger logger = ChiLogger.getLogger("hits-smallmem");
    int numShards = 20;
    double leftSideSqrSum = 0.0;
    double rightSideSqrSum = 0.0;
    float leftNorm = 1.0f;
    float rightNorm = 1.0f;
    GraphChiEngine<FloatPair, Float> engine;
    private ArrayList<IdFloat> results;
    private Iterator<IdFloat> resultIter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(ChiVertex<FloatPair, Float> chiVertex, GraphChiContext graphChiContext) {
        int n = graphChiContext.getIteration() % 2;
        if (chiVertex.numEdges() > 0) {
            int n2;
            float f = 0.0f;
            if (n == 1) {
                for (n2 = 0; n2 < chiVertex.numOutEdges(); ++n2) {
                    f += chiVertex.outEdge(n2).getValue().floatValue();
                }
                f /= this.rightNorm;
            } else {
                for (n2 = 0; n2 < chiVertex.numInEdges(); ++n2) {
                    f += chiVertex.inEdge(n2).getValue().floatValue();
                }
                f /= this.leftNorm;
            }
            float f2 = f;
            FloatPair floatPair = chiVertex.getValue();
            if (n == 1 && chiVertex.numOutEdges() > 0) {
                floatPair = new FloatPair(f2, floatPair.second);
                HITSSmallMem hITSSmallMem = this;
                synchronized (hITSSmallMem) {
                    this.leftSideSqrSum += (double)(f2 * f2);
                }
                for (int i = 0; i < chiVertex.numOutEdges(); ++i) {
                    chiVertex.outEdge(i).setValue(Float.valueOf(f2));
                }
            } else if (n == 0 && chiVertex.numInEdges() > 0) {
                int n3 = chiVertex.numInEdges();
                int n4 = (int)floatPair.second;
                if (n4 == 0) {
                    logger.warning("Normalization factor cannot be zero! Id:" + graphChiContext.getVertexIdTranslate().backward(chiVertex.getId()));
                    n4 = n3;
                }
                f2 *= (float)n3 * 1.0f / (float)n4;
                HITSSmallMem hITSSmallMem = this;
                synchronized (hITSSmallMem) {
                    this.rightSideSqrSum += (double)(f2 * f2);
                }
                for (int i = 0; i < chiVertex.numInEdges(); ++i) {
                    chiVertex.inEdge(i).setValue(Float.valueOf(f2));
                }
            }
            chiVertex.setValue(floatPair);
        }
    }

    @Override
    public void beginIteration(GraphChiContext graphChiContext) {
    }

    @Override
    public void beginInterval(GraphChiContext graphChiContext, VertexInterval vertexInterval) {
    }

    @Override
    public void endInterval(GraphChiContext graphChiContext, VertexInterval vertexInterval) {
    }

    @Override
    public void endIteration(GraphChiContext graphChiContext) {
        if (graphChiContext.getIteration() % 2 == 1) {
            try {
                logger.info("NORMALIZING - LEFT");
                this.leftNorm = (float)Math.sqrt(this.leftSideSqrSum);
                VertexTransformer.transform((int)graphChiContext.getNumVertices(), this.graphName, new FloatPairConverter(), new VertexTransformCallBack<FloatPair>(){

                    @Override
                    public FloatPair map(int n, FloatPair floatPair) {
                        return new FloatPair(floatPair.first / HITSSmallMem.this.leftNorm, floatPair.second);
                    }
                });
                this.leftSideSqrSum = 0.0;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else if (graphChiContext.getIteration() % 2 == 0) {
            logger.info("NORMALIZING - RIGHT");
            this.rightNorm = (float)Math.sqrt(this.rightSideSqrSum);
            this.rightSideSqrSum = 0.0;
        }
        logger.info("Normalizing factors now, left=" + this.leftNorm + ", right=" + this.rightNorm);
    }

    @Override
    public void beginSubInterval(GraphChiContext graphChiContext, VertexInterval vertexInterval) {
    }

    @Override
    public void endSubInterval(GraphChiContext graphChiContext, VertexInterval vertexInterval) {
    }

    public void run(String string, int n) throws Exception {
        this.graphName = string;
        this.engine = new GraphChiEngine(string, n);
        this.engine.setEnableScheduler(false);
        this.engine.setSkipZeroDegreeVertices(true);
        this.engine.setEdataConverter(new FloatConverter());
        this.engine.setVertexDataConverter(new FloatPairConverter());
        this.engine.setMaxWindow(20000000);
        this.engine.run(this, 8);
    }

    private void outputResults(String string) throws IOException {
        VertexAggregator.foreach(this.engine.numVertices(), string, new FloatPairConverter(), new ForeachCallback<FloatPair>(){

            @Override
            public void callback(int n, FloatPair floatPair) {
                if (floatPair.first > 0.0f) {
                    System.out.println(HITSSmallMem.this.engine.getVertexIdTranslate().backward(n) + "\t" + floatPair.first);
                }
            }
        });
    }

    public static void main(String[] stringArray) throws Exception {
        int n = 0;
        String string = null;
        if (stringArray.length == 2) {
            string = stringArray[n++];
        }
        int n2 = Integer.parseInt(stringArray[n++]);
        HITSSmallMem hITSSmallMem = new HITSSmallMem();
        if (string == null) {
            string = "pipein";
            FastSharder fastSharder = hITSSmallMem.createSharder(string, n2);
            fastSharder.shard(System.in);
        }
        hITSSmallMem.run(string, n2);
        hITSSmallMem.outputResults(string);
    }

    @Override
    protected String getSchemaString() {
        return "(weight:float, vertex:int)";
    }

    @Override
    protected int getNumShards() {
        return this.numShards;
    }

    @Override
    protected void runGraphChi() throws Exception {
        this.run(this.getGraphName(), this.getNumShards());
        this.results = new ArrayList(100000);
        VertexAggregator.foreach(this.engine.numVertices(), this.graphName, new FloatPairConverter(), new ForeachCallback<FloatPair>(){

            @Override
            public void callback(int n, FloatPair floatPair) {
                if (floatPair.first > 0.0f) {
                    HITSSmallMem.this.results.add(new IdFloat(HITSSmallMem.this.engine.getVertexIdTranslate().backward(n), floatPair.first));
                }
            }
        });
        this.engine = null;
        this.resultIter = this.results.iterator();
    }

    @Override
    protected FastSharder createSharder(String string, int n) throws IOException {
        this.numShards = n;
        return new FastSharder<FloatPair, Float>(string, n, new VertexProcessor<FloatPair>(){

            @Override
            public FloatPair receiveVertexValue(int n, String string) {
                return new FloatPair(0.0f, Float.parseFloat(string));
            }
        }, new EdgeProcessor<Float>(){

            @Override
            public Float receiveEdge(int n, int n2, String string) {
                return Float.valueOf(Float.parseFloat(string));
            }
        }, new FloatPairConverter(), new FloatConverter());
    }

    @Override
    protected Tuple getNextResult(TupleFactory tupleFactory) throws ExecException {
        if (this.resultIter.hasNext()) {
            IdFloat idFloat = this.resultIter.next();
            Tuple tuple = tupleFactory.newTuple(2);
            tuple.set(0, (Object)Float.valueOf(idFloat.getValue()));
            tuple.set(1, (Object)idFloat.getVertexId());
            return tuple;
        }
        return null;
    }

    @Override
    protected String getStatusString() {
        GraphChiContext graphChiContext;
        if (this.engine != null && (graphChiContext = this.engine.getContext()) != null) {
            return graphChiContext.getCurInterval() + " iteration: " + graphChiContext.getIteration() + "/" + graphChiContext.getNumIterations();
        }
        return "Initializing";
    }
}

