/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.pers.bipartite;

import edu.cmu.graphchi.ChiLogger;
import edu.cmu.graphchi.ChiVertex;
import edu.cmu.graphchi.GraphChiContext;
import edu.cmu.graphchi.GraphChiProgram;
import edu.cmu.graphchi.datablocks.FloatConverter;
import edu.cmu.graphchi.datablocks.FloatPair;
import edu.cmu.graphchi.datablocks.FloatPairConverter;
import edu.cmu.graphchi.engine.GraphChiEngine;
import edu.cmu.graphchi.engine.VertexInterval;
import edu.cmu.graphchi.hadoop.PigGraphChiBase;
import edu.cmu.graphchi.preprocessing.EdgeProcessor;
import edu.cmu.graphchi.preprocessing.FastSharder;
import edu.cmu.graphchi.preprocessing.VertexProcessor;
import edu.cmu.graphchi.util.IdFloat;
import edu.cmu.graphchi.vertexdata.ForeachCallback;
import edu.cmu.graphchi.vertexdata.VertexAggregator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;

public class SALSASmallMem
extends PigGraphChiBase
implements GraphChiProgram<FloatPair, Float> {
    private static final int RIGHTSIDE = 0;
    private static final int LEFTSIDE = 1;
    private String graphName;
    private static final Logger logger = ChiLogger.getLogger("salsa-smallmem");
    int numShards = 20;
    GraphChiEngine<FloatPair, Float> engine;
    private ArrayList<IdFloat> results;
    private Iterator<IdFloat> resultIter;

    @Override
    public void update(ChiVertex<FloatPair, Float> chiVertex, GraphChiContext graphChiContext) {
        int n = graphChiContext.getIteration() % 2;
        if (chiVertex.numEdges() > 0) {
            int n2;
            float f = 0.0f;
            if (n == 1) {
                for (n2 = 0; n2 < chiVertex.numOutEdges(); ++n2) {
                    f += chiVertex.outEdge(n2).getValue().floatValue();
                }
            } else {
                for (n2 = 0; n2 < chiVertex.numInEdges(); ++n2) {
                    f += chiVertex.inEdge(n2).getValue().floatValue();
                }
            }
            float f2 = f;
            FloatPair floatPair = chiVertex.getValue();
            if (n == 1 && chiVertex.numOutEdges() > 0) {
                floatPair = new FloatPair(f2, floatPair.second);
                float f3 = f2 / (float)chiVertex.numOutEdges();
                for (int i = 0; i < chiVertex.numOutEdges(); ++i) {
                    chiVertex.outEdge(i).setValue(Float.valueOf(f3));
                }
            } else if (n == 0 && chiVertex.numInEdges() > 0) {
                int n3 = chiVertex.numInEdges();
                int n4 = (int)floatPair.second;
                if (n4 == 0) {
                    logger.warning("Normalization factor cannot be zero! Id:" + graphChiContext.getVertexIdTranslate().backward(chiVertex.getId()));
                    n4 = n3;
                }
                float f4 = (f2 *= (float)n3 * 1.0f / (float)n4) / (float)chiVertex.numInEdges();
                for (int i = 0; i < chiVertex.numInEdges(); ++i) {
                    chiVertex.inEdge(i).setValue(Float.valueOf(f4));
                }
            }
            chiVertex.setValue(floatPair);
        }
    }

    @Override
    public void beginIteration(GraphChiContext graphChiContext) {
    }

    @Override
    public void beginInterval(GraphChiContext graphChiContext, VertexInterval vertexInterval) {
    }

    @Override
    public void endInterval(GraphChiContext graphChiContext, VertexInterval vertexInterval) {
    }

    @Override
    public void endIteration(GraphChiContext graphChiContext) {
    }

    @Override
    public void beginSubInterval(GraphChiContext graphChiContext, VertexInterval vertexInterval) {
    }

    @Override
    public void endSubInterval(GraphChiContext graphChiContext, VertexInterval vertexInterval) {
    }

    public void run(String string, int n) throws Exception {
        this.graphName = string;
        this.engine = new GraphChiEngine(string, n);
        this.engine.setEnableScheduler(false);
        this.engine.setSkipZeroDegreeVertices(true);
        this.engine.setEdataConverter(new FloatConverter());
        this.engine.setVertexDataConverter(new FloatPairConverter());
        this.engine.setMaxWindow(20000000);
        this.engine.run(this, 8);
    }

    private void outputResults(String string) throws IOException {
        VertexAggregator.foreach(this.engine.numVertices(), string, new FloatPairConverter(), new ForeachCallback<FloatPair>(){

            @Override
            public void callback(int n, FloatPair floatPair) {
                if (floatPair.first > 0.0f) {
                    System.out.println(SALSASmallMem.this.engine.getVertexIdTranslate().backward(n) + "\t" + floatPair.first);
                }
            }
        });
    }

    public static void main(String[] stringArray) throws Exception {
        int n = 0;
        String string = null;
        if (stringArray.length == 2) {
            string = stringArray[n++];
        }
        int n2 = Integer.parseInt(stringArray[n++]);
        SALSASmallMem sALSASmallMem = new SALSASmallMem();
        if (string == null) {
            string = "pipein";
            FastSharder fastSharder = sALSASmallMem.createSharder(string, n2);
            fastSharder.shard(System.in);
        }
        sALSASmallMem.run(string, n2);
        sALSASmallMem.outputResults(string);
    }

    @Override
    protected String getSchemaString() {
        return "(weight:float, vertex:int)";
    }

    @Override
    protected int getNumShards() {
        return this.numShards;
    }

    @Override
    protected void runGraphChi() throws Exception {
        this.run(this.getGraphName(), this.getNumShards());
        this.results = new ArrayList(100000);
        VertexAggregator.foreach(this.engine.numVertices(), this.graphName, new FloatPairConverter(), new ForeachCallback<FloatPair>(){

            @Override
            public void callback(int n, FloatPair floatPair) {
                if (floatPair.first > 0.0f) {
                    SALSASmallMem.this.results.add(new IdFloat(SALSASmallMem.this.engine.getVertexIdTranslate().backward(n), floatPair.first));
                }
            }
        });
        this.engine = null;
        this.resultIter = this.results.iterator();
    }

    @Override
    protected FastSharder createSharder(String string, int n) throws IOException {
        this.numShards = n;
        return new FastSharder<FloatPair, Float>(string, n, new VertexProcessor<FloatPair>(){

            @Override
            public FloatPair receiveVertexValue(int n, String string) {
                return new FloatPair(0.0f, Float.parseFloat(string));
            }
        }, new EdgeProcessor<Float>(){

            @Override
            public Float receiveEdge(int n, int n2, String string) {
                return Float.valueOf(Float.parseFloat(string));
            }
        }, new FloatPairConverter(), new FloatConverter());
    }

    @Override
    protected Tuple getNextResult(TupleFactory tupleFactory) throws ExecException {
        if (this.resultIter.hasNext()) {
            IdFloat idFloat = this.resultIter.next();
            Tuple tuple = tupleFactory.newTuple(2);
            tuple.set(0, (Object)Float.valueOf(idFloat.getValue()));
            tuple.set(1, (Object)idFloat.getVertexId());
            return tuple;
        }
        return null;
    }

    @Override
    protected String getStatusString() {
        GraphChiContext graphChiContext;
        if (this.engine != null && (graphChiContext = this.engine.getContext()) != null) {
            return graphChiContext.getCurInterval() + " iteration: " + graphChiContext.getIteration() + "/" + graphChiContext.getNumIterations();
        }
        return "Initializing";
    }
}

