/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.pers.graph_generator;

import com.twitter.pers.graph_generator.EdgeListOutput;
import com.twitter.pers.graph_generator.GraphOutput;
import java.util.ArrayList;
import java.util.Random;

public class RMATGraphGenerator {
    private GraphOutput outputter;
    private double pA;
    private double pB;
    private double pC;
    private double pD;
    private long numEdges;
    private int numVertices;

    public RMATGraphGenerator(GraphOutput graphOutput, double d, double d2, double d3, double d4, int n, long l) {
        this.outputter = graphOutput;
        this.pA = d;
        this.pB = d2;
        this.pC = d3;
        this.pD = d4;
        if (Math.abs(d + d2 + d3 + d4 - 1.0) > 0.01) {
            throw new IllegalArgumentException("Probabilities do not add up to one!");
        }
        this.numVertices = n;
        this.numEdges = l;
    }

    public void execute() {
        int n = Runtime.getRuntime().availableProcessors();
        ArrayList<Thread> arrayList = new ArrayList<Thread>();
        for (int i = 0; i < n; ++i) {
            Thread thread = new Thread(new RMATGenerator(this.numEdges / (long)n));
            thread.start();
            arrayList.add(thread);
        }
        try {
            for (Thread thread : arrayList) {
                thread.join();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }

    public static void main(String[] stringArray) {
        int n = 0;
        String string = stringArray[n++];
        int n2 = Integer.parseInt(stringArray[n++]);
        long l = Long.parseLong(stringArray[n++]);
        double d = Double.parseDouble(stringArray[n++]);
        double d2 = Double.parseDouble(stringArray[n++]);
        double d3 = Double.parseDouble(stringArray[n++]);
        double d4 = Double.parseDouble(stringArray[n++]);
        System.out.println("Going to create graph with approx. " + n2 + " vertices and " + l + " edges");
        long l2 = System.currentTimeMillis();
        RMATGraphGenerator rMATGraphGenerator = new RMATGraphGenerator(new EdgeListOutput(string), d, d2, d3, d4, n2, l);
        rMATGraphGenerator.execute();
        System.out.println("Generating took " + (double)(System.currentTimeMillis() - l2) * 0.001 + " secs");
    }

    private class RMATGenerator
    implements Runnable {
        private long edgesToGenerate;

        private RMATGenerator(long l) {
            this.edgesToGenerate = l;
        }

        @Override
        public void run() {
            int n = 1000000;
            long l = 0L;
            Random random = new Random(System.currentTimeMillis() + (long)this.hashCode());
            double d = RMATGraphGenerator.this.pA;
            double d2 = d + RMATGraphGenerator.this.pB;
            double d3 = d2 + RMATGraphGenerator.this.pC;
            double d4 = 1.0;
            assert (d4 > d3);
            while (this.edgesToGenerate > l) {
                int n2 = (int)Math.min(this.edgesToGenerate - l, (long)n);
                int[] nArray = new int[n2];
                int[] nArray2 = new int[n2];
                for (int i = 0; i < n2; ++i) {
                    int n3 = 0;
                    int n4 = RMATGraphGenerator.this.numVertices - 1;
                    int n5 = 0;
                    int n6 = RMATGraphGenerator.this.numVertices - 1;
                    while (n3 != n4 || n5 != n6) {
                        double d5 = random.nextDouble();
                        if (d5 < d) {
                            n4 = n3 + (n4 - n3) / 2;
                            n6 = n5 + (n6 - n5) / 2;
                            continue;
                        }
                        if (d5 < d2) {
                            n3 = n4 - (n4 - n3) / 2;
                            n6 = n5 + (n6 - n5) / 2;
                            continue;
                        }
                        if (d5 < d3) {
                            n4 = n3 + (n4 - n3) / 2;
                            n5 = n6 - (n6 - n5) / 2;
                            continue;
                        }
                        n3 = n4 - (n4 - n3) / 2;
                        n5 = n6 - (n6 - n5) / 2;
                    }
                    nArray[i] = n3;
                    nArray2[i] = n5;
                }
                RMATGraphGenerator.this.outputter.addEdges(nArray, nArray2);
                System.out.println(Thread.currentThread().getId() + " created " + (l += (long)n2) + " edges.");
            }
            RMATGraphGenerator.this.outputter.finishUp();
        }
    }
}

