/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.graphchi.apps;

import edu.cmu.graphchi.ChiFilenames;
import edu.cmu.graphchi.ChiLogger;
import edu.cmu.graphchi.ChiVertex;
import edu.cmu.graphchi.GraphChiContext;
import edu.cmu.graphchi.GraphChiProgram;
import edu.cmu.graphchi.datablocks.IntConverter;
import edu.cmu.graphchi.engine.GraphChiEngine;
import edu.cmu.graphchi.engine.VertexInterval;
import edu.cmu.graphchi.preprocessing.EdgeProcessor;
import edu.cmu.graphchi.preprocessing.FastSharder;
import edu.cmu.graphchi.preprocessing.VertexProcessor;
import edu.cmu.graphchi.util.LabelAnalysis;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;

public class ConnectedComponents
implements GraphChiProgram<Integer, Integer> {
    private static Logger logger = ChiLogger.getLogger("connectedcomponents");

    @Override
    public void update(ChiVertex<Integer, Integer> chiVertex, GraphChiContext graphChiContext) {
        int n;
        int n2;
        int n3 = graphChiContext.getIteration();
        int n4 = chiVertex.numEdges();
        if (n3 == 0) {
            chiVertex.setValue(chiVertex.getId());
            graphChiContext.getScheduler().addTask(chiVertex.getId());
        }
        int n5 = chiVertex.getValue();
        for (n2 = 0; n2 < n4; ++n2) {
            n = chiVertex.edge(n2).getValue();
            if (n3 == 0) {
                n = chiVertex.edge(n2).getVertexId();
            }
            if (n >= n5) continue;
            n5 = n;
        }
        chiVertex.setValue(n5);
        n2 = n5;
        if (n3 > 0) {
            for (n = 0; n < n4; ++n) {
                if (chiVertex.edge(n).getValue() <= n2) continue;
                chiVertex.edge(n).setValue(n2);
                graphChiContext.getScheduler().addTask(chiVertex.edge(n).getVertexId());
            }
        } else {
            for (n = 0; n < chiVertex.numOutEdges(); ++n) {
                chiVertex.outEdge(n).setValue(n2);
            }
        }
    }

    @Override
    public void beginIteration(GraphChiContext graphChiContext) {
    }

    @Override
    public void endIteration(GraphChiContext graphChiContext) {
    }

    @Override
    public void beginInterval(GraphChiContext graphChiContext, VertexInterval vertexInterval) {
    }

    @Override
    public void endInterval(GraphChiContext graphChiContext, VertexInterval vertexInterval) {
    }

    @Override
    public void beginSubInterval(GraphChiContext graphChiContext, VertexInterval vertexInterval) {
    }

    @Override
    public void endSubInterval(GraphChiContext graphChiContext, VertexInterval vertexInterval) {
    }

    protected static FastSharder createSharder(String string, int n) throws IOException {
        return new FastSharder<Integer, Integer>(string, n, new VertexProcessor<Integer>(){

            @Override
            public Integer receiveVertexValue(int n, String string) {
                return 0;
            }
        }, new EdgeProcessor<Integer>(){

            @Override
            public Integer receiveEdge(int n, int n2, String string) {
                return 0;
            }
        }, new IntConverter(), new IntConverter());
    }

    public static void main(String[] stringArray) throws Exception {
        String string = stringArray[0];
        int n = Integer.parseInt(stringArray[1]);
        String string2 = stringArray.length >= 3 ? stringArray[2] : null;
        FastSharder fastSharder = ConnectedComponents.createSharder(string, n);
        if (string.equals("pipein")) {
            fastSharder.shard(System.in, string2);
        } else if (!new File(ChiFilenames.getFilenameIntervals(string, n)).exists()) {
            fastSharder.shard((InputStream)new FileInputStream(new File(string)), string2);
        } else {
            logger.info("Found shards -- no need to preprocess");
        }
        GraphChiEngine<Integer, Integer> graphChiEngine = new GraphChiEngine<Integer, Integer>(string, n);
        graphChiEngine.setEdataConverter(new IntConverter());
        graphChiEngine.setVertexDataConverter(new IntConverter());
        graphChiEngine.setEnableScheduler(true);
        graphChiEngine.run(new ConnectedComponents(), 5);
        logger.info("Ready. Going to output...");
        LabelAnalysis.computeLabels(string, graphChiEngine.numVertices(), graphChiEngine.getVertexIdTranslate());
        logger.info("Finished. See file: " + string + ".components");
    }
}

