/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.graphchi.apps.kcore;

import edu.cmu.graphchi.ChiFilenames;
import edu.cmu.graphchi.ChiLogger;
import edu.cmu.graphchi.ChiVertex;
import edu.cmu.graphchi.GraphChiContext;
import edu.cmu.graphchi.GraphChiProgram;
import edu.cmu.graphchi.datablocks.IntConverter;
import edu.cmu.graphchi.engine.GraphChiEngine;
import edu.cmu.graphchi.engine.VertexInterval;
import edu.cmu.graphchi.io.CompressedIO;
import edu.cmu.graphchi.preprocessing.EdgeProcessor;
import edu.cmu.graphchi.preprocessing.FastSharder;
import edu.cmu.graphchi.preprocessing.VertexIdTranslate;
import edu.cmu.graphchi.preprocessing.VertexProcessor;
import edu.cmu.graphchi.util.IdInt;
import edu.cmu.graphchi.util.Toplist;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;

public class KCoreDecomposer
implements GraphChiProgram<Integer, Integer> {
    public static final int INFINITY = Integer.MAX_VALUE;
    protected int vertexValuesUpdated;
    protected static int nVertexes = 0;
    private static int nIterations = 0;
    protected static BufferedWriter bw;
    private static Logger logger;

    public static void startWriting(File file, boolean bl) throws IOException {
        FileWriter fileWriter = new FileWriter(file, bl);
        bw = new BufferedWriter(fileWriter);
    }

    public static void stopWriting() throws IOException {
        bw.close();
    }

    @Override
    public void update(ChiVertex<Integer, Integer> chiVertex, GraphChiContext graphChiContext) {
        int n = graphChiContext.getIteration();
        int n2 = chiVertex.numOutEdges();
        if (n == 0) {
            chiVertex.setValue(n2);
            this.broadcastValue(chiVertex, n2);
            ++nVertexes;
            ++this.vertexValuesUpdated;
        } else {
            int n3;
            int n4 = chiVertex.getValue() + 1;
            int n5 = 0;
            int n6 = 0;
            SortedMap<Integer, Integer> sortedMap = Collections.synchronizedSortedMap(new TreeMap(Collections.reverseOrder()));
            for (n3 = 0; n3 <= chiVertex.numOutEdges(); ++n3) {
                sortedMap.put(n3, 0);
            }
            for (n3 = 0; n3 < chiVertex.numInEdges(); ++n3) {
                int n7 = chiVertex.inEdge(n3).getValue();
                if (n7 >= n4) {
                    ++n5;
                    continue;
                }
                try {
                    int n8 = (Integer)sortedMap.get(n7);
                    sortedMap.put(n7, n8 + 1);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.exit(0);
                }
            }
            sortedMap.put(n4, n5);
            n6 = this.computeLeastValue(sortedMap);
            if (n6 < chiVertex.getValue()) {
                chiVertex.setValue(n6);
                this.broadcastValue(chiVertex, n6);
                ++this.vertexValuesUpdated;
            }
        }
        graphChiContext.getScheduler().addTask(chiVertex.getId());
    }

    public int computeLeastValue(SortedMap<Integer, Integer> sortedMap) {
        int n = 0;
        for (Map.Entry<Integer, Integer> entry : sortedMap.entrySet()) {
            int n2 = entry.getKey();
            int n3 = entry.getValue();
            if ((n += n3) < n2) continue;
            return n2;
        }
        return 1;
    }

    public void broadcastValue(ChiVertex<Integer, Integer> chiVertex, int n) {
        for (int i = 0; i < chiVertex.numOutEdges(); ++i) {
            chiVertex.outEdge(i).setValue(n);
        }
    }

    @Override
    public void beginIteration(GraphChiContext graphChiContext) {
        this.vertexValuesUpdated = 0;
    }

    @Override
    public void endIteration(GraphChiContext graphChiContext) {
        System.out.println(this.vertexValuesUpdated + " updates.");
        System.out.println("iteration " + graphChiContext.getIteration() + " ends.");
        ++nIterations;
        if (this.vertexValuesUpdated == 0) {
            System.out.println("no updates in this round. No more rounds .. KCore-montresor terminates!");
            graphChiContext.getScheduler().removeAllTasks();
        }
    }

    @Override
    public void beginInterval(GraphChiContext graphChiContext, VertexInterval vertexInterval) {
    }

    @Override
    public void endInterval(GraphChiContext graphChiContext, VertexInterval vertexInterval) {
    }

    @Override
    public void beginSubInterval(GraphChiContext graphChiContext, VertexInterval vertexInterval) {
    }

    @Override
    public void endSubInterval(GraphChiContext graphChiContext, VertexInterval vertexInterval) {
    }

    protected static FastSharder createSharder(String string, int n) throws IOException {
        return new FastSharder<Integer, Integer>(string, n, new VertexProcessor<Integer>(){

            @Override
            public Integer receiveVertexValue(int n, String string) {
                return 0;
            }
        }, new EdgeProcessor<Integer>(){

            @Override
            public Integer receiveEdge(int n, int n2, String string) {
                return 0;
            }
        }, new IntConverter(), new IntConverter());
    }

    public static void main(String[] stringArray) throws IOException {
        String string = "./datasets/";
        String string2 = "./output/";
        String string3 = stringArray[0];
        int n = Integer.parseInt(stringArray[1]);
        String string4 = stringArray[2];
        int n2 = stringArray.length >= 4 ? Integer.valueOf(Integer.parseInt(stringArray[3])) : null;
        CompressedIO.disableCompression();
        String string5 = string + string3;
        FastSharder fastSharder = KCoreDecomposer.createSharder(string5, n);
        if (string5.equals("pipein")) {
            fastSharder.shard(System.in, string4);
        } else if (!new File(ChiFilenames.getFilenameIntervals(string5, n)).exists()) {
            fastSharder.shard((InputStream)new FileInputStream(new File(string5)), string4);
        } else {
            logger.info("Found shards -- no need to preprocess");
        }
        GraphChiEngine<Integer, Integer> graphChiEngine = new GraphChiEngine<Integer, Integer>(string5, n);
        graphChiEngine.setMemoryBudgetMb(n2);
        graphChiEngine.setSkipZeroDegreeVertices(true);
        graphChiEngine.setEnableScheduler(true);
        graphChiEngine.setEdataConverter(new IntConverter());
        graphChiEngine.setVertexDataConverter(new IntConverter());
        graphChiEngine.run(new KCoreDecomposer(), Integer.MAX_VALUE);
        logger.info("Ready.");
        KCoreDecomposer.startWriting(new File(string2 + "out-cores-" + string3), false);
        bw.write(nVertexes + "\n");
        VertexIdTranslate vertexIdTranslate = graphChiEngine.getVertexIdTranslate();
        TreeSet<IdInt> treeSet = Toplist.topListInt(string5, graphChiEngine.numVertices(), graphChiEngine.numVertices());
        for (IdInt idInt : treeSet) {
            float f = idInt.getValue();
            bw.write(vertexIdTranslate.backward(idInt.getVertexId()) + ", " + String.valueOf((int)f) + "\n");
        }
        KCoreDecomposer.stopWriting();
        System.out.println("Vertexes Processed: " + graphChiEngine.numVertices());
        System.out.println("Edges Processed: " + graphChiEngine.numEdges());
        System.out.println("nIterations: " + nIterations);
        System.out.println("Success!");
    }

    static {
        logger = ChiLogger.getLogger("kCoreDecomposition");
    }
}

