/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.graphchi.apps.recommendations;

import edu.cmu.graphchi.ChiFilenames;
import edu.cmu.graphchi.ChiLogger;
import edu.cmu.graphchi.preprocessing.VertexIdTranslate;
import edu.cmu.graphchi.queries.VertexQuery;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.logging.Logger;

public class CircleOfTrustSalsa {
    private static final Logger logger = ChiLogger.getLogger("circle-of-trust");
    private VertexQuery queryService;
    private HashMap<Integer, SalsaVertex> hubs;
    private HashMap<Integer, SalsaVertex> authorities;
    private static Map<Integer, ArrayList<Integer>> cache;
    private String graphName;
    private static final int FILTER_LIMIT = 4;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CircleOfTrustSalsa(VertexQuery vertexQuery, final int n) throws Exception {
        this.queryService = vertexQuery;
        Class<CircleOfTrustSalsa> clazz = CircleOfTrustSalsa.class;
        synchronized (CircleOfTrustSalsa.class) {
            if (cache == null) {
                cache = Collections.synchronizedMap(new LinkedHashMap<Integer, ArrayList<Integer>>(n, 1.0f, true){

                    @Override
                    protected boolean removeEldestEntry(Map.Entry<Integer, ArrayList<Integer>> entry) {
                        return this.size() > n;
                    }
                });
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public void initializeGraph(Collection<Integer> collection) {
        int n;
        Object object;
        this.hubs = new HashMap(collection.size(), 1.0f);
        long l = System.currentTimeMillis();
        int n2 = 0;
        int n3 = 0;
        HashSet<Integer> hashSet = new HashSet<Integer>(collection.size());
        Object object2 = collection.iterator();
        while (object2.hasNext()) {
            int n4 = object2.next();
            this.hubs.put(n4, new SalsaVertex(n4));
            if (cache.containsKey(n4)) {
                SalsaVertex salsaVertex = this.hubs.get(n4);
                salsaVertex.neighbors = cache.get(n4);
                salsaVertex.degree = salsaVertex.neighbors.size();
                ++n3;
                continue;
            }
            hashSet.add(n4);
        }
        object2 = this.queryService.queryOutNeighbors(hashSet);
        long l2 = System.currentTimeMillis() - l;
        l = System.currentTimeMillis();
        for (Map.Entry object3 : ((HashMap)object2).entrySet()) {
            int n4 = (Integer)object3.getKey();
            SalsaVertex salsaVertex = this.hubs.get(n4);
            salsaVertex.neighbors = (ArrayList)object3.getValue();
            salsaVertex.degree = ((ArrayList)object3.getValue()).size();
            cache.put(n4, (ArrayList<Integer>)object3.getValue());
        }
        for (SalsaVertex salsaVertex : this.hubs.values()) {
            n2 += salsaVertex.neighbors.size();
        }
        long l3 = System.currentTimeMillis() - l;
        int[] nArray = new int[n2];
        int n5 = 0;
        for (SalsaVertex salsaVertex : this.hubs.values()) {
            object = salsaVertex.neighbors.iterator();
            while (object.hasNext()) {
                n = object.next();
                nArray[n5++] = n;
            }
        }
        assert (n5 == nArray.length);
        Arrays.sort(nArray);
        int n6 = -1;
        int n7 = 0;
        object = new ArrayList(1 + nArray.length / 100);
        for (n = 0; n < nArray.length; ++n) {
            int n8 = nArray[n];
            if (n6 != n8) {
                if (n6 >= 0) {
                    if (n7 > 4) {
                        SalsaVertex salsaVertex = new SalsaVertex(n6);
                        salsaVertex.degree = n7;
                        ((ArrayList)object).add(salsaVertex);
                    }
                    n7 = 0;
                }
                n6 = n8;
            }
            ++n7;
        }
        this.authorities = new HashMap(((ArrayList)object).size());
        Iterator iterator = ((ArrayList)object).iterator();
        while (iterator.hasNext()) {
            SalsaVertex salsaVertex = (SalsaVertex)iterator.next();
            this.authorities.put(salsaVertex.id, salsaVertex);
        }
    }

    public void computeSALSA(int n) {
        for (int i = 0; i < n; ++i) {
            double d;
            for (SalsaVertex salsaVertex : this.hubs.values()) {
                d = 0.0;
                int n2 = 0;
                for (int n3 : salsaVertex.neighbors) {
                    SalsaVertex salsaVertex2 = this.authorities.get(n3);
                    if (salsaVertex2 == null) continue;
                    d += salsaVertex2.value / (double)salsaVertex2.degree;
                    ++n2;
                }
                salsaVertex.value = d;
                salsaVertex.degree = n2;
            }
            for (SalsaVertex salsaVertex : this.authorities.values()) {
                salsaVertex.value = 0.0;
            }
            for (SalsaVertex salsaVertex : this.hubs.values()) {
                d = salsaVertex.value / (double)salsaVertex.degree;
                for (int n4 : salsaVertex.neighbors) {
                    SalsaVertex salsaVertex3 = this.authorities.get(n4);
                    if (salsaVertex3 == null) continue;
                    salsaVertex3.value += d;
                }
            }
        }
    }

    public VertexQuery getQueryService() {
        return this.queryService;
    }

    public ArrayList<SalsaVertex> topAuthorities(int n, HashSet<Integer> hashSet) {
        ArrayList<SalsaVertex> arrayList = new ArrayList<SalsaVertex>(this.authorities.size());
        arrayList.addAll(this.authorities.values());
        Collections.sort(arrayList, new Comparator<SalsaVertex>(){

            @Override
            public int compare(SalsaVertex salsaVertex, SalsaVertex salsaVertex2) {
                if (salsaVertex.value < salsaVertex2.value) {
                    return 1;
                }
                return salsaVertex.value > salsaVertex2.value ? -1 : 0;
            }
        });
        ArrayList<SalsaVertex> arrayList2 = new ArrayList<SalsaVertex>(n);
        for (int i = 0; arrayList2.size() < n && i < arrayList.size(); ++i) {
            SalsaVertex salsaVertex = (SalsaVertex)arrayList.get(i);
            if (hashSet.contains(salsaVertex.id)) continue;
            arrayList2.add(salsaVertex);
        }
        return arrayList2;
    }

    public String namify(Integer n) throws IOException {
        File file = new File(this.graphName + "_names.dat");
        if (!file.exists()) {
            System.out.println("didn't find name file: " + file.getPath());
            return n + "";
        }
        int n2 = n * 16;
        RandomAccessFile randomAccessFile = new RandomAccessFile(file.getAbsolutePath(), "r");
        randomAccessFile.seek(n2);
        byte[] byArray = new byte[16];
        randomAccessFile.read(byArray);
        randomAccessFile.close();
        return new String(byArray) + "(" + n + ")";
    }

    public static void main(String[] stringArray) throws Exception {
        String string = stringArray[0];
        int n = Integer.parseInt(stringArray[1]);
        CircleOfTrustSalsa circleOfTrustSalsa = new CircleOfTrustSalsa(new VertexQuery(string, n), 10000);
        VertexIdTranslate vertexIdTranslate = VertexIdTranslate.fromFile(new File(ChiFilenames.getVertexTranslateDefFile(string, n)));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        block0: while (true) {
            ArrayList<SalsaVertex> arrayList;
            System.out.print("Enter vertex id to query >> :: ");
            String string2 = bufferedReader.readLine();
            int n2 = Integer.parseInt(string2);
            Object object = circleOfTrustSalsa.queryService.queryOutNeighbors(vertexIdTranslate.forward(n2));
            int n3 = 300;
            if (((HashSet)object).size() > n3) {
                Serializable serializable;
                int[] nArray = new int[((HashSet)object).size()];
                int n4 = 0;
                arrayList = ((HashSet)object).iterator();
                while (arrayList.hasNext()) {
                    serializable = arrayList.next();
                    nArray[n4++] = (Integer)serializable;
                }
                arrayList = new HashSet();
                serializable = new Random(260379L);
                for (n4 = 0; n4 < n3; ++n4) {
                    ((HashSet)((Object)arrayList)).add((SalsaVertex)((Object)Integer.valueOf(nArray[Math.abs(((Random)serializable).nextInt()) % nArray.length])));
                }
                object = arrayList;
            }
            circleOfTrustSalsa.initializeGraph((Collection<Integer>)object);
            long l = System.currentTimeMillis();
            circleOfTrustSalsa.computeSALSA(3);
            logger.info("SALSA computation took " + (System.currentTimeMillis() - l) + "ms");
            ((HashSet)object).add(vertexIdTranslate.forward(n2));
            arrayList = circleOfTrustSalsa.topAuthorities(20, (HashSet<Integer>)object);
            int n5 = 1;
            Iterator<SalsaVertex> iterator = arrayList.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block0;
                SalsaVertex salsaVertex = iterator.next();
                int n6 = vertexIdTranslate.backward(salsaVertex.id);
                logger.info("Top " + n5++ + " = " + n6 + " " + circleOfTrustSalsa.namify(n6) + " (" + salsaVertex.value + ")");
            }
            break;
        }
    }

    static class SalsaVertex {
        int id;
        int degree = 0;
        double value = 1.0;
        ArrayList<Integer> neighbors;

        SalsaVertex(int n) {
            this.id = n;
        }
    }
}

