/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.graphchi.apps.recommendations;

import edu.cmu.graphchi.ChiFilenames;
import edu.cmu.graphchi.ChiLogger;
import edu.cmu.graphchi.ChiVertex;
import edu.cmu.graphchi.EdgeDirection;
import edu.cmu.graphchi.EmptyType;
import edu.cmu.graphchi.apps.recommendations.CircleOfTrustSalsa;
import edu.cmu.graphchi.preprocessing.FastSharder;
import edu.cmu.graphchi.queries.VertexQuery;
import edu.cmu.graphchi.util.IdCount;
import edu.cmu.graphchi.walks.DrunkardContext;
import edu.cmu.graphchi.walks.DrunkardJob;
import edu.cmu.graphchi.walks.DrunkardMobEngine;
import edu.cmu.graphchi.walks.IntDrunkardContext;
import edu.cmu.graphchi.walks.IntDrunkardFactory;
import edu.cmu.graphchi.walks.IntWalkArray;
import edu.cmu.graphchi.walks.WalkArray;
import edu.cmu.graphchi.walks.WalkUpdateFunction;
import edu.cmu.graphchi.walks.distributions.IntDrunkardCompanion;
import edu.cmu.graphchi.walks.distributions.RemoteDrunkardCompanion;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.Naming;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;

public class TwitterWTF
implements WalkUpdateFunction<EmptyType, EmptyType> {
    private static double RESET_PROBABILITY = 0.15;
    private static Logger logger = ChiLogger.getLogger("twitter-wtf");
    private DrunkardMobEngine<EmptyType, EmptyType> drunkardMobEngine;
    private String baseFilename;
    private int firstSource;
    private int numSources;
    private int numShards;
    private int numWalksPerSource;
    private int salsaCacheSize = Integer.parseInt(System.getProperty("salsacache", "100000"));
    private String companionUrl;

    public TwitterWTF(String string, String string2, int n, int n2, int n3, int n4) throws Exception {
        this.baseFilename = string2;
        this.drunkardMobEngine = new DrunkardMobEngine(string2, n, new IntDrunkardFactory());
        this.numShards = n;
        this.companionUrl = string;
        this.firstSource = n2;
        this.numSources = n3;
        this.numWalksPerSource = n4;
    }

    private void execute(int n) throws Exception {
        File file = new File(this.baseFilename);
        final RemoteDrunkardCompanion remoteDrunkardCompanion = this.companionUrl.equals("local") ? new IntDrunkardCompanion(4, Runtime.getRuntime().maxMemory() / 3L) : (RemoteDrunkardCompanion)Naming.lookup(this.companionUrl);
        DrunkardJob drunkardJob = this.drunkardMobEngine.addJob("twitterwtf", EdgeDirection.OUT_EDGES, this, remoteDrunkardCompanion);
        drunkardJob.configureSourceRangeInternalIds(this.firstSource, this.numSources, this.numWalksPerSource);
        this.drunkardMobEngine.run(n);
        this.drunkardMobEngine = null;
        drunkardJob = null;
        final long l = System.currentTimeMillis();
        final AtomicInteger atomicInteger = new AtomicInteger();
        final AtomicInteger atomicInteger2 = new AtomicInteger();
        ExecutorService executorService = Executors.newFixedThreadPool(4);
        logger.info("Started 4 threads");
        final ThreadLocal<VertexQuery> threadLocal = new ThreadLocal<VertexQuery>(){

            @Override
            protected VertexQuery initialValue() {
                try {
                    return new VertexQuery(TwitterWTF.this.baseFilename, TwitterWTF.this.numShards);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    throw new RuntimeException(iOException);
                }
            }
        };
        long l2 = System.currentTimeMillis();
        int n2 = this.firstSource;
        while (n2 < this.firstSource + this.numSources) {
            final int n3 = n2++;
            atomicInteger2.incrementAndGet();
            executorService.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        CircleOfTrustSalsa circleOfTrustSalsa = new CircleOfTrustSalsa((VertexQuery)threadLocal.get(), TwitterWTF.this.salsaCacheSize);
                        TwitterWTF.this.computeRecs(remoteDrunkardCompanion, 200, l, circleOfTrustSalsa, atomicInteger, n3);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    atomicInteger2.decrementAndGet();
                }
            });
        }
        while (atomicInteger2.get() > 0) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            System.out.println("Pending WTF queries: " + atomicInteger2.get());
        }
        System.out.println("WTF-recs," + (System.currentTimeMillis() - l2));
    }

    private void computeRecs(RemoteDrunkardCompanion remoteDrunkardCompanion, int n, long l, CircleOfTrustSalsa circleOfTrustSalsa, AtomicInteger atomicInteger, int n2) throws IOException {
        IdCount[] idCountArray = remoteDrunkardCompanion.getTop(n2, n);
        HashSet<Integer> hashSet = new HashSet<Integer>(idCountArray.length);
        for (IdCount idCount : idCountArray) {
            hashSet.add(idCount.id);
        }
        circleOfTrustSalsa.initializeGraph(hashSet);
        circleOfTrustSalsa.computeSALSA(4);
        HashSet<Integer> hashSet2 = circleOfTrustSalsa.getQueryService().queryOutNeighbors(n2);
        hashSet2.add(n2);
        ArrayList<CircleOfTrustSalsa.SalsaVertex> arrayList = circleOfTrustSalsa.topAuthorities(10, hashSet2);
        int n3 = atomicInteger.incrementAndGet();
        if (n3 % 100 == 0) {
            long l2 = System.currentTimeMillis() - l;
            logger.info("Computed recommendations for " + n3 + " users in " + l2 + "ms");
            logger.info("Average: " + (double)l2 / (double)(n2 - this.firstSource + 1) + "ms");
        }
    }

    @Override
    public void processWalksAtVertex(WalkArray walkArray, ChiVertex<EmptyType, EmptyType> chiVertex, DrunkardContext drunkardContext, Random random) {
        int[] nArray = ((IntWalkArray)walkArray).getArray();
        IntDrunkardContext intDrunkardContext = (IntDrunkardContext)drunkardContext;
        int n = nArray.length;
        int n2 = chiVertex.numOutEdges();
        if (n2 > 0) {
            for (int i = 0; i < n; ++i) {
                int n3 = nArray[i];
                if (random.nextDouble() < RESET_PROBABILITY) {
                    intDrunkardContext.resetWalk(n3, false);
                    continue;
                }
                int n4 = chiVertex.getOutEdgeId(random.nextInt(n2));
                boolean bl = !intDrunkardContext.isWalkStartedFromVertex(n3);
                intDrunkardContext.forwardWalkTo(n3, n4, bl);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                intDrunkardContext.resetWalk(nArray[i], false);
            }
        }
    }

    @Override
    public int[] getNotTrackedVertices(ChiVertex<EmptyType, EmptyType> chiVertex) {
        int[] nArray = new int[]{chiVertex.getId()};
        return nArray;
    }

    protected static FastSharder createSharder(String string, int n) throws IOException {
        return new FastSharder(string, n, null, null, null, null);
    }

    public static void main(String[] stringArray) throws Exception {
        long l = System.currentTimeMillis();
        Options options = new Options();
        options.addOption("g", "graph", true, "graph file name");
        options.addOption("n", "nshards", true, "number of shards");
        options.addOption("t", "filetype", true, "filetype (edgelist|adjlist)");
        options.addOption("f", "firstsource", true, "id of the first source vertex (internal id)");
        options.addOption("s", "nsources", true, "number of sources");
        options.addOption("w", "walkspersource", true, "number of walks to start from each source");
        options.addOption("i", "niters", true, "number of iterations");
        options.addOption("u", "companion", true, "RMI url to the DrunkardCompanion or 'local' (default)");
        try {
            FastSharder fastSharder;
            String string;
            PosixParser posixParser = new PosixParser();
            CommandLine commandLine = posixParser.parse(options, stringArray);
            String string2 = commandLine.getOptionValue("graph");
            int n = Integer.parseInt(commandLine.getOptionValue("nshards"));
            String string3 = string = commandLine.hasOption("filetype") ? commandLine.getOptionValue("filetype") : null;
            if (string2.equals("pipein")) {
                fastSharder = TwitterWTF.createSharder(string2, n);
                fastSharder.shard(System.in, string);
            } else {
                fastSharder = TwitterWTF.createSharder(string2, n);
                if (!new File(ChiFilenames.getFilenameIntervals(string2, n)).exists()) {
                    fastSharder.shard((InputStream)new FileInputStream(new File(string2)), string);
                } else {
                    logger.info("Found shards -- no need to pre-process");
                }
            }
            int n2 = Integer.parseInt(commandLine.getOptionValue("firstsource"));
            int n3 = Integer.parseInt(commandLine.getOptionValue("nsources"));
            int n4 = Integer.parseInt(commandLine.getOptionValue("walkspersource"));
            int n5 = Integer.parseInt(commandLine.getOptionValue("niters"));
            String string4 = commandLine.hasOption("companion") ? commandLine.getOptionValue("companion") : "local";
            TwitterWTF twitterWTF = new TwitterWTF(string4, string2, n, n2, n3, n4);
            twitterWTF.execute(n5);
            System.out.println("WTF-log," + (System.currentTimeMillis() - l) + "," + n2 + "," + (n2 + n3 - 1) + "," + n4 + "," + n5);
            System.exit(0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("TwitterWTF", options);
        }
    }
}

