/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.graphchi.datablocks;

import edu.cmu.graphchi.datablocks.BytesToValueConverter;
import edu.cmu.graphchi.datablocks.ChiPointer;
import java.util.ArrayList;

public class DataBlockManager {
    private ArrayList<byte[]> blocks = new ArrayList(32678);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int allocateBlock(int n) {
        byte[] byArray = new byte[n];
        ArrayList<byte[]> arrayList = this.blocks;
        synchronized (arrayList) {
            int n2 = this.blocks.size();
            this.blocks.add(n2, byArray);
            return n2;
        }
    }

    public byte[] getRawBlock(int n) {
        byte[] byArray = this.blocks.get(n);
        if (byArray == null) {
            throw new IllegalStateException("Null-reference!");
        }
        return byArray;
    }

    public void reset() {
        for (int i = 0; i < this.blocks.size(); ++i) {
            if (this.blocks.get(i) == null) continue;
            throw new RuntimeException("Tried to reset block manager, but it was non-empty at index: " + i);
        }
        this.blocks.clear();
    }

    public boolean empty() {
        for (int i = 0; i < this.blocks.size(); ++i) {
            if (this.blocks.get(i) == null) continue;
            return false;
        }
        return true;
    }

    public void release(int n) {
        this.blocks.set(n, null);
    }

    public <T> T dereference(ChiPointer chiPointer, BytesToValueConverter<T> bytesToValueConverter) {
        byte[] byArray = new byte[bytesToValueConverter.sizeOf()];
        if (chiPointer == null) {
            throw new IllegalStateException("Tried to dereference a null pointer!");
        }
        System.arraycopy(this.getRawBlock(chiPointer.blockId), chiPointer.offset, byArray, 0, byArray.length);
        return bytesToValueConverter.getValue(byArray);
    }

    public <T> void writeValue(ChiPointer chiPointer, BytesToValueConverter<T> bytesToValueConverter, T t) {
        byte[] byArray = new byte[bytesToValueConverter.sizeOf()];
        bytesToValueConverter.setValue(byArray, t);
        System.arraycopy(byArray, 0, this.getRawBlock(chiPointer.blockId), chiPointer.offset, byArray.length);
    }

    public <T> void writeValue(ChiPointer chiPointer, byte[] byArray) {
        System.arraycopy(byArray, 0, this.getRawBlock(chiPointer.blockId), chiPointer.offset, byArray.length);
    }
}

