/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.graphchi.engine.auxdata;

import edu.cmu.graphchi.ChiFilenames;
import edu.cmu.graphchi.ChiLogger;
import edu.cmu.graphchi.datablocks.BytesToValueConverter;
import edu.cmu.graphchi.datablocks.ChiPointer;
import edu.cmu.graphchi.datablocks.DataBlockManager;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Logger;
import nom.tam.util.BufferedDataInputStream;
import ucar.unidata.io.RandomAccessFile;

public class VertexData<VertexDataType> {
    private byte[] vertexData;
    private int vertexSt;
    private int vertexEn;
    private String baseFilename;
    private RandomAccessFile vertexDataFile;
    private BytesToValueConverter<VertexDataType> converter;
    private DataBlockManager blockManager;
    private boolean sparse;
    private int[] index;
    private int lastOffset = 0;
    private int lastStart = 0;
    private static final Logger logger = ChiLogger.getLogger("vertex-data");

    public VertexData(int n, String string, BytesToValueConverter<VertexDataType> bytesToValueConverter) throws IOException {
        this(n, string, bytesToValueConverter, true);
    }

    public VertexData(int n, String string, BytesToValueConverter<VertexDataType> bytesToValueConverter, boolean bl) throws IOException {
        this.baseFilename = string;
        this.converter = bytesToValueConverter;
        this.sparse = bl;
        File file = new File(ChiFilenames.getFilenameOfDegreeData(string, true));
        if (this.sparse && !file.exists()) {
            this.sparse = false;
            logger.info("Sparse vertex data was allowed but sparse degree file did not exist  using dense");
        }
        File file2 = new File(ChiFilenames.getFilenameOfVertexData(string, bytesToValueConverter, this.sparse));
        if (!this.sparse) {
            long l = (long)bytesToValueConverter.sizeOf() * (long)n;
            logger.info("Vertex file [" + file2.getAbsolutePath() + "] length: " + file2.length() + ", nvertices=" + n + ", expected size: " + l);
            if (!file2.exists() || file2.length() < l) {
                long l2;
                if (!file2.exists()) {
                    file2.createNewFile();
                }
                logger.warning("Vertex data file did not exists, creating it. Vertices: " + n);
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                byte[] byArray = new byte[32678];
                for (long i = 0L; i < l; i += l2) {
                    l2 = Math.min(l - i, (long)byArray.length);
                    fileOutputStream.write(byArray, 0, (int)l2);
                }
                fileOutputStream.close();
            }
        } else if (!file2.exists()) {
            BufferedDataInputStream bufferedDataInputStream = new BufferedDataInputStream(new FileInputStream(file));
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file2)));
            byte[] byArray = new byte[bytesToValueConverter.sizeOf()];
            try {
                while (true) {
                    int n2 = Integer.reverseBytes(bufferedDataInputStream.readInt());
                    bufferedDataInputStream.skipBytes(8);
                    dataOutputStream.writeInt(Integer.reverseBytes(n2));
                    dataOutputStream.write(byArray);
                }
            }
            catch (EOFException eOFException) {
                dataOutputStream.close();
                bufferedDataInputStream.close();
            }
        }
        this.vertexDataFile = new RandomAccessFile(file2.getAbsolutePath(), "rwd");
        this.vertexSt = 0;
        this.vertexEn = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAndCommit(int n, int n2) throws IOException {
        assert (n2 >= 0);
        byte[] byArray = this.blockManager.getRawBlock(n2);
        if (!this.sparse) {
            long l = (long)n * (long)this.converter.sizeOf();
            RandomAccessFile randomAccessFile = this.vertexDataFile;
            synchronized (randomAccessFile) {
                this.vertexDataFile.seek(l);
                this.vertexDataFile.write(byArray);
                this.blockManager.release(n2);
                this.vertexDataFile.flush();
            }
            logger.info("Vertex data write: " + l + " -- " + (l + (long)byArray.length));
        } else {
            RandomAccessFile randomAccessFile = this.vertexDataFile;
            synchronized (randomAccessFile) {
                this.vertexDataFile.seek(this.lastOffset);
                int n3 = this.converter.sizeOf();
                for (int i = 0; i < this.index.length; ++i) {
                    this.vertexDataFile.writeInt(Integer.reverseBytes(this.index[i]));
                    this.vertexDataFile.write(byArray, i * n3, n3);
                }
                this.blockManager.release(n2);
                this.vertexDataFile.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int load(int n, int n2) throws IOException {
        this.vertexSt = n;
        this.vertexEn = n2;
        RandomAccessFile randomAccessFile = this.vertexDataFile;
        synchronized (randomAccessFile) {
            int n3;
            if (!this.sparse) {
                long l = (long)(this.vertexEn - this.vertexSt + 1) * (long)this.converter.sizeOf();
                long l2 = (long)this.vertexSt * (long)this.converter.sizeOf();
                int n4 = this.blockManager.allocateBlock((int)l);
                this.vertexData = this.blockManager.getRawBlock(n4);
                this.vertexDataFile.seek(l2);
                this.vertexDataFile.readFully(this.vertexData);
                return n4;
            }
            if (this.lastStart > n) {
                this.vertexDataFile.seek(0L);
            }
            this.lastStart = n;
            int n5 = this.converter.sizeOf();
            long l = this.vertexDataFile.getFilePointer();
            int n6 = 0;
            boolean bl = false;
            try {
                while (true) {
                    n3 = this.vertexDataFile.readInt();
                    if (!bl && n3 >= n) {
                        l = this.vertexDataFile.getFilePointer() - 4L;
                        bl = true;
                    }
                    if (n3 >= n && n3 <= n2) {
                        ++n6;
                    } else if (n3 > this.vertexEn) break;
                    this.vertexDataFile.skipBytes(n5);
                }
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            this.index = new int[n6];
            this.vertexDataFile.seek(l);
            n3 = this.blockManager.allocateBlock(n6 * n5);
            this.vertexData = this.blockManager.getRawBlock(n3);
            int n7 = 0;
            try {
                while (n7 < n6) {
                    int n8 = this.vertexDataFile.readInt();
                    if (n8 >= n && n8 <= n2) {
                        this.index[n7] = n8;
                        this.vertexDataFile.read(this.vertexData, n7 * n5, n5);
                        ++n7;
                        continue;
                    }
                    this.vertexDataFile.skipBytes(n5);
                }
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            if (n7 != n6) {
                throw new IllegalStateException("Mismatch when reading sparse vertex data:" + n7 + " != " + n6);
            }
            this.lastOffset = (int)l;
            return n3;
        }
    }

    public ChiPointer getVertexValuePtr(int n, int n2) {
        assert (n >= this.vertexSt && n <= this.vertexEn);
        if (!this.sparse) {
            return new ChiPointer(n2, (n - this.vertexSt) * this.converter.sizeOf());
        }
        int n3 = Arrays.binarySearch(this.index, n);
        if (n3 < 0) {
            return null;
        }
        return new ChiPointer(n2, n3 * this.converter.sizeOf());
    }

    public void setBlockManager(DataBlockManager dataBlockManager) {
        this.blockManager = dataBlockManager;
    }

    public static int[] createIntArray(int n) {
        return new int[n];
    }

    public Iterator<Integer> currentIterator() {
        if (!this.sparse) {
            return new Iterator<Integer>(){
                int j;
                {
                    this.j = VertexData.this.vertexSt;
                }

                @Override
                public boolean hasNext() {
                    return this.j <= VertexData.this.vertexEn;
                }

                @Override
                public Integer next() {
                    return this.j++;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return new Iterator<Integer>(){
            int j = 0;

            @Override
            public boolean hasNext() {
                return this.j < VertexData.this.index.length;
            }

            @Override
            public Integer next() {
                return VertexData.this.index[this.j++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void close() {
        try {
            this.vertexDataFile.flush();
            this.vertexDataFile.getFD().sync();
            this.vertexDataFile.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

