/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.graphchi.preprocessing;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class VertexIdTranslate {
    private int vertexIntervalLength;
    private int numShards;

    protected VertexIdTranslate() {
    }

    public VertexIdTranslate(int n, int n2) {
        this.vertexIntervalLength = n;
        this.numShards = n2;
    }

    public int forward(int n) {
        return n % this.numShards * this.vertexIntervalLength + n / this.numShards;
    }

    public int backward(int n) {
        int n2 = n / this.vertexIntervalLength;
        int n3 = n % this.vertexIntervalLength;
        return n3 * this.numShards + n2;
    }

    public int getVertexIntervalLength() {
        return this.vertexIntervalLength;
    }

    public int getNumShards() {
        return this.numShards;
    }

    public String stringRepresentation() {
        return "vertex_interval_length=" + this.vertexIntervalLength + "\nnumShards=" + this.numShards + "\n";
    }

    public static VertexIdTranslate fromString(String string) {
        if ("none".equals(string)) {
            return VertexIdTranslate.identity();
        }
        String[] stringArray = string.split("\n");
        int n = -1;
        int n2 = -1;
        for (String string2 : stringArray) {
            if (string2.startsWith("vertex_interval_length=")) {
                n = Integer.parseInt(string2.split("=")[1]);
                continue;
            }
            if (!string2.startsWith("numShards=")) continue;
            n2 = Integer.parseInt(string2.split("=")[1]);
        }
        if (n < 0 || n2 < 0) {
            throw new RuntimeException("Illegal format: " + string);
        }
        return new VertexIdTranslate(n, n2);
    }

    public static VertexIdTranslate fromFile(File file) throws IOException {
        int n = (int)file.length();
        byte[] byArray = new byte[n];
        FileInputStream fileInputStream = new FileInputStream(file);
        fileInputStream.read(byArray);
        fileInputStream.close();
        return VertexIdTranslate.fromString(new String(byArray));
    }

    public static VertexIdTranslate identity() {
        return new VertexIdTranslate(){

            @Override
            public int forward(int n) {
                return n;
            }

            @Override
            public int backward(int n) {
                return n;
            }

            @Override
            public int getVertexIntervalLength() {
                return -1;
            }

            @Override
            public int getNumShards() {
                return -1;
            }

            @Override
            public String stringRepresentation() {
                return "none";
            }
        };
    }
}

