/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.graphchi.shards;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Timer;
import com.yammer.metrics.core.TimerContext;
import edu.cmu.graphchi.ChiFilenames;
import edu.cmu.graphchi.ChiLogger;
import edu.cmu.graphchi.ChiVertex;
import edu.cmu.graphchi.datablocks.BytesToValueConverter;
import edu.cmu.graphchi.datablocks.DataBlockManager;
import edu.cmu.graphchi.io.CompressedIO;
import edu.cmu.graphchi.shards.ShardIndex;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;

public class MemoryShard<EdgeDataType> {
    private String edgeDataFilename;
    private String adjDataFilename;
    private int rangeStart;
    private int rangeEnd;
    private byte[] adjData;
    private int[] blockIds = new int[0];
    private int[] blockSizes = new int[0];
    private int edataFilesize;
    private boolean loaded = false;
    private boolean onlyAdjacency = false;
    private boolean hasSetRangeOffset = false;
    private boolean hasSetOffset = false;
    private int rangeStartOffset;
    private int rangeStartEdgePtr;
    private int rangeContVid;
    private int adjDataLength;
    private DataBlockManager dataBlockManager;
    private BytesToValueConverter<EdgeDataType> converter;
    private int streamingOffset;
    private int streamingOffsetEdgePtr;
    private int streamingOffsetVid;
    private int blocksize = 0;
    private final Timer loadAdjTimer = Metrics.defaultRegistry().newTimer(MemoryShard.class, "load-adj", TimeUnit.SECONDS, TimeUnit.MINUTES);
    private final Timer loadVerticesTimers = Metrics.defaultRegistry().newTimer(MemoryShard.class, "load-vertices", TimeUnit.SECONDS, TimeUnit.MINUTES);
    private static final Logger logger = ChiLogger.getLogger("memoryshard");
    private ArrayList<ShardIndex.IndexEntry> index;

    private MemoryShard() {
    }

    public MemoryShard(String string, String string2, int n, int n2) {
        this.edgeDataFilename = string;
        this.adjDataFilename = string2;
        this.rangeStart = n;
        this.rangeEnd = n2;
    }

    public void commitAndRelease(boolean bl, boolean bl2) throws IOException {
        int n = this.blockIds.length;
        if (!this.onlyAdjacency && this.loaded) {
            int n2;
            int n3;
            if (bl) {
                if (this.blocksize == 0) {
                    this.blocksize = ChiFilenames.getBlocksize(this.converter.sizeOf());
                }
                n3 = this.rangeStartEdgePtr / this.blocksize;
                for (n2 = 0; n2 < n; ++n2) {
                    String string = ChiFilenames.getFilenameShardEdataBlock(this.edgeDataFilename, n2, this.blocksize);
                    if (n2 >= n3) {
                        CompressedIO.writeCompressed(new File(string), this.dataBlockManager.getRawBlock(this.blockIds[n2]), this.blockSizes[n2]);
                        continue;
                    }
                    CompressedIO.writeCompressed(new File(string), this.dataBlockManager.getRawBlock(this.blockIds[n2]), this.blockSizes[n2]);
                }
            } else if (bl2) {
                n3 = this.streamingOffsetEdgePtr;
                if (n3 == 0) {
                    n3 = this.edataFilesize;
                }
                n2 = this.rangeStartEdgePtr / this.blocksize;
                int n4 = n3 / this.blocksize;
                for (int i = n2; i <= n4; ++i) {
                    String string = ChiFilenames.getFilenameShardEdataBlock(this.edgeDataFilename, i, this.blocksize);
                    CompressedIO.writeCompressed(new File(string), this.dataBlockManager.getRawBlock(this.blockIds[i]), this.blockSizes[i]);
                }
            }
            int[] nArray = this.blockIds;
            n2 = nArray.length;
            for (int i = 0; i < n2; ++i) {
                Integer n5 = nArray[i];
                this.dataBlockManager.release(n5);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadVertices(final int n, final int n2, final ChiVertex[] chiVertexArray, final boolean bl, ExecutorService executorService) throws IOException {
        int n3;
        DataInput dataInput = null;
        if (this.adjData == null) {
            dataInput = this.loadAdj();
            if (!this.onlyAdjacency) {
                this.loadEdata();
            }
        }
        TimerContext timerContext = this.loadVerticesTimers.time();
        if (dataInput != null) {
            this.index = new ArrayList();
            this.index.add(new ShardIndex.IndexEntry(0, 0, 0));
        }
        int n4 = n3 = this.converter == null ? 0 : this.converter.sizeOf();
        if (dataInput == null) {
            final AtomicInteger atomicInteger = new AtomicInteger(this.index.size());
            final Object object = new Object();
            int n5 = 0;
            while (n5 < this.index.size()) {
                final int n6 = n5++;
                executorService.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            MemoryShard.this.loadAdjChunk(n, n2, chiVertexArray, bl, null, n3, n6);
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                            throw new RuntimeException(iOException);
                        }
                        finally {
                            atomicInteger.decrementAndGet();
                            Object object2 = object;
                            synchronized (object2) {
                                object.notifyAll();
                            }
                        }
                    }
                });
            }
            while (atomicInteger.get() > 0) {
                Object object2 = object;
                synchronized (object2) {
                    try {
                        object.wait(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        } else {
            this.loadAdjChunk(n, n2, chiVertexArray, bl, dataInput, n3, 0);
        }
        timerContext.stop();
    }

    private void loadAdjChunk(int n, int n2, ChiVertex[] chiVertexArray, boolean bl, DataInput dataInput, int n3, int n4) throws IOException {
        ShardIndex.IndexEntry indexEntry = this.index.get(n4);
        int n5 = indexEntry.vertex;
        int n6 = n4 < this.index.size() - 1 ? this.index.get((int)(n4 + 1)).vertex : Integer.MAX_VALUE;
        int n7 = indexEntry.edgePointer * n3;
        int n8 = indexEntry.fileOffset;
        int n9 = this.adjDataLength;
        if (n4 < this.index.size() - 1) {
            n9 = this.index.get((int)(n4 + 1)).fileOffset;
        }
        boolean bl2 = n5 < this.rangeEnd && n6 > this.rangeEnd;
        boolean bl3 = n5 <= this.rangeStart && n6 > this.rangeStart;
        DataInput dataInput2 = dataInput != null ? dataInput : new DataInputStream(new ByteArrayInputStream(this.adjData));
        dataInput2.skipBytes(n8);
        try {
            while (n8 < n9) {
                if (bl2 && !this.hasSetOffset && n5 > this.rangeEnd) {
                    this.streamingOffset = n8;
                    this.streamingOffsetEdgePtr = n7;
                    this.streamingOffsetVid = n5;
                    this.hasSetOffset = true;
                }
                if (bl3 && !this.hasSetRangeOffset && n5 >= this.rangeStart) {
                    this.rangeStartOffset = n8;
                    this.rangeStartEdgePtr = n7;
                    this.hasSetRangeOffset = true;
                }
                int n10 = 0;
                int n11 = dataInput2.readUnsignedByte();
                ++n8;
                assert (n11 >= 0);
                if (n11 == 0) {
                    ++n5;
                    int n12 = dataInput2.readUnsignedByte();
                    ++n8;
                    n5 += n12;
                    continue;
                }
                if (n11 == 255) {
                    n10 = Integer.reverseBytes(dataInput2.readInt());
                    n8 += 4;
                } else {
                    n10 = n11;
                }
                ChiVertex chiVertex = null;
                if (n5 >= n && n5 <= n2) {
                    chiVertex = chiVertexArray[n5 - n];
                }
                while (--n10 >= 0) {
                    int n13 = Integer.reverseBytes(dataInput2.readInt());
                    n8 += 4;
                    if (n13 < this.rangeStart || n13 > this.rangeEnd) {
                        throw new IllegalStateException("Target " + n13 + " not in range!");
                    }
                    if (chiVertex != null && !bl) {
                        chiVertex.addOutEdge(this.onlyAdjacency ? -1 : this.blockIds[n7 / this.blocksize], this.onlyAdjacency ? -1 : n7 % this.blocksize, n13);
                    }
                    if (n13 >= n && n13 <= n2) {
                        ChiVertex chiVertex2 = chiVertexArray[n13 - n];
                        if (chiVertex2 != null) {
                            chiVertex2.addInEdge(this.onlyAdjacency ? -1 : this.blockIds[n7 / this.blocksize], this.onlyAdjacency ? -1 : n7 % this.blocksize, n5);
                        }
                        if (chiVertex != null && chiVertex2 != null) {
                            chiVertex2.parallelSafe = false;
                            chiVertex.parallelSafe = false;
                        }
                    }
                    n7 += n3;
                }
                ++n5;
            }
        }
        catch (EOFException eOFException) {
            return;
        }
        if (dataInput2 instanceof InputStream) {
            ((InputStream)((Object)dataInput2)).close();
        }
    }

    private DataInput loadAdj() throws FileNotFoundException, IOException {
        InputStream inputStream;
        File file = new File(this.adjDataFilename + ".gz");
        long l = 0L;
        if (file.exists()) {
            logger.info("Note: using compressed: " + file.getAbsolutePath());
            inputStream = new GZIPInputStream(new FileInputStream(file));
            l = file.length() * 3L / 2L;
        } else {
            inputStream = new FileInputStream(this.adjDataFilename);
            l = new File(this.adjDataFilename).length();
        }
        this.index = new ShardIndex(new File(this.adjDataFilename)).sparserIndex(1232896);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, (int)l / 4);
        TimerContext timerContext = this.loadAdjTimer.time();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream((int)l);
        try {
            int n;
            byte[] byArray = new byte[(int)l / 4];
            while ((n = bufferedInputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        this.adjData = byteArrayOutputStream.toByteArray();
        this.adjDataLength = this.adjData.length;
        bufferedInputStream.close();
        byteArrayOutputStream.close();
        timerContext.stop();
        return null;
    }

    private void loadEdata() throws FileNotFoundException, IOException {
        this.blocksize = ChiFilenames.getBlocksize(this.converter.sizeOf());
        if (!this.loaded) {
            this.edataFilesize = ChiFilenames.getShardEdataSize(this.edgeDataFilename);
            int n = this.edataFilesize / this.blocksize + (this.edataFilesize % this.blocksize == 0 ? 0 : 1);
            this.blockIds = new int[n];
            this.blockSizes = new int[n];
            for (int i = 0; i < n; ++i) {
                int n2 = Math.min(this.edataFilesize - this.blocksize * i, this.blocksize);
                this.blockIds[i] = this.dataBlockManager.allocateBlock(n2);
                this.blockSizes[i] = n2;
                String string = ChiFilenames.getFilenameShardEdataBlock(this.edgeDataFilename, i, this.blocksize);
                CompressedIO.readCompressed(new File(string), this.dataBlockManager.getRawBlock(this.blockIds[i]), n2);
            }
            this.loaded = true;
        }
    }

    public DataBlockManager getDataBlockManager() {
        return this.dataBlockManager;
    }

    public void setDataBlockManager(DataBlockManager dataBlockManager) {
        this.dataBlockManager = dataBlockManager;
    }

    public void setConverter(BytesToValueConverter<EdgeDataType> bytesToValueConverter) {
        this.converter = bytesToValueConverter;
    }

    public int getStreamingOffset() {
        return this.streamingOffset;
    }

    public int getStreamingOffsetEdgePtr() {
        return this.streamingOffsetEdgePtr;
    }

    public int getStreamingOffsetVid() {
        return this.streamingOffsetVid;
    }

    public void setOnlyAdjacency(boolean bl) {
        this.onlyAdjacency = bl;
    }
}

