/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.graphchi.shards;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class ShardIndex {
    File indexFile;
    private int[] vertices;
    private int[] edgePointer;
    private int[] fileOffset;

    public ShardIndex(File file) throws IOException {
        this.indexFile = new File(file.getAbsolutePath() + ".index");
        this.load();
    }

    private void load() throws IOException {
        int n = (int)(this.indexFile.length() / 12L) + 1;
        this.vertices = new int[n];
        this.edgePointer = new int[n];
        this.fileOffset = new int[n];
        this.vertices[0] = 0;
        this.edgePointer[0] = 0;
        this.fileOffset[0] = 0;
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(this.indexFile)));
        for (int i = 1; i < n; ++i) {
            this.vertices[i] = dataInputStream.readInt();
            this.fileOffset[i] = dataInputStream.readInt();
            this.edgePointer[i] = dataInputStream.readInt();
        }
    }

    public ArrayList<IndexEntry> sparserIndex(int n) {
        ArrayList<IndexEntry> arrayList = new ArrayList<IndexEntry>();
        arrayList.add(new IndexEntry(0, 0, 0));
        int n2 = 0;
        for (int i = 0; i < this.vertices.length; ++i) {
            if (this.edgePointer[i] - n2 < n) continue;
            arrayList.add(new IndexEntry(this.vertices[i], this.edgePointer[i], this.fileOffset[i]));
            n2 = this.edgePointer[i];
        }
        return arrayList;
    }

    public IndexEntry lookup(int n) {
        int n2 = Arrays.binarySearch(this.vertices, n);
        if (n2 >= 0) {
            return new IndexEntry(n, this.edgePointer[n2], this.fileOffset[n2]);
        }
        n2 = -(n2 + 1) - 1;
        return new IndexEntry(this.vertices[n2], this.edgePointer[n2], this.fileOffset[n2]);
    }

    public static class IndexEntry {
        public int vertex;
        public int edgePointer;
        public int fileOffset;

        IndexEntry(int n, int n2, int n3) {
            this.vertex = n;
            this.edgePointer = n2;
            this.fileOffset = n3;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            IndexEntry indexEntry = (IndexEntry)object;
            if (this.edgePointer != indexEntry.edgePointer) {
                return false;
            }
            if (this.fileOffset != indexEntry.fileOffset) {
                return false;
            }
            return this.vertex == indexEntry.vertex;
        }

        public int hashCode() {
            int n = this.vertex;
            n = 31 * n + this.edgePointer;
            n = 31 * n + this.fileOffset;
            return n;
        }

        public String toString() {
            return "vertex: " + this.vertex + ", offset=" + this.fileOffset;
        }
    }
}

