/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.graphchi.toolkits.collaborative_filtering;

import edu.cmu.graphchi.ChiFilenames;
import edu.cmu.graphchi.ChiVertex;
import edu.cmu.graphchi.GraphChiContext;
import edu.cmu.graphchi.GraphChiProgram;
import edu.cmu.graphchi.datablocks.FloatConverter;
import edu.cmu.graphchi.engine.GraphChiEngine;
import edu.cmu.graphchi.engine.VertexInterval;
import edu.cmu.graphchi.preprocessing.FastSharder;
import edu.cmu.graphchi.toolkits.collaborative_filtering.ALS;
import edu.cmu.graphchi.toolkits.collaborative_filtering.IO;
import edu.cmu.graphchi.toolkits.collaborative_filtering.ProblemSetup;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.math.linear.RealVector;

public class RMSEEngine
extends ProblemSetup
implements GraphChiProgram<Integer, Float> {
    double validation_rmse = 0.0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(ChiVertex<Integer, Float> chiVertex, GraphChiContext graphChiContext) {
        if (chiVertex.numOutEdges() == 0) {
            return;
        }
        RealVector realVector = ProblemSetup.latent_factors_inmem.getRowAsVector(chiVertex.getId());
        try {
            double d = 0.0;
            for (int i = 0; i < chiVertex.numEdges(); ++i) {
                float f = chiVertex.edge(i).getValue().floatValue();
                RealVector realVector2 = ProblemSetup.latent_factors_inmem.getRowAsVector(chiVertex.edge(i).getVertexId());
                double d2 = ALS.als_predict(realVector2, realVector);
                d += Math.pow(d2 - (double)f, 2.0);
            }
            RMSEEngine rMSEEngine = this;
            synchronized (rMSEEngine) {
                this.validation_rmse += d;
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void beginIteration(GraphChiContext graphChiContext) {
        this.validation_rmse = 0.0;
    }

    @Override
    public void endIteration(GraphChiContext graphChiContext) {
        double d = Math.sqrt(this.validation_rmse / 545000.0);
        logger.info("Training RMSE: " + String.format("%.5f", ProblemSetup.train_rmse) + " Validation RMSE: " + String.format("%.5f", d));
    }

    @Override
    public void beginInterval(GraphChiContext graphChiContext, VertexInterval vertexInterval) {
    }

    @Override
    public void endInterval(GraphChiContext graphChiContext, VertexInterval vertexInterval) {
    }

    @Override
    public void beginSubInterval(GraphChiContext graphChiContext, VertexInterval vertexInterval) {
    }

    @Override
    public void endSubInterval(GraphChiContext graphChiContext, VertexInterval vertexInterval) {
    }

    public void calc_validation_rmse(String string, int n) {
        try {
            GraphChiEngine graphChiEngine = new GraphChiEngine(string + "e", n);
            graphChiEngine.setEdataConverter(new FloatConverter());
            graphChiEngine.setEnableDeterministicExecution(false);
            graphChiEngine.setVertexDataConverter(null);
            graphChiEngine.setModifiesInedges(false);
            graphChiEngine.setModifiesOutedges(false);
            graphChiEngine.run(this, 1);
        }
        catch (Exception exception) {
            logger.info("Failed to compute validation rmse");
        }
    }

    void init_validation() {
        try {
            this.sharder_validation = IO.createSharder(training + "e", 1);
            if (!new File(ChiFilenames.getFilenameIntervals(training + "e", nShards)).exists() || !new File(training + "e.matrixinfo").exists()) {
                this.sharder_validation.shard((InputStream)new FileInputStream(new File(training + "e")), FastSharder.GraphInputFormat.MATRIXMARKET);
            } else {
                logger.info("Found validation shards -- no need to preprocess");
            }
        }
        catch (IOException iOException) {
            logger.warning("Failed to initalize validation input. Aborting.");
        }
    }
}

