/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.graphchi.util;

import java.util.Random;

public class HugeFloatMatrix
implements Cloneable {
    private int BLOCKSIZE = 0x1000000;
    private long nrows;
    private long ncols;
    private float[][] data;

    public HugeFloatMatrix(long l, long l2, float f) {
        this.nrows = l;
        this.ncols = l2;
        while ((long)this.BLOCKSIZE % l2 != 0L) {
            ++this.BLOCKSIZE;
        }
        long l3 = l * l2;
        int n = (int)(l3 / (long)this.BLOCKSIZE + (long)(l3 % (long)this.BLOCKSIZE == 0L ? 0 : 1));
        this.data = new float[n][];
        System.out.println("Creating " + n + " blocks");
        for (int i = 0; i < n; ++i) {
            this.data[i] = new float[this.BLOCKSIZE];
            if (f == 0.0f) continue;
            float[] fArray = this.data[i];
            for (int j = 0; j < this.BLOCKSIZE; ++j) {
                fArray[j] = f;
            }
        }
    }

    public HugeFloatMatrix(long l, long l2) {
        this(l, l2, 0.0f);
    }

    public long size() {
        return this.nrows * this.ncols;
    }

    public long getNumRows() {
        return this.nrows;
    }

    public float getValue(int n, int n2) {
        long l = (long)n * this.ncols + (long)n2;
        int n3 = (int)(l / (long)this.BLOCKSIZE);
        int n4 = (int)(l % (long)this.BLOCKSIZE);
        return this.data[n3][n4];
    }

    public void setValue(int n, int n2, float f) {
        long l = (long)n * this.ncols + (long)n2;
        int n3 = (int)(l / (long)this.BLOCKSIZE);
        int n4 = (int)(l % (long)this.BLOCKSIZE);
        this.data[n3][n4] = f;
    }

    public void add(int n, int n2, float f) {
        long l = (long)n * this.ncols + (long)n2;
        int n3 = (int)(l / (long)this.BLOCKSIZE);
        int n4 = (int)(l % (long)this.BLOCKSIZE);
        float[] fArray = this.data[n3];
        int n5 = n4;
        fArray[n5] = fArray[n5] + f;
    }

    public float[] getRowBlock(int n) {
        long l = (long)n * this.ncols;
        int n2 = (int)(l / (long)this.BLOCKSIZE);
        return this.data[n2];
    }

    public int getBlockIdx(int n) {
        long l = (long)n * this.ncols;
        int n2 = (int)(l % (long)this.BLOCKSIZE);
        return n2;
    }

    public float[] getEmptyRow() {
        float[] fArray = new float[(int)this.ncols];
        return fArray;
    }

    public void multiplyRow(int n, float f) {
        int n2 = 0;
        while ((long)n2 < this.ncols) {
            this.setValue(n, n2, this.getValue(n, n2) * f);
            ++n2;
        }
    }

    public void getRow(int n, float[] fArray) {
        long l = (long)n * this.ncols;
        int n2 = (int)(l / (long)this.BLOCKSIZE);
        int n3 = (int)(l % (long)this.BLOCKSIZE);
        System.arraycopy(this.data[n2], n3, fArray, 0, (int)this.ncols);
    }

    public void normalizeSquared(int n) {
        double d = 0.0;
        int n2 = 0;
        while ((long)n2 < this.nrows) {
            double d2 = this.getValue(n2, n);
            d += d2 * d2;
            ++n2;
        }
        System.out.println("Normalize-squared: " + n + " sqr: " + d);
        float f = (float)Math.sqrt(d);
        System.out.println("Div : " + f);
        if (Float.isInfinite(f) || Float.isNaN(f)) {
            throw new RuntimeException("Illegal normalizer: " + f);
        }
        if (d == 0.0) {
            throw new IllegalArgumentException("Column was all-zeros!");
        }
        int n3 = 0;
        while ((long)n3 < this.nrows) {
            float f2 = this.getValue(n3, n);
            this.setValue(n3, n, f2 / f);
            ++n3;
        }
    }

    public void setColumn(int n, float f) {
        int n2 = 0;
        while ((long)n2 < this.nrows) {
            this.setValue(n2, n, f);
            ++n2;
        }
    }

    public void zeroLessThan(float f) {
        for (int i = 0; i < this.data.length; ++i) {
            float[] fArray = this.data[i];
            for (int j = 0; j < fArray.length; ++j) {
                if (fArray[j] == 0.0f || !(fArray[j] < f)) continue;
                fArray[j] = 0.0f;
            }
        }
    }

    public void binaryFilter(float f, float f2) {
        for (int i = 0; i < this.data.length; ++i) {
            float[] fArray = this.data[i];
            for (int j = 0; j < fArray.length; ++j) {
                fArray[j] = (fArray[j] >= f ? 1.0f : 0.0f) * f2;
            }
        }
    }

    public void randomize(float f, float f2) {
        Random random = new Random();
        for (int i = 0; i < this.data.length; ++i) {
            float[] fArray = this.data[i];
            for (int j = 0; j < fArray.length; ++j) {
                fArray[j] = f + (f2 - f) * random.nextFloat();
            }
        }
    }
}

