/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.graphchi.util;

public class HugeLongMatrix {
    private int BLOCKSIZE = 0x1000000;
    private long nrows;
    private long ncols;
    private long[][] data;

    public HugeLongMatrix(long l, long l2, long l3) {
        this.nrows = l;
        this.ncols = l2;
        while ((long)this.BLOCKSIZE % l2 != 0L) {
            ++this.BLOCKSIZE;
        }
        long l4 = l * l2;
        int n = (int)(l4 / (long)this.BLOCKSIZE + (long)(l4 % (long)this.BLOCKSIZE == 0L ? 0 : 1));
        this.data = new long[n][];
        System.out.println("Creating " + n + " blocks");
        for (int i = 0; i < n; ++i) {
            this.data[i] = new long[this.BLOCKSIZE];
            if ((float)l3 == 0.0f) continue;
            long[] lArray = this.data[i];
            for (int j = 0; j < this.BLOCKSIZE; ++j) {
                lArray[j] = l3;
            }
        }
    }

    public HugeLongMatrix(long l, long l2) {
        this(l, l2, 0L);
    }

    public long size() {
        return this.nrows * this.ncols;
    }

    public long getNumRows() {
        return this.nrows;
    }

    public long getValue(int n, int n2) {
        long l = (long)n * this.ncols + (long)n2;
        int n3 = (int)(l / (long)this.BLOCKSIZE);
        int n4 = (int)(l % (long)this.BLOCKSIZE);
        return this.data[n3][n4];
    }

    public void setValue(int n, int n2, long l) {
        long l2 = (long)n * this.ncols + (long)n2;
        int n3 = (int)(l2 / (long)this.BLOCKSIZE);
        int n4 = (int)(l2 % (long)this.BLOCKSIZE);
        this.data[n3][n4] = l;
    }

    public long[] getRowBlock(int n) {
        long l = (long)n * this.ncols;
        int n2 = (int)(l / (long)this.BLOCKSIZE);
        return this.data[n2];
    }

    public int getBlockIdx(int n) {
        long l = (long)n * this.ncols;
        int n2 = (int)(l % (long)this.BLOCKSIZE);
        return n2;
    }

    public long[] getEmptyRow() {
        long[] lArray = new long[(int)this.ncols];
        return lArray;
    }

    public void getRow(int n, long[] lArray) {
        long l = (long)n * this.ncols;
        int n2 = (int)(l / (long)this.BLOCKSIZE);
        int n3 = (int)(l % (long)this.BLOCKSIZE);
        System.arraycopy(this.data[n2], n3, lArray, 0, (int)this.ncols);
    }
}

