/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.graphchi.util;

import edu.cmu.graphchi.ChiFilenames;
import edu.cmu.graphchi.datablocks.FloatConverter;
import edu.cmu.graphchi.datablocks.IntConverter;
import edu.cmu.graphchi.engine.VertexInterval;
import edu.cmu.graphchi.preprocessing.VertexIdTranslate;
import edu.cmu.graphchi.util.HugeFloatMatrix;
import edu.cmu.graphchi.util.IdFloat;
import edu.cmu.graphchi.util.IdInt;
import edu.cmu.graphchi.vertexdata.ForeachCallback;
import edu.cmu.graphchi.vertexdata.VertexAggregator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.TreeSet;

public class Toplist {
    public static TreeSet<IdFloat> topListFloat(String string, int n, final int n2) throws IOException {
        final TreeSet<IdFloat> treeSet = new TreeSet<IdFloat>(new IdFloat.Comparator());
        VertexAggregator.foreach(n, string, new FloatConverter(), new ForeachCallback<Float>(){
            IdFloat least;

            @Override
            public void callback(int n, Float f) {
                if (treeSet.size() < n2) {
                    treeSet.add(new IdFloat(n, f.floatValue()));
                    this.least = (IdFloat)treeSet.last();
                } else if (f.floatValue() > this.least.value) {
                    treeSet.remove(this.least);
                    treeSet.add(new IdFloat(n, f.floatValue()));
                    this.least = (IdFloat)treeSet.last();
                }
            }
        });
        return treeSet;
    }

    public static TreeSet<IdInt> topListInt(String string, int n, final int n2) throws IOException {
        final TreeSet<IdInt> treeSet = new TreeSet<IdInt>(new Comparator<IdInt>(){

            @Override
            public int compare(IdInt idInt, IdInt idInt2) {
                if (idInt.vertexId == idInt2.vertexId) {
                    return 0;
                }
                return idInt.value > idInt2.value ? -1 : (idInt.value == idInt2.value ? (idInt.vertexId < idInt2.vertexId ? -1 : 1) : 1);
            }
        });
        VertexAggregator.foreach(n, string, new IntConverter(), new ForeachCallback<Integer>(){
            IdInt least;

            @Override
            public void callback(int n, Integer n22) {
                if (treeSet.size() < n2) {
                    treeSet.add(new IdInt(n, n22));
                    this.least = (IdInt)treeSet.last();
                } else if (n22 > this.least.value) {
                    treeSet.remove(this.least);
                    treeSet.add(new IdInt(n, n22));
                    this.least = (IdInt)treeSet.last();
                }
            }
        });
        return treeSet;
    }

    public static TreeSet<IdFloat> topList(HugeFloatMatrix hugeFloatMatrix, int n, int n2) {
        TreeSet<IdFloat> treeSet = new TreeSet<IdFloat>(new Comparator<IdFloat>(){

            @Override
            public int compare(IdFloat idFloat, IdFloat idFloat2) {
                if (idFloat.vertexId == idFloat2.vertexId) {
                    return 0;
                }
                int n = -Float.compare(idFloat.value, idFloat2.value);
                return n != 0 ? n : (idFloat.vertexId < idFloat2.vertexId ? 1 : -1);
            }
        });
        IdFloat idFloat = null;
        int n3 = (int)hugeFloatMatrix.getNumRows();
        for (int i = 0; i < n3; ++i) {
            float f = hugeFloatMatrix.getValue(i, n);
            if (treeSet.size() < n2) {
                treeSet.add(new IdFloat(i, f));
                idFloat = treeSet.last();
                continue;
            }
            if (!(f > idFloat.value)) continue;
            treeSet.remove(idFloat);
            treeSet.add(new IdFloat(i, f));
            idFloat = treeSet.last();
        }
        return treeSet;
    }

    public static void main(String[] stringArray) throws Exception {
        String string = stringArray[0];
        int n = Integer.parseInt(stringArray[1]);
        ArrayList<VertexInterval> arrayList = ChiFilenames.loadIntervals(string, n);
        TreeSet<IdFloat> treeSet = Toplist.topListFloat(string, arrayList.get(arrayList.size() - 1).getLastVertex(), 20);
        VertexIdTranslate vertexIdTranslate = VertexIdTranslate.fromFile(new File(ChiFilenames.getVertexTranslateDefFile(string, n)));
        System.out.println("Result: " + treeSet);
        int n2 = 0;
        for (IdFloat idFloat : treeSet) {
            System.out.println(++n2 + ": " + vertexIdTranslate.backward(idFloat.getVertexId()) + " = " + idFloat.getValue());
        }
    }
}

