/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.graphchi.vertexdata;

import edu.cmu.graphchi.datablocks.BytesToValueConverter;
import edu.cmu.graphchi.datablocks.ChiPointer;
import edu.cmu.graphchi.datablocks.DataBlockManager;
import edu.cmu.graphchi.datablocks.IntConverter;
import edu.cmu.graphchi.engine.auxdata.VertexData;
import edu.cmu.graphchi.preprocessing.VertexIdTranslate;
import edu.cmu.graphchi.vertexdata.ForeachCallback;
import edu.cmu.graphchi.vertexdata.VertexIdValue;
import java.io.IOException;
import java.util.Iterator;

public class VertexAggregator {
    public static <VertexDataType> void foreach(int n, String string, BytesToValueConverter<VertexDataType> bytesToValueConverter, ForeachCallback<VertexDataType> foreachCallback) throws IOException {
        VertexData<VertexDataType> vertexData = new VertexData<VertexDataType>(n, string, bytesToValueConverter, true);
        DataBlockManager dataBlockManager = new DataBlockManager();
        vertexData.setBlockManager(dataBlockManager);
        int n2 = 1000000;
        for (int i = 0; i < n; i += n2) {
            int n3 = i + n2;
            if (n3 >= n) {
                n3 = n - 1;
            }
            int n4 = vertexData.load(i, n3);
            Iterator<Integer> iterator = vertexData.currentIterator();
            while (iterator.hasNext()) {
                int n5 = iterator.next();
                ChiPointer chiPointer = vertexData.getVertexValuePtr(n5, n4);
                VertexDataType VertexDataType = dataBlockManager.dereference(chiPointer, bytesToValueConverter);
                foreachCallback.callback(n5, VertexDataType);
            }
        }
    }

    public static <VertexDataType> Iterator<VertexIdValue<VertexDataType>> vertexIterator(final int n, String string, final BytesToValueConverter<VertexDataType> bytesToValueConverter, final VertexIdTranslate vertexIdTranslate) throws IOException {
        final VertexData<VertexDataType> vertexData = new VertexData<VertexDataType>(n, string, bytesToValueConverter, true);
        final DataBlockManager dataBlockManager = new DataBlockManager();
        vertexData.setBlockManager(dataBlockManager);
        return new Iterator<VertexIdValue<VertexDataType>>(){
            int i = 0;
            int blockId;
            Iterator<Integer> curIter;

            @Override
            public boolean hasNext() {
                if (this.i >= n - 1) {
                    return false;
                }
                if (this.curIter == null || !this.curIter.hasNext()) {
                    int n2 = this.i + 1000000;
                    if (n2 >= n) {
                        n2 = n - 1;
                    }
                    try {
                        this.blockId = vertexData.load(this.i, n2);
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException);
                    }
                    this.curIter = vertexData.currentIterator();
                }
                return true;
            }

            @Override
            public VertexIdValue next() {
                if (this.hasNext()) {
                    this.i = this.curIter.next();
                    ChiPointer chiPointer = vertexData.getVertexValuePtr(this.i, this.blockId);
                    return new VertexIdValue(vertexIdTranslate.backward(this.i), dataBlockManager.dereference(chiPointer, bytesToValueConverter));
                }
                throw new IllegalStateException("No more elements in the iterator!");
            }

            @Override
            public void remove() {
                throw new RuntimeException("Remove() not implemented");
            }
        };
    }

    public static long sumInt(int n, String string) throws IOException {
        SumCallbackInt sumCallbackInt = new SumCallbackInt();
        VertexAggregator.foreach(n, string, new IntConverter(), sumCallbackInt);
        return sumCallbackInt.getSum();
    }

    private static class SumCallbackInt
    implements ForeachCallback<Integer> {
        long sum = 0L;

        private SumCallbackInt() {
        }

        @Override
        public void callback(int n, Integer n2) {
            this.sum += (long)n2.intValue();
        }

        public long getSum() {
            return this.sum;
        }
    }
}

