/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.graphchi.walks;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Timer;
import com.yammer.metrics.core.TimerContext;
import edu.cmu.graphchi.ChiLogger;
import edu.cmu.graphchi.ChiVertex;
import edu.cmu.graphchi.GraphChiContext;
import edu.cmu.graphchi.engine.VertexInterval;
import edu.cmu.graphchi.walks.BucketsToSend;
import edu.cmu.graphchi.walks.DrunkardContext;
import edu.cmu.graphchi.walks.DrunkardJob;
import edu.cmu.graphchi.walks.DrunkardMobEngine;
import edu.cmu.graphchi.walks.DumperThread;
import edu.cmu.graphchi.walks.GrabbedBucketConsumer;
import edu.cmu.graphchi.walks.LocalWalkBuffer;
import edu.cmu.graphchi.walks.WalkArray;
import edu.cmu.graphchi.walks.WalkSnapshot;
import edu.cmu.graphchi.walks.WalkUpdateFunction;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;

public abstract class DrunkardDriver<VertexDataType, EdgeDataType>
implements GrabbedBucketConsumer {
    private WalkSnapshot curWalkSnapshot;
    protected final DrunkardJob job;
    protected static Logger logger = ChiLogger.getLogger("drunkard-driver");
    protected LinkedBlockingQueue<BucketsToSend> bucketQueue = new LinkedBlockingQueue();
    protected AtomicBoolean finished = new AtomicBoolean(false);
    protected AtomicLong pendingWalksToSubmit = new AtomicLong(0L);
    private Thread dumperThread;
    WalkUpdateFunction<VertexDataType, EdgeDataType> callback;
    private final Timer purgeTimer = Metrics.defaultRegistry().newTimer(DrunkardMobEngine.class, "purge-localwalks", TimeUnit.SECONDS, TimeUnit.MINUTES);
    private ArrayList<LocalWalkBuffer> localBuffers = new ArrayList();

    DrunkardDriver(DrunkardJob drunkardJob, WalkUpdateFunction<VertexDataType, EdgeDataType> walkUpdateFunction) {
        this.job = drunkardJob;
        this.callback = walkUpdateFunction;
        this.dumperThread = new Thread(this.createDumperThread());
        this.dumperThread.start();
    }

    protected abstract DumperThread createDumperThread();

    public DrunkardJob getJob() {
        return this.job;
    }

    protected abstract DrunkardContext createDrunkardContext(int var1, GraphChiContext var2, LocalWalkBuffer var3);

    public void update(ChiVertex<VertexDataType, EdgeDataType> chiVertex, GraphChiContext graphChiContext, LocalWalkBuffer localWalkBuffer) {
        try {
            while (this.pendingWalksToSubmit.get() > this.job.getWalkManager().getTotalWalks() / 40L) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            boolean bl = graphChiContext.getIteration() == 0;
            WalkArray walkArray = this.curWalkSnapshot.getWalksAtVertex(chiVertex.getId(), true);
            this.curWalkSnapshot.clear(chiVertex.getId());
            if (bl && this.job.getWalkManager().isSource(chiVertex.getId())) {
                int n = this.job.getWalkManager().getVertexSourceIdx(chiVertex.getId());
                this.job.getCompanion().setAvoidList(n, this.callback.getNotTrackedVertices(chiVertex));
            }
            if (walkArray == null || walkArray.size() == 0) {
                return;
            }
            Random random = localWalkBuffer.random;
            DrunkardContext drunkardContext = this.createDrunkardContext(chiVertex.getId(), graphChiContext, localWalkBuffer);
            this.callback.processWalksAtVertex(walkArray, chiVertex, drunkardContext, random);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public void initWalks() throws RemoteException {
        this.job.getWalkManager().initializeWalks();
        this.job.getCompanion().setSources(this.job.getWalkManager().getSources());
    }

    public void beginIteration(GraphChiContext graphChiContext) {
        if (graphChiContext.getIteration() == 0) {
            graphChiContext.getScheduler().removeAllTasks();
            this.job.getWalkManager().populateSchedulerWithSources(graphChiContext.getScheduler());
        }
    }

    public void endIteration(GraphChiContext graphChiContext) {
    }

    public void spinUntilFinish() {
        this.finished.set(true);
        while (this.bucketQueue.size() > 0) {
            try {
                System.out.println("Waiting ..." + this.bucketQueue.size());
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        try {
            this.dumperThread.join();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    synchronized void addLocalBuffer(LocalWalkBuffer localWalkBuffer) {
        this.localBuffers.add(localWalkBuffer);
    }

    public void beginSubInterval(GraphChiContext graphChiContext, VertexInterval vertexInterval) {
        long l = System.currentTimeMillis();
        this.curWalkSnapshot = this.job.getWalkManager().grabSnapshot(vertexInterval.getFirstVertex(), vertexInterval.getLastVertex());
        logger.info("Grab snapshot took " + (System.currentTimeMillis() - l) + " ms.");
        while (this.localBuffers.size() > 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            logger.fine("Waiting for purge to finish...");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endSubInterval(GraphChiContext graphChiContext, VertexInterval vertexInterval) {
        this.curWalkSnapshot.restoreUngrabbed();
        this.curWalkSnapshot = null;
        ArrayList<LocalWalkBuffer> arrayList = this.localBuffers;
        synchronized (arrayList) {
            TimerContext timerContext = this.purgeTimer.time();
            for (LocalWalkBuffer localWalkBuffer : this.localBuffers) {
                localWalkBuffer.purge(this.job.getWalkManager());
            }
            this.localBuffers.clear();
            timerContext.stop();
        }
    }

    public void beginInterval(GraphChiContext graphChiContext, VertexInterval vertexInterval) {
        long l = this.job.getWalkManager().getTotalWalks();
        long l2 = this.job.getWalkManager().getNumOfActiveWalks();
        System.out.println("=====================================");
        System.out.println("Active walks: " + l2 + ", initialized=" + l);
        System.out.println("=====================================");
        this.job.getWalkManager().populateSchedulerForInterval(graphChiContext.getScheduler(), vertexInterval);
        this.job.getWalkManager().setBucketConsumer(this);
    }

    public void endInterval(GraphChiContext graphChiContext, VertexInterval vertexInterval) {
    }

    @Override
    public void consume(int n, WalkArray walkArray, int n2) {
        try {
            this.pendingWalksToSubmit.addAndGet(n2);
            this.bucketQueue.put(new BucketsToSend(n, walkArray, n2));
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }
}

