/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.graphchi.walks;

import com.yammer.metrics.core.TimerContext;
import edu.cmu.graphchi.ChiLogger;
import edu.cmu.graphchi.Scheduler;
import edu.cmu.graphchi.engine.VertexInterval;
import edu.cmu.graphchi.walks.IntWalkArray;
import edu.cmu.graphchi.walks.WalkArray;
import edu.cmu.graphchi.walks.WalkManager;
import edu.cmu.graphchi.walks.WalkSnapshot;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.BitSet;
import java.util.logging.Logger;

public class IntWalkManager
extends WalkManager {
    protected int[][] walks;
    private static final Logger logger = ChiLogger.getLogger("int-walk-manager");

    public IntWalkManager(int n, int n2) {
        super(n, n2);
    }

    @Override
    protected void setSourceAndBucketBits() {
        this.MAX_SOURCES = 0x1000000;
        this.bucketSize = 128;
    }

    int encode(int n, boolean bl, int n2) {
        assert (n2 < 128);
        int n3 = bl ? 1 : 0;
        return (n & 0xFFFFFF) << 8 | (n2 & 0x7F) << 1 | n3;
    }

    int encodeV(int n, boolean bl, int n2) {
        return this.encode(n, bl, n2 % this.bucketSize);
    }

    int encodeNewWalk(int n, int n2, boolean bl) {
        return this.encode(n, bl, n2 % this.bucketSize);
    }

    public int sourceIdx(int n) {
        return (n & 0xFFFFFF00) >> 8 & 0xFFFFFF;
    }

    public boolean trackBit(int n) {
        return (n & 1) != 0;
    }

    public int off(int n) {
        return n >> 1 & 0x7F;
    }

    public int reencodeWalk(int n, int n2, boolean bl) {
        int n3 = n2 / this.bucketSize;
        return this.encode(this.sourceIdx(n), bl, n2 % this.bucketSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveWalk(int n, int n2, boolean bl) {
        int n3 = n2 / this.bucketSize;
        Object object = this.bucketLocks[n3];
        synchronized (object) {
            this.moveWalkUnsafe(n, n2, bl);
        }
    }

    public void moveWalkUnsafe(int n, int n2, boolean bl) {
        n = this.reencodeWalk(n, n2, bl);
        int n3 = n2 / this.bucketSize;
        int n4 = this.walkIndices[n3];
        if (n4 == 0) {
            this.walks[n3] = new int[initialSize];
        } else if (n4 == this.walks[n3].length) {
            int[] nArray = new int[this.walks[n3].length * 3 / 2];
            System.arraycopy(this.walks[n3], 0, nArray, 0, this.walks[n3].length);
            this.walks[n3] = nArray;
        }
        this.walks[n3][n4] = n;
        int n5 = n3;
        this.walkIndices[n5] = this.walkIndices[n5] + 1;
    }

    @Override
    protected void expandCapacity(int n, int n2) {
        if (this.walks[n] != null) {
            int n3 = this.walks[n].length + n2;
            if (this.walks[n].length < n3) {
                int[] nArray = new int[n3];
                System.arraycopy(this.walks[n], 0, nArray, 0, this.walks[n].length);
                this.walks[n] = nArray;
            }
        } else {
            this.walks[n] = new int[n2];
        }
    }

    @Override
    public void initializeWalks() {
        int n;
        int n2;
        int n3;
        this.walks = new int[1 + this.numVertices / this.bucketSize][];
        this.bucketLocks = new Object[this.walks.length];
        for (n3 = 0; n3 < this.bucketLocks.length; ++n3) {
            this.bucketLocks[n3] = new Object();
        }
        this.walkIndices = new int[this.walks.length];
        for (n3 = 0; n3 < this.walks.length; ++n3) {
            this.walks[n3] = null;
            this.walkIndices[n3] = 0;
        }
        if (this.sourceSeqIdx < this.sources.length) {
            logger.info("Truncating...");
            int[] nArray = new int[this.sourceSeqIdx];
            System.arraycopy(this.sources, 0, nArray, 0, this.sourceSeqIdx);
            this.sources = nArray;
        }
        logger.info("Calculate sizes. Walks length:" + this.walks.length);
        int[] nArray = new int[this.walks.length];
        for (n2 = 0; n2 < this.sourceSeqIdx; ++n2) {
            n = this.sources[n2];
            int n4 = n / this.bucketSize;
            nArray[n4] = nArray[n4] + this.sourceWalkCounts[n2];
        }
        logger.info("Expand capacities");
        for (n2 = 0; n2 < this.walks.length; ++n2) {
            this.expandCapacity(n2, nArray[n2]);
        }
        logger.info("Allocating walks");
        for (n2 = 0; n2 < this.sourceSeqIdx; ++n2) {
            n = this.sources[n2];
            int n5 = this.sourceWalkCounts[n2];
            int n6 = this.encodeNewWalk(n2, n, false);
            int n7 = n / this.bucketSize;
            int n8 = this.walkIndices[n7];
            for (int i = 0; i < n5; ++i) {
                this.walks[n7][n8++] = n6;
            }
            int n9 = n7;
            this.walkIndices[n9] = this.walkIndices[n9] + n5;
            if (n2 % 100000 != 0) continue;
            logger.info(n2 + " / " + this.sourceSeqIdx);
        }
        this.sourceWalkCounts = null;
        logger.info("Set bitset...");
        for (n2 = 0; n2 < this.sourceSeqIdx; ++n2) {
            this.sourceBitSet.set(this.sources[n2], true);
        }
    }

    @Override
    public WalkSnapshot grabSnapshot(final int n, final int n2) {
        final int n3 = n / this.bucketSize;
        final int n4 = n2 / this.bucketSize;
        final boolean[] blArray = new boolean[n4 - n3 + 1];
        final boolean[] blArray2 = new boolean[1 + n2 - n];
        for (int i = n3; i <= n4; ++i) {
            blArray[i - n3] = false;
        }
        final int[][] nArrayArray = new int[n2 - n + 1][];
        return new WalkSnapshot(){

            @Override
            public void clear(int n5) {
                nArrayArray[n5 - n] = null;
            }

            @Override
            public void restoreUngrabbed() {
                TimerContext timerContext = IntWalkManager.this.restore.time();
                int n5 = n;
                int n22 = 0;
                for (int[] nArray : nArrayArray) {
                    if (nArray != null && !blArray2[n5 - n]) {
                        for (int i = 0; i < nArray.length; ++i) {
                            int n32 = nArray[i];
                            IntWalkManager.this.moveWalk(n32, n5, IntWalkManager.this.trackBit(n32));
                            ++n22;
                        }
                    }
                    ++n5;
                }
                logger.info("Restored " + n22);
                timerContext.stop();
            }

            @Override
            public long numWalks() {
                long l = 0L;
                for (int i = n3; i <= n4; ++i) {
                    l += (long)IntWalkManager.this.walks[i].length;
                }
                return l;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public WalkArray getWalksAtVertex(int n14, boolean bl) {
                int n22 = n14 / IntWalkManager.this.bucketSize;
                int n32 = n22 - n / IntWalkManager.this.bucketSize;
                blArray2[n14 - n] = true;
                if (blArray[n32]) {
                    int[] nArray = nArrayArray[n14 - n];
                    if (nArray == null) {
                        return null;
                    }
                    return new IntWalkArray(nArrayArray[n14 - n]);
                }
                TimerContext timerContext = IntWalkManager.this.grabTimer.time();
                int[] nArray = null;
                int n42 = 0;
                Object object = IntWalkManager.this.bucketLocks[n22];
                synchronized (object) {
                    if (!blArray[n32]) {
                        int n5 = IntWalkManager.this.bucketSize * n22;
                        n42 = IntWalkManager.this.walkIndices[n22];
                        nArray = IntWalkManager.this.walks[n22];
                        if (nArray != null) {
                            int n6;
                            int n7;
                            IntWalkManager.this.walks[n22] = null;
                            IntWalkManager.this.walkIndices[n22] = 0;
                            int[] nArray2 = new int[IntWalkManager.this.bucketSize];
                            int[] nArray3 = new int[IntWalkManager.this.bucketSize];
                            for (n7 = 0; n7 < n42; ++n7) {
                                n6 = nArray[n7];
                                int n8 = IntWalkManager.this.off(n6);
                                nArray2[n8] = nArray2[n8] + 1;
                            }
                            n7 = n5 - n;
                            for (n6 = 0; n6 < nArray2.length; ++n6) {
                                if (nArray2[n6] <= 0 || n6 < -n7 || n6 + n7 >= nArrayArray.length) continue;
                                nArrayArray[n6 + n7] = new int[nArray2[n6]];
                            }
                            for (n6 = 0; n6 < n42; ++n6) {
                                int n9 = nArray[n6];
                                int n10 = n5 + IntWalkManager.this.off(n9);
                                if (n10 >= n && n10 <= n2) {
                                    int n11 = n10 - n;
                                    int n12 = n10 - n5;
                                    nArrayArray[n11][nArray3[n12]] = n9;
                                    int n13 = n12;
                                    nArray3[n13] = nArray3[n13] + 1;
                                    continue;
                                }
                                IntWalkManager.this.moveWalk(n9, n10, IntWalkManager.this.trackBit(n9));
                            }
                        }
                        blArray[n32] = true;
                    }
                }
                if (IntWalkManager.this.bucketConsumer != null && nArray != null && n42 > 0) {
                    IntWalkManager.this.bucketConsumer.consume(n22 * IntWalkManager.this.bucketSize, new IntWalkArray(nArray), n42);
                    if (n42 > 1000000) {
                        IntWalkManager.this.log(n22 * IntWalkManager.this.bucketSize + " - " + (n22 + 1) * IntWalkManager.this.bucketSize + ", " + n42);
                    }
                }
                timerContext.stop();
                object = nArrayArray[n14 - n];
                if (object == null) {
                    return null;
                }
                return new IntWalkArray(nArrayArray[n14 - n]);
            }

            @Override
            public int getFirstVertex() {
                return n;
            }

            @Override
            public int getLastVertex() {
                return n2;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dumpToFile(WalkSnapshot walkSnapshot, String string) throws IOException {
        TimerContext timerContext = this.dumpTimer.time();
        String string2 = string.intern();
        synchronized (string2) {
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(new File(string), true)));
            for (int i = walkSnapshot.getFirstVertex(); i <= walkSnapshot.getLastVertex(); ++i) {
                int[] nArray = ((IntWalkArray)walkSnapshot.getWalksAtVertex(i, false)).getArray();
                if (nArray == null) continue;
                for (int j = 0; j < nArray.length; ++j) {
                    int n = nArray[j];
                    int n2 = this.sources[this.sourceIdx(n)];
                    dataOutputStream.writeInt(n2);
                    dataOutputStream.writeInt(i);
                }
            }
            dataOutputStream.flush();
            dataOutputStream.close();
        }
        timerContext.stop();
    }

    public int getSourceVertex(int n) {
        return this.sources[this.sourceIdx(n)];
    }

    @Override
    public void populateSchedulerForInterval(Scheduler scheduler, VertexInterval vertexInterval) {
        TimerContext timerContext = this.schedulePopulate.time();
        int n = vertexInterval.getFirstVertex() / this.bucketSize;
        int n2 = vertexInterval.getLastVertex() / this.bucketSize;
        block0: for (int i = n; i <= n2; ++i) {
            int n3 = i * this.bucketSize;
            int[] nArray = this.walks[i];
            if (nArray == null) continue;
            BitSet bitSet = new BitSet(this.bucketSize);
            int n4 = 0;
            for (int j = 0; j < nArray.length; ++j) {
                int n5 = this.off(nArray[j]);
                if (bitSet.get(n5)) continue;
                bitSet.set(n5, true);
                scheduler.addTask(n3 + n5);
                if (++n4 == this.bucketSize) continue block0;
            }
        }
        timerContext.stop();
    }
}

