/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.graphchi.walks;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Timer;
import edu.cmu.graphchi.ChiLogger;
import edu.cmu.graphchi.Scheduler;
import edu.cmu.graphchi.engine.VertexInterval;
import edu.cmu.graphchi.walks.GrabbedBucketConsumer;
import edu.cmu.graphchi.walks.WalkArray;
import edu.cmu.graphchi.walks.WalkSnapshot;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public abstract class WalkManager {
    protected int MAX_SOURCES;
    protected int bucketSize;
    protected static final int initialSize = Integer.parseInt(System.getProperty("walkmanager.initial_size", "32"));
    protected int sourceSeqIdx = 0;
    protected int[] sources;
    protected int[] sourceWalkCounts = null;
    private long totalWalks = 0L;
    protected Object[] bucketLocks;
    protected int[] walkIndices;
    protected BitSet sourceBitSet;
    protected int numVertices;
    protected final Timer grabTimer = Metrics.defaultRegistry().newTimer(WalkManager.class, "grab-walks", TimeUnit.SECONDS, TimeUnit.MINUTES);
    protected final Timer dumpTimer = Metrics.defaultRegistry().newTimer(WalkManager.class, "dump-walks", TimeUnit.SECONDS, TimeUnit.MINUTES);
    protected final Timer schedulePopulate = Metrics.defaultRegistry().newTimer(WalkManager.class, "populate-scheduler", TimeUnit.SECONDS, TimeUnit.MINUTES);
    protected final Timer restore = Metrics.defaultRegistry().newTimer(WalkManager.class, "restore", TimeUnit.SECONDS, TimeUnit.MINUTES);
    private static final Logger logger = ChiLogger.getLogger("walk-manager");
    protected GrabbedBucketConsumer bucketConsumer;
    private BufferedWriter log;

    public WalkManager(int n, int n2) {
        this.setSourceAndBucketBits();
        this.numVertices = n;
        if (n2 > this.MAX_SOURCES) {
            throw new IllegalArgumentException("Max sources: " + n2);
        }
        this.sources = new int[n2];
        this.sourceWalkCounts = new int[n2];
        this.sourceBitSet = new BitSet(n);
        logger.info("Initial size for walk bucket: " + initialSize);
        try {
            this.log = new BufferedWriter(new FileWriter(new File("walkmanager.log")));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected abstract void setSourceAndBucketBits();

    protected void log(String string) {
        try {
            this.log.write(string + "\n");
            this.log.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public boolean isSource(int n) {
        return this.sourceBitSet.get(n);
    }

    public int getVertexSourceIdx(int n) {
        int n2 = Arrays.binarySearch(this.sources, n);
        if (n2 < 0) {
            throw new IllegalArgumentException("Vertex was not a source!");
        }
        return n2;
    }

    public int[] getSources() {
        return this.sources;
    }

    public void setBucketConsumer(GrabbedBucketConsumer grabbedBucketConsumer) {
        this.bucketConsumer = grabbedBucketConsumer;
    }

    public synchronized int addWalkBatch(int n, int n2) {
        if (this.sourceSeqIdx >= this.sources.length) {
            throw new IllegalStateException("You can have a maximum of " + this.sources.length + " random walk sources");
        }
        if (this.sourceSeqIdx > 0 && this.sources[this.sourceSeqIdx - 1] > n) {
            throw new IllegalArgumentException("You need to add sources in order!");
        }
        this.sources[this.sourceSeqIdx] = n;
        this.sourceWalkCounts[this.sourceSeqIdx] = n2;
        this.totalWalks += (long)n2;
        ++this.sourceSeqIdx;
        return this.sourceSeqIdx - 1;
    }

    protected abstract void expandCapacity(int var1, int var2);

    public abstract void initializeWalks();

    public long getTotalWalks() {
        return this.totalWalks;
    }

    public long getNumOfActiveWalks() {
        long l = 0L;
        for (int i = 0; i < this.walkIndices.length; ++i) {
            l += (long)this.walkIndices[i];
        }
        return l;
    }

    public abstract WalkSnapshot grabSnapshot(int var1, int var2);

    public abstract void dumpToFile(WalkSnapshot var1, String var2) throws IOException;

    public void populateSchedulerWithSources(Scheduler scheduler) {
        for (int i = 0; i < this.sources.length; ++i) {
            scheduler.addTask(this.sources[i]);
        }
    }

    public static int getWalkLength(WalkArray walkArray) {
        if (walkArray == null) {
            return 0;
        }
        return walkArray.size();
    }

    public abstract void populateSchedulerForInterval(Scheduler var1, VertexInterval var2);
}

