/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.graphchi.walks.analysis;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class WalkPathAnalyzerTemplate {
    private File directory;
    private BufferedWriter output;

    public WalkPathAnalyzerTemplate(File file) throws IOException {
        this.directory = file;
        if (!this.directory.isDirectory()) {
            throw new IllegalArgumentException("You must provide a directory");
        }
        this.output = new BufferedWriter(new FileWriter("walkoutput"));
    }

    public void analyze(int n, int n2, int n3) throws IOException {
        int n4 = n2 - n + 1;
        Walk[] walkArray = new Walk[n4];
        for (int i = 0; i < walkArray.length; ++i) {
            walkArray[i] = new Walk(n3);
        }
        String[] stringArray = this.directory.list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.startsWith("walks_");
            }
        });
        for (String object : stringArray) {
            System.out.println("Analyze: " + object);
            long l = new File(this.directory, object).length() / 10L;
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(new File(this.directory, object)), 0x3200000));
            try {
                for (long i = 0L; i < l; ++i) {
                    if (i % 1000000L == 0L) {
                        System.out.println(i + " / " + l);
                    }
                    int n5 = dataInputStream.readInt();
                    short s = dataInputStream.readShort();
                    int n6 = dataInputStream.readInt();
                    if (n5 < n || n5 > n2) continue;
                    walkArray[n5 - n].addWalk(s, n6);
                }
            }
            catch (EOFException eOFException) {
                continue;
            }
            dataInputStream.close();
        }
        for (Walk walk : walkArray) {
            walk.sort();
        }
        this.groupBySourceAndAnalyze(walkArray);
        this.output.close();
    }

    private void groupBySourceAndAnalyze(Walk[] walkArray) {
        int n = -1;
        ArrayList<Walk> arrayList = new ArrayList<Walk>();
        for (int i = 0; i < walkArray.length; ++i) {
            Walk walk = walkArray[i];
            if (walk.getSource() != n) {
                if (n != -1) {
                    this.processWalksFromSource(n, arrayList);
                }
                n = walk.getSource();
                arrayList = new ArrayList();
            }
            arrayList.add(walk);
        }
        this.processWalksFromSource(n, arrayList);
    }

    private void processWalksFromSource(int n, ArrayList<Walk> arrayList) {
        Collections.sort(arrayList, new Comparator<Walk>(){

            @Override
            public int compare(Walk walk, Walk walk2) {
                int n;
                int n2 = walk.getDestination();
                return n2 == (n = walk2.getDestination()) ? 0 : (n2 < n ? -1 : 1);
            }
        });
        int n2 = -1;
        ArrayList<Walk> arrayList2 = new ArrayList<Walk>();
        for (Walk walk : arrayList) {
            if (walk.getDestination() != n2) {
                if (n2 != -1) {
                    this.handleSourcePathSet(n, n2, arrayList2);
                }
                n2 = walk.getDestination();
                arrayList2 = new ArrayList();
            }
            arrayList2.add(walk);
        }
    }

    private void handleSourcePathSet(int n, int n2, ArrayList<Walk> arrayList) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (Walk object : arrayList) {
            String string = this.getPathType(object);
            if (hashMap.containsKey(string)) {
                hashMap.put(string, (Integer)hashMap.get(string) + 1);
                continue;
            }
            hashMap.put(string, 1);
        }
        try {
            for (Map.Entry entry : hashMap.entrySet()) {
                this.output.write(n + "-" + n2 + "," + (String)entry.getKey() + "," + entry.getValue() + "\n");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public String getPathType(Walk walk) {
        int[] nArray = walk.getPath();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(nArray[i] % 2);
            stringBuffer.append("-");
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) throws Exception {
        WalkPathAnalyzerTemplate walkPathAnalyzerTemplate = new WalkPathAnalyzerTemplate(new File(stringArray[0]));
        int n = Integer.parseInt(stringArray[1]);
        int n2 = Integer.parseInt(stringArray[2]);
        int n3 = Integer.parseInt(stringArray[3]);
        walkPathAnalyzerTemplate.analyze(n, n2, n3);
    }

    private static class Walk {
        private long[] path;
        int idx = 0;

        private Walk(int n) {
            this.path = new long[n];
        }

        void addWalk(short s, int n) {
            long l = (long)n | (long)s << 32;
            if (this.idx < this.path.length) {
                this.path[this.idx++] = l;
            }
        }

        int getSource() {
            return (int)(this.path[0] & 0xFFFFFFFFL);
        }

        int getDestination() {
            return (int)(this.path[this.idx - 1] & 0xFFFFFFFFL);
        }

        int[] getPath() {
            int[] nArray = new int[this.idx];
            for (int i = 0; i < this.idx; ++i) {
                nArray[i] = (int)(this.path[i] & 0xFFFFFFFFL);
            }
            return nArray;
        }

        void sort() {
            Arrays.sort(this.path);
        }

        String getPathDescription() {
            Arrays.sort(this.path);
            StringBuffer stringBuffer = new StringBuffer();
            for (long l : this.path) {
                stringBuffer.append((l & 0xFFFFFFFFL) + "-");
            }
            return stringBuffer.toString();
        }
    }
}

