/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.graphchi.walks.distributions;

import edu.cmu.graphchi.util.IdCount;
import java.util.Arrays;
import java.util.Comparator;
import java.util.TreeSet;

public class DiscreteDistribution {
    private int[] ids;
    private short[] counts;
    private int uniqueCount;

    private DiscreteDistribution(int n) {
        this.ids = new int[n];
        this.counts = new short[n];
        this.uniqueCount = n;
    }

    public DiscreteDistribution() {
        this(0);
    }

    public DiscreteDistribution forceToSize(int n) {
        if (n > this.ids.length) {
            return this;
        }
        int[] nArray = new int[n];
        short[] sArray = new short[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.ids[i];
            sArray[i] = this.counts[i];
        }
        DiscreteDistribution discreteDistribution = new DiscreteDistribution();
        discreteDistribution.ids = nArray;
        discreteDistribution.counts = sArray;
        discreteDistribution.uniqueCount = n;
        return discreteDistribution;
    }

    public int totalCount() {
        int n = 0;
        for (int i = 0; i < this.counts.length; ++i) {
            if (this.counts[i] <= 0) continue;
            n += this.counts[i];
        }
        return n;
    }

    public void print() {
        for (int i = 0; i < this.ids.length; ++i) {
            System.out.println("D " + this.ids[i] + ", " + this.counts[i]);
        }
    }

    public IdCount[] getTop(int n) {
        TreeSet<IdCount> treeSet = new TreeSet<IdCount>(new Comparator<IdCount>(){

            @Override
            public int compare(IdCount idCount, IdCount idCount2) {
                return idCount.count > idCount2.count ? -1 : (idCount.count == idCount2.count ? (idCount.id < idCount2.id ? -1 : (idCount.id == idCount2.id ? 0 : 1)) : 1);
            }
        });
        IdCount idCount = null;
        for (int i = 0; i < this.uniqueCount; ++i) {
            if (treeSet.size() < n) {
                treeSet.add(new IdCount(this.ids[i], this.counts[i]));
                idCount = treeSet.last();
            } else if (this.counts[i] > idCount.count) {
                treeSet.remove(idCount);
                treeSet.add(new IdCount(this.ids[i], this.counts[i]));
                idCount = treeSet.last();
            }
            if (treeSet.size() <= n) continue;
            throw new RuntimeException("Top list too big: " + treeSet.size());
        }
        IdCount[] idCountArray = new IdCount[treeSet.size()];
        treeSet.toArray(idCountArray);
        return idCountArray;
    }

    public DiscreteDistribution(int[] nArray) {
        int n;
        if (nArray.length == 0) {
            this.ids = new int[0];
            this.counts = new short[0];
            return;
        }
        if (nArray.length == 1) {
            this.ids = new int[]{nArray[0]};
            this.counts = new short[]{1};
            return;
        }
        this.uniqueCount = 1;
        for (n = 1; n < nArray.length; ++n) {
            if (nArray[n] == nArray[n - 1]) continue;
            ++this.uniqueCount;
            if (nArray[n] >= nArray[n - 1]) continue;
            throw new RuntimeException("Not ordered! " + nArray[n] + " < " + nArray[n - 1]);
        }
        this.ids = new int[this.uniqueCount];
        this.counts = new short[this.uniqueCount];
        n = 0;
        int n2 = 1;
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] != nArray[i - 1]) {
                this.ids[n] = nArray[i - 1];
                this.counts[n] = n2;
                ++n;
                n2 = 1;
                continue;
            }
            n2 = (short)(n2 + 1);
        }
        this.ids[n] = nArray[nArray.length - 1];
        this.counts[n] = n2;
    }

    public DiscreteDistribution filteredAndShift(int n) {
        return this.filteredAndShift((short)n);
    }

    public DiscreteDistribution filteredAndShift(short s) {
        if (s <= 1) {
            return this;
        }
        int n = 0;
        for (int i = 0; i < this.uniqueCount; ++i) {
            n += this.counts[i] < s && this.counts[i] > 0 ? 1 : 0;
        }
        if (n == 0) {
            return this;
        }
        DiscreteDistribution discreteDistribution = new DiscreteDistribution(this.uniqueCount - n);
        int n2 = 0;
        for (int i = 0; i < this.uniqueCount; ++i) {
            if (this.counts[i] < s && this.counts[i] != -1) continue;
            discreteDistribution.ids[n2] = this.ids[i];
            discreteDistribution.counts[n2] = this.counts[i] != -1 ? (int)(this.counts[i] - s + 1) : -1;
            ++n2;
        }
        return discreteDistribution;
    }

    public static DiscreteDistribution createAvoidanceDistribution(int[] nArray) {
        DiscreteDistribution discreteDistribution = new DiscreteDistribution(nArray);
        Arrays.fill(discreteDistribution.counts, (short)-1);
        return discreteDistribution;
    }

    public int getCount(int n) {
        int n2 = Arrays.binarySearch(this.ids, n);
        if (n2 >= 0) {
            return this.counts[n2];
        }
        return 0;
    }

    public int size() {
        return this.uniqueCount;
    }

    public int avoidCount() {
        int n = 0;
        for (int i = 0; i < this.counts.length; ++i) {
            n += this.counts[i] >= 0 ? 0 : 1;
        }
        return n;
    }

    public int memorySizeEst() {
        int n = 64;
        return 6 * this.counts.length + 4 + n;
    }

    public int max() {
        short s;
        int s2 = Integer.MIN_VALUE;
        for (int i = 0; i < this.counts.length; ++i) {
            if (this.counts[i] <= s) continue;
            s = this.counts[i];
        }
        return s;
    }

    public static DiscreteDistribution merge(DiscreteDistribution discreteDistribution, DiscreteDistribution discreteDistribution2) {
        if (discreteDistribution.uniqueCount == 0) {
            return discreteDistribution2;
        }
        if (discreteDistribution2.uniqueCount == 0) {
            return discreteDistribution;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = discreteDistribution.size();
        int n5 = discreteDistribution2.size();
        while (n2 < n4 && n3 < n5) {
            if (discreteDistribution.ids[n2] == discreteDistribution2.ids[n3]) {
                ++n2;
                ++n3;
                ++n;
                continue;
            }
            if (discreteDistribution.ids[n2] < discreteDistribution2.ids[n3]) {
                ++n;
                ++n2;
                continue;
            }
            ++n;
            ++n3;
        }
        n += n5 - n3;
        DiscreteDistribution discreteDistribution3 = new DiscreteDistribution(n += n4 - n2);
        n2 = 0;
        n3 = 0;
        int n6 = 0;
        while (n2 < n4 && n3 < n5) {
            if (discreteDistribution.ids[n2] == discreteDistribution2.ids[n3]) {
                discreteDistribution3.ids[n6] = discreteDistribution.ids[n2];
                discreteDistribution3.counts[n6] = (short)(discreteDistribution.counts[n2] + discreteDistribution2.counts[n3]);
                if (discreteDistribution.counts[n2] < 0 || discreteDistribution2.counts[n3] < 0) {
                    discreteDistribution3.counts[n6] = -1;
                }
                ++n2;
                ++n3;
                ++n6;
                continue;
            }
            if (discreteDistribution.ids[n2] < discreteDistribution2.ids[n3]) {
                discreteDistribution3.ids[n6] = discreteDistribution.ids[n2];
                discreteDistribution3.counts[n6] = discreteDistribution.counts[n2];
                ++n6;
                ++n2;
                continue;
            }
            discreteDistribution3.ids[n6] = discreteDistribution2.ids[n3];
            discreteDistribution3.counts[n6] = discreteDistribution2.counts[n3];
            ++n6;
            ++n3;
        }
        while (n2 < n4) {
            discreteDistribution3.ids[n6] = discreteDistribution.ids[n2];
            discreteDistribution3.counts[n6] = discreteDistribution.counts[n2];
            ++n2;
            ++n6;
        }
        while (n3 < n5) {
            discreteDistribution3.ids[n6] = discreteDistribution2.ids[n3];
            discreteDistribution3.counts[n6] = discreteDistribution2.counts[n3];
            ++n3;
            ++n6;
        }
        return discreteDistribution3;
    }

    public int sizeExcludingAvoids() {
        int n = 0;
        for (int i = 0; i < this.uniqueCount; ++i) {
            if (this.counts[i] <= 0) continue;
            ++n;
        }
        return n;
    }
}

