/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.graphchi.walks.distributions;

import edu.cmu.graphchi.ChiLogger;
import edu.cmu.graphchi.util.IdCount;
import edu.cmu.graphchi.util.IntegerBuffer;
import edu.cmu.graphchi.walks.LongWalkArray;
import edu.cmu.graphchi.walks.WalkArray;
import edu.cmu.graphchi.walks.distributions.DiscreteDistribution;
import edu.cmu.graphchi.walks.distributions.RemoteDrunkardCompanion;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

public abstract class TwoKeyCompanion
extends UnicastRemoteObject
implements RemoteDrunkardCompanion {
    protected static final int BUFFER_CAPACITY = 128;
    protected static final int BUFFER_MAX = 128;
    boolean isLowInMemory = false;
    protected ConcurrentHashMap<Integer, ConcurrentHashMap<Integer, DiscreteDistribution>> distributions;
    protected ConcurrentHashMap<Integer, ConcurrentHashMap<Integer, IntegerBuffer>> buffers;
    protected ConcurrentHashMap<Integer, ConcurrentHashMap<Integer, Object>> distrLocks;
    protected AtomicInteger outstanding = new AtomicInteger(0);
    protected ExecutorService parallelExecutor;
    protected long maxMemoryBytes;
    protected LinkedBlockingQueue<WalkSubmission> pendingQueue = new LinkedBlockingQueue();
    protected static Logger logger = ChiLogger.getLogger("pathcompanion");
    protected Timer timer = new Timer(true);

    private long memoryAuditReport() {
        long l;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        int n = 0;
        for (ConcurrentHashMap<Integer, IntegerBuffer> concurrentHashMap : this.buffers.values()) {
            l2 += 4L;
            for (IntegerBuffer integerBuffer : concurrentHashMap.values()) {
                ++n;
                l2 += 4L;
                l = integerBuffer.memorySizeEst();
                l3 += l;
                l4 = Math.max(l4, l);
            }
        }
        long l5 = 0L;
        long l6 = 0L;
        l = 0L;
        int n2 = 0;
        for (ConcurrentHashMap<Integer, DiscreteDistribution> concurrentHashMap : this.distributions.values()) {
            l2 += 4L;
            for (DiscreteDistribution discreteDistribution : concurrentHashMap.values()) {
                ++n2;
                l2 += 4L;
                long l7 = discreteDistribution.memorySizeEst();
                l5 += l7;
                l6 = Math.max(l7, l6);
                l += (long)(discreteDistribution.avoidCount() * 6);
            }
        }
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
        logger.info("======= MEMORY REPORT ======");
        logger.info("Companion internal: " + numberFormat.format((double)l2 / 1024.0 / 1024.0) + " mb");
        logger.info("Buffer mem: " + numberFormat.format((double)l3 / 1024.0 / 1024.0) + " mb");
        logger.info("Avg bytes per buffer: " + numberFormat.format((double)l3 * 1.0 / (double)n / 1024.0) + " kb");
        logger.info("Max buffer was: " + numberFormat.format((double)l4 / 1024.0) + "kb");
        logger.info("Distribution mem: " + numberFormat.format((double)l5 / 1024.0 / 1024.0) + " mb");
        logger.info("- of which avoids: " + numberFormat.format((double)l / 1024.0 / 1024.0) + " mb");
        logger.info("Avg bytes per distribution: " + numberFormat.format((double)l5 * 1.0 / (double)n2 / 1024.0) + " kb");
        logger.info("Max distribution: " + numberFormat.format((double)l6 / 1024.0) + " kb");
        long l8 = l2 + l3 + l5;
        logger.info("** Total:  " + numberFormat.format((double)l8 / 1024.0 / 1024.0 / 1024.0) + " GB (low-mem limit " + (double)Runtime.getRuntime().maxMemory() * 0.75 / 1024.0 / 1024.0 / 1024.0 + "GB)");
        boolean bl = this.isLowInMemory = l8 > this.maxMemoryBytes;
        if (this.isLowInMemory) {
            this.compactMemoryUsage();
        }
        return l8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compactMemoryUsage() {
        long l = 0L;
        long l2 = 0L;
        for (Integer n : this.distributions.keySet()) {
            ConcurrentHashMap<Integer, DiscreteDistribution> concurrentHashMap = this.distributions.get(n);
            for (Integer n2 : concurrentHashMap.keySet()) {
                DiscreteDistribution discreteDistribution;
                DiscreteDistribution discreteDistribution2;
                Object object = this.distrLocks.get(n).get(n2);
                synchronized (object) {
                    discreteDistribution2 = concurrentHashMap.get(n2);
                    discreteDistribution = discreteDistribution2.filteredAndShift(2);
                    concurrentHashMap.put(n2, discreteDistribution);
                }
                l += (long)discreteDistribution2.memorySizeEst();
                l2 += (long)discreteDistribution.memorySizeEst();
            }
        }
        logger.info("** Compacted: " + (double)l / 1024.0 / 1024.0 / 1024.0 + " GB --> " + (double)l2 / 1024.0 / 1024.0 / 1024.0 + " GB");
    }

    public TwoKeyCompanion(int n, long l) throws RemoteException {
        this.maxMemoryBytes = l;
        this.parallelExecutor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        this.buffers = new ConcurrentHashMap();
        this.distrLocks = new ConcurrentHashMap();
        this.distributions = new ConcurrentHashMap();
        for (int i = 0; i < n; ++i) {
            Thread thread = new Thread(new ProcessingThread(i, n));
            thread.setDaemon(true);
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureExists(int n, int n2) {
        Object object;
        ConcurrentHashMap<Integer, Object> concurrentHashMap = this.distrLocks.get(n);
        if (concurrentHashMap == null) {
            object = new ConcurrentHashMap();
            concurrentHashMap = this.distrLocks.putIfAbsent(n, (ConcurrentHashMap<Integer, Object>)object);
            if (concurrentHashMap == null) {
                concurrentHashMap = object;
            }
        }
        if ((object = concurrentHashMap.get(n2)) == null) {
            Object object2 = new Object();
            object = concurrentHashMap.putIfAbsent(n2, object2);
            if (object == null) {
                Object object3 = object2;
                synchronized (object3) {
                    ConcurrentHashMap<Integer, DiscreteDistribution> concurrentHashMap2 = this.distributions.get(n);
                    if (concurrentHashMap2 == null) {
                        concurrentHashMap2 = new ConcurrentHashMap();
                        this.distributions.put(n, concurrentHashMap2);
                    }
                    concurrentHashMap2.put(n2, new DiscreteDistribution());
                    ConcurrentHashMap<Integer, IntegerBuffer> concurrentHashMap3 = this.buffers.get(n);
                    if (concurrentHashMap3 == null) {
                        concurrentHashMap3 = new ConcurrentHashMap();
                        this.buffers.put(n, concurrentHashMap3);
                    }
                    concurrentHashMap3.put(n2, new IntegerBuffer(128));
                }
            }
            Object object4 = object;
            synchronized (object4) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeWith(int n, int n2, DiscreteDistribution discreteDistribution) {
        this.ensureExists(n, n2);
        Object object = this.distrLocks.get(n).get(n2);
        synchronized (object) {
            DiscreteDistribution discreteDistribution2 = this.distributions.get(n).get(n2);
            DiscreteDistribution discreteDistribution3 = DiscreteDistribution.merge(discreteDistribution2, discreteDistribution);
            this.distributions.get(n).put(n2, discreteDistribution3);
        }
    }

    @Override
    public void setAvoidList(int n, int[] nArray) throws RemoteException {
    }

    @Override
    public IdCount[] getTop(int n, int n2) throws RemoteException {
        return null;
    }

    @Override
    public void setSources(int[] nArray) throws RemoteException {
        this.timer.cancel();
        this.timer = new Timer(true);
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                TwoKeyCompanion.this.memoryAuditReport();
            }
        }, 5000L, 60000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _processWalks(WalkArray walkArray, int[] nArray) {
        long[] lArray = ((LongWalkArray)walkArray).getArray();
        long l = System.currentTimeMillis();
        for (int i = 0; i < lArray.length; ++i) {
            IntegerBuffer integerBuffer;
            long l2 = lArray[i];
            if (this.ignoreWalk(l2)) continue;
            int n = nArray[i];
            int n2 = this.getFirstKey(l2, n);
            int n3 = this.getSecondKey(l2, n);
            int n4 = this.getValue(l2, n);
            this.ensureExists(n2, n3);
            IntegerBuffer integerBuffer2 = integerBuffer = this.buffers.get(n2).get(n3);
            synchronized (integerBuffer2) {
                integerBuffer.add(n4);
                continue;
            }
        }
        long l3 = System.currentTimeMillis() - l;
        if (l3 > 1000L) {
            logger.info("Processing " + lArray.length + " took " + l3 + " ms.");
        }
    }

    protected boolean ignoreWalk(long l) {
        return l == 0L;
    }

    protected abstract int getFirstKey(long var1, int var3);

    protected abstract int getSecondKey(long var1, int var3);

    protected abstract int getValue(long var1, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drainBuffer(int n, int n2) {
        int[] nArray;
        IntegerBuffer integerBuffer = this.buffers.get(n).get(n2);
        Object object = integerBuffer;
        synchronized (object) {
            nArray = integerBuffer.toIntArray();
            this.buffers.get(n).put(n2, new IntegerBuffer(128));
        }
        Arrays.sort(nArray);
        object = new DiscreteDistribution(nArray);
        this.mergeWith(n, n2, (DiscreteDistribution)object);
    }

    @Override
    public void processWalks(WalkArray walkArray, int[] nArray) throws RemoteException {
        try {
            this.pendingQueue.put(new WalkSubmission(walkArray, nArray));
            int n = this.pendingQueue.size();
            if (n > 50 && n % 20 == 0) {
                logger.info("Warning, pending queue size: " + n);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void waitForFinish() {
        logger.info("Waiting for processing to finish");
        while (this.pendingQueue.size() > 0) {
            logger.info("...");
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        while (this.outstanding.get() > 0) {
            logger.info("...");
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    @Override
    public abstract void outputDistributions(String var1) throws RemoteException;

    @Override
    public void outputDistributions(String string, int n) throws RemoteException {
        this.outputDistributions(string);
    }

    public void close() {
        this.parallelExecutor.shutdown();
        this.timer.cancel();
        this.clearMemory();
    }

    protected void clearMemory() {
        this.distributions.clear();
        this.buffers.clear();
        this.distrLocks.clear();
    }

    private class ProcessingThread
    implements Runnable {
        private int id;
        private int numThreads;

        public ProcessingThread(int n, int n2) {
            this.id = n;
            this.numThreads = n2;
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 7[UNCONDITIONALDOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    protected static class WalkSubmission {
        WalkArray walks;
        int[] atVertices;

        private WalkSubmission(WalkArray walkArray, int[] nArray) {
            this.walks = walkArray;
            this.atVertices = nArray;
        }
    }
}

