/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.query;

import org.hisp.dhis.query.Operator;

public class Filter {
    private String property;
    private Operator operator;
    private Object value;

    private Filter() {
    }

    private Filter(String property, Operator operator, Object value) {
        this.property = property;
        this.operator = operator;
        this.value = value;
    }

    public static Filter eq(String property, Object value) {
        return new Filter(property, Operator.EQ, value);
    }

    public static Filter ge(String property, Object value) {
        return new Filter(property, Operator.GE, value);
    }

    public static Filter gt(String property, Object value) {
        return new Filter(property, Operator.GT, value);
    }

    public static Filter le(String property, Object value) {
        return new Filter(property, Operator.LE, value);
    }

    public static Filter lt(String property, Object value) {
        return new Filter(property, Operator.LT, value);
    }

    public static Filter isTrue(String property) {
        return new Filter(property, Operator.EQ, "true");
    }

    public static Filter isFalse(String property) {
        return new Filter(property, Operator.EQ, "false");
    }

    public static Filter like(String property, Object value) {
        return new Filter(property, Operator.LIKE, value);
    }

    public String getProperty() {
        return this.property;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Object getValue() {
        return this.value;
    }
}

