/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis;

import java.util.Base64;
import java.util.List;
import org.hisp.dhis.Dhis2Config;
import org.hisp.dhis.ResponseMessage;
import org.hisp.dhis.model.Objects;
import org.hisp.dhis.model.OrgUnit;
import org.hisp.dhis.model.OrgUnitGroup;
import org.hisp.dhis.model.OrgUnitGroupSet;
import org.hisp.dhis.model.OrgUnitLevel;
import org.hisp.dhis.model.TableHook;
import org.hisp.dhis.query.Filter;
import org.hisp.dhis.query.Order;
import org.hisp.dhis.query.Paging;
import org.hisp.dhis.query.Query;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class Dhis2 {
    private Dhis2Config dhis2Config;
    private RestTemplate restTemplate;

    public Dhis2(Dhis2Config dhis2Config) {
        this.dhis2Config = dhis2Config;
        this.restTemplate = new RestTemplate();
    }

    public Dhis2(Dhis2Config dhis2Config, RestTemplate restTemplate) {
        this.dhis2Config = dhis2Config;
        this.restTemplate = restTemplate;
    }

    public <T> ResponseMessage saveObject(String path, T object) {
        String url = this.dhis2Config.getResolvedUrl(path);
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", Dhis2.getBasicAuthString(this.dhis2Config.getUsername(), this.dhis2Config.getPassword()));
        headers.set("Content-Type", "application/json");
        HttpEntity requestEntity = new HttpEntity(object, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, ResponseMessage.class, new Object[0]);
        ResponseMessage message = (ResponseMessage)response.getBody();
        message.setHeaders(headers);
        return message;
    }

    public <T> ResponseMessage updateObject(String path, T object) {
        String url = this.dhis2Config.getResolvedUrl(path);
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", Dhis2.getBasicAuthString(this.dhis2Config.getUsername(), this.dhis2Config.getPassword()));
        headers.set("Content-Type", "application/json");
        HttpEntity requestEntity = new HttpEntity(object, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.PUT, requestEntity, ResponseMessage.class, new Object[0]);
        ResponseMessage message = (ResponseMessage)response.getBody();
        message.setHeaders(headers);
        return message;
    }

    public <T> T getObject(String path, Class<T> klass) {
        return this.getObjectFromUrl(this.dhis2Config.getResolvedUrl(path), klass);
    }

    private <T> T getObject(String path, String id, Class<T> klass) {
        String url = this.dhis2Config.getResolvedUriBuilder().pathSegment(new String[]{path}).pathSegment(new String[]{id}).build().toUriString();
        return this.getObjectFromUrl(url, klass);
    }

    private <T> T getObject(UriComponentsBuilder uriBuilder, Query filters, Class<T> klass) {
        Order order;
        for (Filter filter : filters.getFilters()) {
            String filterValue = filter.getProperty() + ":" + filter.getOperator().value() + ":" + filter.getValue();
            uriBuilder.queryParam("filter", new Object[]{filterValue});
        }
        Paging paging = filters.getPaging();
        if (paging.hasPaging()) {
            if (paging.hasPage()) {
                uriBuilder.queryParam("page", new Object[]{paging.getPage()});
            }
            if (paging.hasPageSize()) {
                uriBuilder.queryParam("pageSize", new Object[]{paging.getPageSize()});
            }
        } else {
            uriBuilder.queryParam("paging", new Object[]{"false"});
        }
        if ((order = filters.getOrder()).hasOrder()) {
            String orderValue = order.getProperty() + ":" + order.getDirection().name().toLowerCase();
            uriBuilder.queryParam("order", new Object[]{orderValue});
        }
        String url = uriBuilder.build().toUriString();
        return this.getObjectFromUrl(url, klass);
    }

    private <T> T getObjectFromUrl(String url, Class<T> klass) {
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", Dhis2.getBasicAuthString(this.dhis2Config.getUsername(), this.dhis2Config.getPassword()));
        headers.set("Accept", "application/json");
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), klass, new Object[0]);
        return (T)response.getBody();
    }

    public boolean objectExists(String path) {
        String url = this.dhis2Config.getResolvedUrl(path);
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", Dhis2.getBasicAuthString(this.dhis2Config.getUsername(), this.dhis2Config.getPassword()));
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.HEAD, new HttpEntity((MultiValueMap)headers), Object.class, new Object[0]);
            return HttpStatus.OK == response.getStatusCode();
        }
        catch (HttpClientErrorException ex) {
            if (HttpStatus.NOT_FOUND == ex.getStatusCode()) {
                return false;
            }
            throw ex;
        }
    }

    public ResponseMessage saveOrgUnit(OrgUnit orgUnit) {
        return this.saveObject("organisationUnits", orgUnit);
    }

    public ResponseMessage updateOrgUnit(OrgUnit orgUnit) {
        return this.updateObject(String.format("organisationUnits/%s", orgUnit.getId()), orgUnit);
    }

    public OrgUnit getOrgUnit(String id) {
        return this.getObject(this.dhis2Config.getResolvedUriBuilder().pathSegment(new String[]{"organisationUnits"}).pathSegment(new String[]{id}).queryParam("fields", new Object[]{"*,parent[id,code,name,shortName,description]"}), Query.instance(), OrgUnit.class);
    }

    public List<OrgUnit> getOrgUnits() {
        return this.getOrgUnits(Query.instance());
    }

    public List<OrgUnit> getOrgUnits(Query query) {
        return this.getObject(this.dhis2Config.getResolvedUriBuilder().pathSegment(new String[]{"organisationUnits"}).queryParam("fields", new Object[]{"id,code,name,shortName,description,parent[id,code,name,shortName,description,path,level],path,level"}), query, Objects.class).getOrganisationUnits();
    }

    public ResponseMessage saveOrgUnitGroup(OrgUnitGroup orgUnitGroup) {
        return this.saveObject("organisationUnitGroups", orgUnitGroup);
    }

    public ResponseMessage updateOrgUnitGroup(OrgUnitGroup orgUnitGroup) {
        return this.updateObject(String.format("organisationUnitGroups/%s", orgUnitGroup.getId()), orgUnitGroup);
    }

    public OrgUnitGroup getOrgUnitGroup(String id) {
        return this.getObject(this.dhis2Config.getResolvedUriBuilder().pathSegment(new String[]{"organisationUnitGroups"}).pathSegment(new String[]{id}).queryParam("fields", new Object[]{"id,code,name,shortName,description"}), Query.instance(), OrgUnitGroup.class);
    }

    public List<OrgUnitGroup> getOrgUnitGroups() {
        return this.getOrgUnitGroups(Query.instance());
    }

    public List<OrgUnitGroup> getOrgUnitGroups(Query query) {
        return this.getObject(this.dhis2Config.getResolvedUriBuilder().pathSegment(new String[]{"organisationUnitGroups"}).queryParam("fields", new Object[]{"id,code,name,shortName,description"}), query, Objects.class).getOrganisationUnitGroups();
    }

    public ResponseMessage saveOrgUnitGroupSet(OrgUnitGroupSet orgUnitGroupSet) {
        return this.saveObject("organisationUnitGroupSets", orgUnitGroupSet);
    }

    public ResponseMessage updateOrgUnitGroupSet(OrgUnitGroupSet orgUnitGroupSet) {
        return this.updateObject(String.format("organisationUnitGroupSets/%s", orgUnitGroupSet.getId()), orgUnitGroupSet);
    }

    public OrgUnitGroupSet getOrgUnitGroupSet(String id) {
        return this.getObject(this.dhis2Config.getResolvedUriBuilder().pathSegment(new String[]{"organisationUnitGroupSets"}).pathSegment(new String[]{id}).queryParam("fields", new Object[]{"*,organisationUnitGroups[id,code,name,shortName,description]"}), Query.instance(), OrgUnitGroupSet.class);
    }

    public List<OrgUnitGroupSet> getOrgUnitGroupSets() {
        return this.getOrgUnitGroupSets(Query.instance());
    }

    public List<OrgUnitGroupSet> getOrgUnitGroupSets(Query query) {
        return this.getObject(this.dhis2Config.getResolvedUriBuilder().pathSegment(new String[]{"organisationUnitGroupSets"}).queryParam("fields", new Object[]{"id,code,name,shortName,description,organisationUnitGroups[id,code,name,shortName,description]"}), query, Objects.class).getOrganisationUnitGroupSets();
    }

    public ResponseMessage saveOrgUnitLevel(OrgUnitLevel orgUnitLevel) {
        return this.saveObject("organisationUnitLevels", orgUnitLevel);
    }

    public ResponseMessage updateOrgUnitLevel(OrgUnitLevel orgUnitLevel) {
        return this.updateObject(String.format("organisationUnitLevels/%s", orgUnitLevel.getId()), orgUnitLevel);
    }

    public OrgUnitLevel getOrgUnitLevel(String id) {
        return this.getObject(this.dhis2Config.getResolvedUriBuilder().pathSegment(new String[]{"organisationUnitLevels"}).pathSegment(new String[]{id}).queryParam("fields", new Object[]{"id,code,name,level"}), Query.instance(), OrgUnitLevel.class);
    }

    public List<OrgUnitLevel> getOrgUnitLevels() {
        return this.getOrgUnitLevels(Query.instance());
    }

    public List<OrgUnitLevel> getOrgUnitLevels(Query query) {
        return this.getObject(this.dhis2Config.getResolvedUriBuilder().pathSegment(new String[]{"organisationUnitLevels"}).queryParam("fields", new Object[]{"id,code,name,level"}), query, Objects.class).getOrganisationUnitLevels();
    }

    public ResponseMessage saveTableHook(TableHook tableHook) {
        return this.saveObject("analyticsTableHooks", tableHook);
    }

    public ResponseMessage updateTableHook(TableHook tableHook) {
        return this.updateObject(String.format("analyticsTableHooks/%s", tableHook.getId()), tableHook);
    }

    public TableHook getTableHook(String id) {
        return this.getObject("analyticsTableHooks", id, TableHook.class);
    }

    public List<TableHook> getTableHooks() {
        return this.getTableHooks(Query.instance());
    }

    public List<TableHook> getTableHooks(Query query) {
        return this.getObject(this.dhis2Config.getResolvedUriBuilder().pathSegment(new String[]{"analyticsTableHooks"}).queryParam("fields", new Object[]{"id,code,name"}), query, Objects.class).getAnalyticsTableHooks();
    }

    private static String getBasicAuthString(String username, String password) {
        String string = username + ":" + password;
        return "Basic " + Base64.getEncoder().encodeToString(string.getBytes());
    }
}

