/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis;

import java.util.Base64;
import java.util.List;
import org.hisp.dhis.Dhis2Config;
import org.hisp.dhis.ResponseMessage;
import org.hisp.dhis.model.Category;
import org.hisp.dhis.model.CategoryCombo;
import org.hisp.dhis.model.CategoryOptionGroupSet;
import org.hisp.dhis.model.DataElement;
import org.hisp.dhis.model.DataElementGroupSet;
import org.hisp.dhis.model.Dimension;
import org.hisp.dhis.model.Objects;
import org.hisp.dhis.model.OrgUnit;
import org.hisp.dhis.model.OrgUnitGroup;
import org.hisp.dhis.model.OrgUnitGroupSet;
import org.hisp.dhis.model.OrgUnitLevel;
import org.hisp.dhis.model.PeriodType;
import org.hisp.dhis.model.Program;
import org.hisp.dhis.model.SystemInfo;
import org.hisp.dhis.model.TableHook;
import org.hisp.dhis.query.Filter;
import org.hisp.dhis.query.Order;
import org.hisp.dhis.query.Paging;
import org.hisp.dhis.query.Query;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class Dhis2 {
    private static final String ID_FIELDS = "id,code,name,created,lastUpdated";
    private static final String NAME_FIELDS = String.format("%s,shortName,description", "id,code,name,created,lastUpdated");
    private static final String DATA_ELEMENT_FIELDS = String.format("%1$s,aggregationType,valueType,domainType,legendSets[%1$s]", NAME_FIELDS);
    private static final String CATEGORY_FIELDS = String.format("%s,dataDimensionType,dataDimension", NAME_FIELDS);
    private static final String RESOURCE_SYSTEM_INFO = "system/info";
    private Dhis2Config dhis2Config;
    private RestTemplate restTemplate;

    public Dhis2(Dhis2Config dhis2Config) {
        this.dhis2Config = dhis2Config;
        this.restTemplate = new RestTemplate();
    }

    public Dhis2(Dhis2Config dhis2Config, RestTemplate restTemplate) {
        this.dhis2Config = dhis2Config;
        this.restTemplate = restTemplate;
    }

    public HttpStatus getStatus() {
        try {
            HttpHeaders headers = this.getBasicAuthAcceptJsonHeaders();
            String url = this.dhis2Config.getResolvedUrl(RESOURCE_SYSTEM_INFO);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), SystemInfo.class, new Object[0]);
            return response.getStatusCode();
        }
        catch (HttpClientErrorException | HttpServerErrorException ex) {
            return ex.getStatusCode();
        }
    }

    public <T> ResponseMessage saveObject(String path, T object) {
        String url = this.dhis2Config.getResolvedUrl(path);
        HttpHeaders headers = this.getBasicAuthAcceptJsonHeaders();
        HttpEntity requestEntity = new HttpEntity(object, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, ResponseMessage.class, new Object[0]);
        ResponseMessage message = (ResponseMessage)response.getBody();
        message.setHeaders(headers);
        return message;
    }

    public <T> ResponseMessage updateObject(String path, T object) {
        String url = this.dhis2Config.getResolvedUrl(path);
        HttpHeaders headers = this.getBasicAuthAcceptJsonHeaders();
        HttpEntity requestEntity = new HttpEntity(object, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.PUT, requestEntity, ResponseMessage.class, new Object[0]);
        ResponseMessage message = (ResponseMessage)response.getBody();
        message.setHeaders(headers);
        return message;
    }

    public <T> T getObject(String path, Class<T> klass) {
        return this.getObjectFromUrl(this.dhis2Config.getResolvedUrl(path), klass);
    }

    private <T> T getObject(String path, String id, Class<T> klass) {
        String url = this.dhis2Config.getResolvedUriBuilder().pathSegment(new String[]{path}).pathSegment(new String[]{id}).build().toUriString();
        return this.getObjectFromUrl(url, klass);
    }

    private <T> T getObject(UriComponentsBuilder uriBuilder, Query filters, Class<T> klass) {
        Order order;
        for (Filter filter : filters.getFilters()) {
            String filterValue = filter.getProperty() + ":" + filter.getOperator().value() + ":" + filter.getValue();
            uriBuilder.queryParam("filter", new Object[]{filterValue});
        }
        Paging paging = filters.getPaging();
        if (paging.hasPaging()) {
            if (paging.hasPage()) {
                uriBuilder.queryParam("page", new Object[]{paging.getPage()});
            }
            if (paging.hasPageSize()) {
                uriBuilder.queryParam("pageSize", new Object[]{paging.getPageSize()});
            }
        } else {
            uriBuilder.queryParam("paging", new Object[]{"false"});
        }
        if ((order = filters.getOrder()).hasOrder()) {
            String orderValue = order.getProperty() + ":" + order.getDirection().name().toLowerCase();
            uriBuilder.queryParam("order", new Object[]{orderValue});
        }
        String url = uriBuilder.build().toUriString();
        return this.getObjectFromUrl(url, klass);
    }

    private <T> T getObjectFromUrl(String url, Class<T> klass) {
        HttpHeaders headers = this.getBasicAuthAcceptJsonHeaders();
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), klass, new Object[0]);
        return (T)response.getBody();
    }

    public boolean objectExists(String path) {
        String url = this.dhis2Config.getResolvedUrl(path);
        HttpHeaders headers = this.getBasicAuthAcceptJsonHeaders();
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.HEAD, new HttpEntity((MultiValueMap)headers), Object.class, new Object[0]);
            return HttpStatus.OK == response.getStatusCode();
        }
        catch (HttpClientErrorException ex) {
            if (HttpStatus.NOT_FOUND == ex.getStatusCode()) {
                return false;
            }
            throw ex;
        }
    }

    public ResponseMessage saveOrgUnit(OrgUnit orgUnit) {
        return this.saveObject("organisationUnits", orgUnit);
    }

    public ResponseMessage updateOrgUnit(OrgUnit orgUnit) {
        return this.updateObject(String.format("organisationUnits/%s", orgUnit.getId()), orgUnit);
    }

    public OrgUnit getOrgUnit(String id) {
        String fields = NAME_FIELDS + ",path,level";
        return this.getObject(this.dhis2Config.getResolvedUriBuilder().pathSegment(new String[]{"organisationUnits"}).pathSegment(new String[]{id}).queryParam("fields", new Object[]{String.format("%s,parent[%s]", fields, fields)}), Query.instance(), OrgUnit.class);
    }

    public List<OrgUnit> getOrgUnits(Query query) {
        String fields = NAME_FIELDS + ",path,level";
        return this.getObject(this.dhis2Config.getResolvedUriBuilder().pathSegment(new String[]{"organisationUnits"}).queryParam("fields", new Object[]{String.format("%s,parent[%s]", fields, fields)}), query, Objects.class).getOrganisationUnits();
    }

    public ResponseMessage saveOrgUnitGroup(OrgUnitGroup orgUnitGroup) {
        return this.saveObject("organisationUnitGroups", orgUnitGroup);
    }

    public ResponseMessage updateOrgUnitGroup(OrgUnitGroup orgUnitGroup) {
        return this.updateObject(String.format("organisationUnitGroups/%s", orgUnitGroup.getId()), orgUnitGroup);
    }

    public OrgUnitGroup getOrgUnitGroup(String id) {
        return this.getObject(this.dhis2Config.getResolvedUriBuilder().pathSegment(new String[]{"organisationUnitGroups"}).pathSegment(new String[]{id}).queryParam("fields", new Object[]{NAME_FIELDS}), Query.instance(), OrgUnitGroup.class);
    }

    public List<OrgUnitGroup> getOrgUnitGroups(Query query) {
        return this.getObject(this.dhis2Config.getResolvedUriBuilder().pathSegment(new String[]{"organisationUnitGroups"}).queryParam("fields", new Object[]{NAME_FIELDS}), query, Objects.class).getOrganisationUnitGroups();
    }

    public ResponseMessage saveOrgUnitGroupSet(OrgUnitGroupSet orgUnitGroupSet) {
        return this.saveObject("organisationUnitGroupSets", orgUnitGroupSet);
    }

    public ResponseMessage updateOrgUnitGroupSet(OrgUnitGroupSet orgUnitGroupSet) {
        return this.updateObject(String.format("organisationUnitGroupSets/%s", orgUnitGroupSet.getId()), orgUnitGroupSet);
    }

    public OrgUnitGroupSet getOrgUnitGroupSet(String id) {
        return this.getObject(this.dhis2Config.getResolvedUriBuilder().pathSegment(new String[]{"organisationUnitGroupSets"}).pathSegment(new String[]{id}).queryParam("fields", new Object[]{String.format("%s,organisationUnitGroups[%s]", NAME_FIELDS, NAME_FIELDS)}), Query.instance(), OrgUnitGroupSet.class);
    }

    public List<OrgUnitGroupSet> getOrgUnitGroupSets(Query query) {
        return this.getObject(this.dhis2Config.getResolvedUriBuilder().pathSegment(new String[]{"organisationUnitGroupSets"}).queryParam("fields", new Object[]{String.format("%s,organisationUnitGroups[%s]", NAME_FIELDS, NAME_FIELDS)}), query, Objects.class).getOrganisationUnitGroupSets();
    }

    public OrgUnitLevel getOrgUnitLevel(String id) {
        return this.getObject(this.dhis2Config.getResolvedUriBuilder().pathSegment(new String[]{"organisationUnitLevels"}).pathSegment(new String[]{id}).queryParam("fields", new Object[]{String.format("%s,level", ID_FIELDS)}), Query.instance(), OrgUnitLevel.class);
    }

    public List<OrgUnitLevel> getOrgUnitLevels(Query query) {
        return this.getObject(this.dhis2Config.getResolvedUriBuilder().pathSegment(new String[]{"organisationUnitLevels"}).queryParam("fields", new Object[]{String.format("%s,level", ID_FIELDS)}), query, Objects.class).getOrganisationUnitLevels();
    }

    public Category getCategory(String id) {
        return this.getObject(this.dhis2Config.getResolvedUriBuilder().pathSegment(new String[]{"categories"}).pathSegment(new String[]{id}).queryParam("fields", new Object[]{CATEGORY_FIELDS}), Query.instance(), Category.class);
    }

    public List<Category> getCategories(Query query) {
        return this.getObject(this.dhis2Config.getResolvedUriBuilder().pathSegment(new String[]{"categories"}).queryParam("fields", new Object[]{CATEGORY_FIELDS}), query, Objects.class).getCategories();
    }

    public CategoryCombo getCategoryCombo(String id) {
        return this.getObject(this.dhis2Config.getResolvedUriBuilder().pathSegment(new String[]{"categoryCombos"}).pathSegment(new String[]{id}).queryParam("fields", new Object[]{NAME_FIELDS}), Query.instance(), CategoryCombo.class);
    }

    public List<CategoryCombo> getCategoryCombos(Query query) {
        return this.getObject(this.dhis2Config.getResolvedUriBuilder().pathSegment(new String[]{"categoryCombos"}).queryParam("fields", new Object[]{NAME_FIELDS}), query, Objects.class).getCategoryCombos();
    }

    public DataElement getDataElement(String id) {
        return this.getObject(this.dhis2Config.getResolvedUriBuilder().pathSegment(new String[]{"dataElements"}).pathSegment(new String[]{id}).queryParam("fields", new Object[]{DATA_ELEMENT_FIELDS}), Query.instance(), DataElement.class);
    }

    public List<DataElement> getDataElements(Query query) {
        return this.getObject(this.dhis2Config.getResolvedUriBuilder().pathSegment(new String[]{"dataElements"}).queryParam("fields", new Object[]{DATA_ELEMENT_FIELDS}), query, Objects.class).getDataElements();
    }

    public DataElementGroupSet getDataElementGroupSet(String id) {
        return this.getObject(this.dhis2Config.getResolvedUriBuilder().pathSegment(new String[]{"dataElementGroupSets"}).pathSegment(new String[]{id}).queryParam("fields", new Object[]{NAME_FIELDS}), Query.instance(), DataElementGroupSet.class);
    }

    public List<DataElementGroupSet> getDataElementGroupSets(Query query) {
        return this.getObject(this.dhis2Config.getResolvedUriBuilder().pathSegment(new String[]{"dataElementGroupSets"}).queryParam("fields", new Object[]{NAME_FIELDS}), query, Objects.class).getDataElementGroupSets();
    }

    public Program getProgram(String id) {
        return this.getObject(this.dhis2Config.getResolvedUriBuilder().pathSegment(new String[]{"programs"}).pathSegment(new String[]{id}).queryParam("fields", new Object[]{String.format("%1$s,programType,categoryCombo[%1$s,categories[%2$s]],programStages[%1$s,programStageDataElements[%1$s,dataElement[%3$s]]]", NAME_FIELDS, CATEGORY_FIELDS, DATA_ELEMENT_FIELDS)}), Query.instance(), Program.class);
    }

    public List<Program> getPrograms(Query query) {
        return this.getObject(this.dhis2Config.getResolvedUriBuilder().pathSegment(new String[]{"programs"}).queryParam("fields", new Object[]{String.format("%1$s,programType,categoryCombo[%1$s,categories[%2$s]],programStages[%1$s,programStageDataElements[%1$s,dataElement[%3$s]]]", NAME_FIELDS, CATEGORY_FIELDS, DATA_ELEMENT_FIELDS)}), query, Objects.class).getPrograms();
    }

    public CategoryOptionGroupSet getCategoryOptionGroupSet(String id) {
        return this.getObject(this.dhis2Config.getResolvedUriBuilder().pathSegment(new String[]{"categoryOptionGroupSets"}).pathSegment(new String[]{id}).queryParam("fields", new Object[]{NAME_FIELDS}), Query.instance(), CategoryOptionGroupSet.class);
    }

    public List<CategoryOptionGroupSet> getCategoryOptionGroupSets(Query query) {
        return this.getObject(this.dhis2Config.getResolvedUriBuilder().pathSegment(new String[]{"categoryOptionGroupSets"}).queryParam("fields", new Object[]{NAME_FIELDS}), query, Objects.class).getCategoryOptionGroupSets();
    }

    public ResponseMessage saveTableHook(TableHook tableHook) {
        return this.saveObject("analyticsTableHooks", tableHook);
    }

    public ResponseMessage updateTableHook(TableHook tableHook) {
        return this.updateObject(String.format("analyticsTableHooks/%s", tableHook.getId()), tableHook);
    }

    public TableHook getTableHook(String id) {
        return this.getObject("analyticsTableHooks", id, TableHook.class);
    }

    public List<TableHook> getTableHooks(Query query) {
        return this.getObject(this.dhis2Config.getResolvedUriBuilder().pathSegment(new String[]{"analyticsTableHooks"}).queryParam("fields", new Object[]{ID_FIELDS}), query, Objects.class).getAnalyticsTableHooks();
    }

    public Dimension getDimension(String id) {
        return this.getObject(this.dhis2Config.getResolvedUriBuilder().pathSegment(new String[]{"dimensions"}).pathSegment(new String[]{id}).queryParam("fields", new Object[]{String.format("%s,dimensionType", ID_FIELDS)}), Query.instance(), Dimension.class);
    }

    public List<Dimension> getDimensions(Query query) {
        return this.getObject(this.dhis2Config.getResolvedUriBuilder().pathSegment(new String[]{"dimensions"}).queryParam("fields", new Object[]{String.format("%s,dimensionType", ID_FIELDS)}), query, Objects.class).getDimensions();
    }

    public List<PeriodType> getPeriodTypes(Query query) {
        return this.getObject(this.dhis2Config.getResolvedUriBuilder().pathSegment(new String[]{"periodTypes"}).queryParam("fields", new Object[]{"frequencyOrder,name,isoDuration,isoFormat"}), query, Objects.class).getPeriodTypes();
    }

    private HttpHeaders getBasicAuthAcceptJsonHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", Dhis2.getBasicAuthString(this.dhis2Config.getUsername(), this.dhis2Config.getPassword()));
        headers.set("Content-Type", "application/json");
        return headers;
    }

    private static String getBasicAuthString(String username, String password) {
        String string = username + ":" + password;
        return "Basic " + Base64.getEncoder().encodeToString(string.getBytes());
    }
}

