/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis;

import java.util.Base64;
import org.hisp.dhis.Dhis2Config;
import org.hisp.dhis.query.Filter;
import org.hisp.dhis.query.Order;
import org.hisp.dhis.query.Paging;
import org.hisp.dhis.query.Query;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class BaseDhis2 {
    protected static final String ID_FIELDS = "id,code,name,created,lastUpdated";
    protected static final String NAME_FIELDS = String.format("%s,shortName,description", "id,code,name,created,lastUpdated");
    protected static final String DATA_ELEMENT_FIELDS = String.format("%1$s,aggregationType,valueType,domainType,legendSets[%1$s]", NAME_FIELDS);
    protected static final String CATEGORY_FIELDS = String.format("%s,dataDimensionType,dataDimension", NAME_FIELDS);
    protected static final String RESOURCE_SYSTEM_INFO = "system/info";
    protected Dhis2Config dhis2Config;
    protected RestTemplate restTemplate;

    public BaseDhis2(Dhis2Config dhis2Config, RestTemplate restTemplate) {
        Assert.notNull((Object)dhis2Config, (String)"dhis2Config must be specified");
        Assert.notNull((Object)restTemplate, (String)"restTemplate must be specified");
        this.dhis2Config = dhis2Config;
        this.restTemplate = restTemplate;
    }

    protected <T> T getObject(UriComponentsBuilder uriBuilder, Query filters, Class<T> klass) {
        Order order;
        for (Filter filter : filters.getFilters()) {
            String filterValue = filter.getProperty() + ":" + filter.getOperator().value() + ":" + filter.getValue();
            uriBuilder.queryParam("filter", new Object[]{filterValue});
        }
        Paging paging = filters.getPaging();
        if (paging.hasPaging()) {
            if (paging.hasPage()) {
                uriBuilder.queryParam("page", new Object[]{paging.getPage()});
            }
            if (paging.hasPageSize()) {
                uriBuilder.queryParam("pageSize", new Object[]{paging.getPageSize()});
            }
        } else {
            uriBuilder.queryParam("paging", new Object[]{"false"});
        }
        if ((order = filters.getOrder()).hasOrder()) {
            String orderValue = order.getProperty() + ":" + order.getDirection().name().toLowerCase();
            uriBuilder.queryParam("order", new Object[]{orderValue});
        }
        String url = uriBuilder.build().toUriString();
        return this.getObjectFromUrl(url, klass);
    }

    protected <T> T getObject(String path, String id, Class<T> klass) {
        String url = this.dhis2Config.getResolvedUriBuilder().pathSegment(new String[]{path}).pathSegment(new String[]{id}).build().toUriString();
        return this.getObjectFromUrl(url, klass);
    }

    protected <T> T getObjectFromUrl(String url, Class<T> klass) {
        HttpHeaders headers = this.getBasicAuthAcceptJsonHeaders();
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), klass, new Object[0]);
        return (T)response.getBody();
    }

    protected HttpHeaders getBasicAuthAcceptJsonHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", BaseDhis2.getBasicAuthString(this.dhis2Config.getUsername(), this.dhis2Config.getPassword()));
        headers.set("Content-Type", "application/json");
        return headers;
    }

    protected static String getBasicAuthString(String username, String password) {
        String string = username + ":" + password;
        return "Basic " + Base64.getEncoder().encodeToString(string.getBytes());
    }
}

