/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.hisp.dhis.model.CategoryCombo;
import org.hisp.dhis.model.DataElement;
import org.hisp.dhis.model.NameableObject;
import org.hisp.dhis.model.ProgramStage;
import org.hisp.dhis.model.ProgramType;

public class Program
extends NameableObject {
    @JsonProperty
    private ProgramType programType;
    @JsonProperty
    private CategoryCombo categoryCombo;
    @JsonProperty
    private List<ProgramStage> programStages = new ArrayList<ProgramStage>();

    public Program() {
    }

    public Program(String id, String name) {
        this.id = id;
        this.name = name;
    }

    @JsonIgnore
    public Set<DataElement> getDataElements() {
        return this.programStages.stream().flatMap(ps -> ps.getDataElements().stream()).collect(Collectors.toSet());
    }

    @JsonIgnore
    public Set<DataElement> getDataElementsWithLegendSet() {
        return this.getDataElements().stream().filter(de -> !de.getLegendSets().isEmpty() && de.getValueType().isNumeric()).collect(Collectors.toSet());
    }

    public boolean hasCategoryCombo() {
        return this.categoryCombo != null;
    }

    public ProgramType getProgramType() {
        return this.programType;
    }

    public void setProgramType(ProgramType programType) {
        this.programType = programType;
    }

    public CategoryCombo getCategoryCombo() {
        return this.categoryCombo;
    }

    public void setCategoryCombo(CategoryCombo categoryCombo) {
        this.categoryCombo = categoryCombo;
    }

    public List<ProgramStage> getProgramStages() {
        return this.programStages;
    }

    public void setProgramStages(List<ProgramStage> programStages) {
        this.programStages = programStages;
    }
}

