/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.query;

import org.springframework.util.Assert;

public class Paging {
    private Integer page;
    private Integer pageSize;

    public Paging() {
    }

    public Paging(Integer page, Integer pageSize) {
        Assert.isTrue((page == null || page >= 1 ? 1 : 0) != 0, (String)"Page must be greater than zero if specified");
        Assert.isTrue((pageSize == null || pageSize >= 1 ? 1 : 0) != 0, (String)"Page size must be greater than zero if specified");
        this.page = page;
        this.pageSize = pageSize;
    }

    public Integer getPage() {
        return this.page;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public boolean hasPage() {
        return this.page != null && this.page >= 0;
    }

    public boolean hasPageSize() {
        return this.pageSize != null && this.pageSize >= 0;
    }

    public boolean hasPaging() {
        return this.hasPage() || this.hasPageSize();
    }

    public int getOffset() {
        int pgs = this.pageSize != null ? this.pageSize : 50;
        int pg = this.page != null ? this.page : 1;
        return pgs * (pg - 1);
    }
}

