/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.query;

import java.util.ArrayList;
import java.util.List;
import org.hisp.dhis.query.Filter;
import org.hisp.dhis.query.Order;
import org.hisp.dhis.query.Paging;

public class Query {
    private List<Filter> filters = new ArrayList<Filter>();
    private Paging paging;
    private Order order;
    private boolean expandAssociations = false;

    private Query() {
    }

    public static Query instance() {
        return new Query();
    }

    public Query addFilter(Filter filter) {
        this.filters.add(filter);
        return this;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public Query withPaging(Integer page, Integer pageSize) {
        this.paging = new Paging(page, pageSize);
        return this;
    }

    public Paging getPaging() {
        return this.paging != null ? this.paging : new Paging();
    }

    public Query withOrder(Order order) {
        this.order = order;
        return this;
    }

    public Order getOrder() {
        return this.order != null ? this.order : new Order();
    }

    public Query withExpandAssociations() {
        this.expandAssociations = true;
        return this;
    }

    public boolean isExpandAssociations() {
        return this.expandAssociations;
    }
}

