/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.Validate;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.hisp.dhis.Dhis2Config;
import org.hisp.dhis.response.BaseHttpResponse;
import org.hisp.dhis.response.job.JobInfo;
import org.hisp.dhis.response.job.JobInfoResponse;
import org.hisp.dhis.response.job.JobNotification;
import org.hisp.dhis.util.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dhis2AsyncRequest {
    private static final Logger log = LoggerFactory.getLogger(Dhis2AsyncRequest.class);
    private static final int TIMEOUT_S = 3600;
    private static final int DELAY_S = 2;
    private static final int ATTEMPTS_MAX = 1800;
    private final Dhis2Config config;
    private final CloseableHttpClient httpClient;
    private final ObjectMapper objectMapper;

    public Dhis2AsyncRequest(Dhis2Config config, CloseableHttpClient httpClient, ObjectMapper objectMapper) {
        Validate.notNull((Object)config);
        Validate.notNull((Object)httpClient);
        Validate.notNull((Object)objectMapper);
        this.config = config;
        this.httpClient = httpClient;
        this.objectMapper = objectMapper;
    }

    public <T extends BaseHttpResponse> T post(HttpPost request, Class<T> klass) throws IOException {
        JobInfoResponse message = this.postAsyncRequest(request);
        JobInfo jobInfo = message.getResponse();
        log.info("Push response: '{}', '{}', job: '{}'", new Object[]{message.getHttpStatus(), message.getMessage(), jobInfo});
        JobNotification notification = this.waitForCompletion(jobInfo);
        log.info("Job completed: '{}'", (Object)notification);
        BaseHttpResponse summary = (BaseHttpResponse)this.getSummary(jobInfo, klass);
        log.debug("Summary: '{}'", (Object)summary);
        return (T)summary;
    }

    private JobInfoResponse postAsyncRequest(HttpPost request) throws IOException {
        JobInfoResponse jobInfoResponse;
        block9: {
            CloseableHttpResponse response = this.httpClient.execute((ClassicHttpRequest)request);
            try {
                String body = EntityUtils.toString((HttpEntity)response.getEntity());
                JobInfoResponse message = (JobInfoResponse)this.objectMapper.readValue(body, JobInfoResponse.class);
                if (!message.getHttpStatus().is2xxSuccessful()) {
                    throw new IOException(String.format("Request failed, status: %s, code: %d, message: %s", new Object[]{message.getHttpStatus(), message.getHttpStatusCode(), message.getMessage()}));
                }
                jobInfoResponse = message;
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ParseException ex) {
                    throw new IOException("HTTP headers could not be parsed", ex);
                }
            }
            response.close();
        }
        return jobInfoResponse;
    }

    private JobNotification waitForCompletion(JobInfo jobInfo) {
        URI statusUrl = HttpUtils.build(this.config.getResolvedUriBuilder().appendPath("system").appendPath("tasks").appendPath(jobInfo.getJobType().name()).appendPath(jobInfo.getId()));
        JobNotification notification = null;
        boolean completed = false;
        int attempts = 0;
        while (!completed && attempts++ < 1800) {
            notification = this.getLastNotification(statusUrl);
            completed = notification.isCompleted();
            log.info("Complete check URL: '{}', complete: {}", (Object)statusUrl, (Object)completed);
            if (completed) continue;
            this.sleepForSeconds(2L);
        }
        return notification;
    }

    private <T> T getSummary(JobInfo jobInfo, Class<T> klass) throws IOException {
        URI summaryUrl = HttpUtils.build(this.config.getResolvedUriBuilder().appendPath("system").appendPath("taskSummaries").appendPath(jobInfo.getJobType().name()).appendPath(jobInfo.getId()));
        log.info("Task summary URL: '{}'", (Object)summaryUrl);
        String summary = this.getForBody(summaryUrl);
        return (T)this.objectMapper.readValue(summary, klass);
    }

    private JobNotification getLastNotification(URI url) {
        try {
            String response = this.getForBody(url);
            JobNotification[] notificationArray = (JobNotification[])this.objectMapper.readValue(response, JobNotification[].class);
            ArrayList<JobNotification> notifications = new ArrayList<JobNotification>(Arrays.asList(notificationArray));
            return !notifications.isEmpty() ? (JobNotification)notifications.get(0) : new JobNotification();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private String getForBody(URI url) throws IOException {
        String string;
        block8: {
            HttpGet request = HttpUtils.withAuth(new HttpGet(url), this.config);
            CloseableHttpResponse response = this.httpClient.execute((ClassicHttpRequest)request);
            try {
                string = EntityUtils.toString((HttpEntity)response.getEntity());
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ParseException ex) {
                    throw new IOException("HTTP headers could not be parsed", ex);
                }
            }
            response.close();
        }
        return string;
    }

    private void sleepForSeconds(long timeout) {
        try {
            TimeUnit.SECONDS.sleep(timeout);
        }
        catch (InterruptedException ex) {
            throw new RuntimeException("Thread interrupted", ex);
        }
    }
}

