/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.util;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class DateTimeUtils {
    private static final DateTimeFormatter DATE_TIME_S_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");
    private static final DateTimeFormatter DATE_TIME_MS_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS");

    public static Date getDate(int year, int month, int dayOfMonth) {
        LocalDate localDate = LocalDate.of(year, month, dayOfMonth);
        return Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    public static String getTimestampSecondsString(LocalDateTime dateTime) {
        return DATE_TIME_S_FORMAT.format(dateTime);
    }

    public static String getTimestampMillisString(LocalDateTime dateTime) {
        return DATE_TIME_MS_FORMAT.format(dateTime);
    }
}

