/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.query.analytics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hisp.dhis.model.AggregationType;
import org.hisp.dhis.model.IdScheme;
import org.hisp.dhis.query.analytics.Dimension;

public class AnalyticsQuery {
    private List<Dimension> dimensions = new ArrayList<Dimension>();
    private List<Dimension> filters = new ArrayList<Dimension>();
    private AggregationType aggregationType;
    private String startDate;
    private String endDate;
    private Boolean skipMeta;
    private Boolean skipData;
    private Boolean skipRounding;
    private Boolean ignoreLimit;
    private IdScheme outputIdScheme;
    private IdScheme inputIdScheme;

    private AnalyticsQuery() {
    }

    public static AnalyticsQuery instance() {
        return new AnalyticsQuery();
    }

    public AnalyticsQuery addDimension(Dimension dimension) {
        this.dimensions.add(dimension);
        return this;
    }

    public AnalyticsQuery addDimension(String dimension, String ... items) {
        return this.addDimension(new Dimension(dimension, new ArrayList<String>(Arrays.asList(items))));
    }

    public AnalyticsQuery addFilter(Dimension filter) {
        this.filters.add(filter);
        return this;
    }

    public List<Dimension> getDimensions() {
        return this.dimensions;
    }

    public List<Dimension> getFilters() {
        return this.filters;
    }

    public AggregationType getAggregationType() {
        return this.aggregationType;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public Boolean getSkipMeta() {
        return this.skipMeta;
    }

    public Boolean getSkipData() {
        return this.skipData;
    }

    public Boolean getSkipRounding() {
        return this.skipRounding;
    }

    public Boolean getIgnoreLimit() {
        return this.ignoreLimit;
    }

    public IdScheme getOutputIdScheme() {
        return this.outputIdScheme;
    }

    public IdScheme getInputIdScheme() {
        return this.inputIdScheme;
    }

    public AnalyticsQuery setDimensions(List<Dimension> dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    public AnalyticsQuery setFilters(List<Dimension> filters) {
        this.filters = filters;
        return this;
    }

    public AnalyticsQuery setAggregationType(AggregationType aggregationType) {
        this.aggregationType = aggregationType;
        return this;
    }

    public AnalyticsQuery setStartDate(String startDate) {
        this.startDate = startDate;
        return this;
    }

    public AnalyticsQuery setEndDate(String endDate) {
        this.endDate = endDate;
        return this;
    }

    public AnalyticsQuery setSkipMeta(Boolean skipMeta) {
        this.skipMeta = skipMeta;
        return this;
    }

    public AnalyticsQuery setSkipData(Boolean skipData) {
        this.skipData = skipData;
        return this;
    }

    public AnalyticsQuery setSkipRounding(Boolean skipRounding) {
        this.skipRounding = skipRounding;
        return this;
    }

    public AnalyticsQuery setIgnoreLimit(Boolean ignoreLimit) {
        this.ignoreLimit = ignoreLimit;
        return this;
    }

    public AnalyticsQuery setOutputIdScheme(IdScheme outputIdScheme) {
        this.outputIdScheme = outputIdScheme;
        return this;
    }

    public AnalyticsQuery setInputIdScheme(IdScheme inputIdScheme) {
        this.inputIdScheme = inputIdScheme;
        return this;
    }
}

