/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.util;

import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class DateTimeUtils {
    public static Date getDate(int year, int month, int dayOfMonth) {
        LocalDate localDate = LocalDate.of(year, month, dayOfMonth);
        return Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    public static LocalDateTime getLocalDateTime(String string) {
        string = StringUtils.removeEndIgnoreCase((String)string, (String)"z");
        return LocalDateTime.parse(string);
    }

    public static boolean isValidLocalDateTime(String instant) {
        try {
            return instant != null && DateTimeUtils.getLocalDateTime(instant) != null;
        }
        catch (DateTimeException ex) {
            return false;
        }
    }

    public static String getLocalDateTimeString(LocalDateTime dateTime) {
        return DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(dateTime);
    }

    public static String getUtcDateTimeString(LocalDateTime dateTime) {
        return String.format("%sZ", DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(dateTime));
    }
}

