/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;

public class CollectionUtils {
    @SafeVarargs
    public static <T> Set<T> set(T ... items) {
        return Collections.unmodifiableSet(CollectionUtils.mutableSet(items));
    }

    @SafeVarargs
    public static <T> Set<T> mutableSet(T ... items) {
        HashSet<T> set = new HashSet<T>();
        for (T item : items) {
            set.add(item);
        }
        return set;
    }

    @SafeVarargs
    public static <T> List<T> list(T ... items) {
        return Collections.unmodifiableList(CollectionUtils.mutableList(items));
    }

    @SafeVarargs
    public static <T> List<T> mutableList(T ... items) {
        ArrayList<T> list = new ArrayList<T>();
        for (T item : items) {
            list.add(item);
        }
        return list;
    }

    public static <A> A firstMatch(Collection<A> collection, Predicate<A> predicate) {
        return collection.stream().filter(predicate).findFirst().orElse(null);
    }
}

