/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.util;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.commons.lang3.Validate;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.core5.net.URIBuilder;
import org.hisp.dhis.Dhis2Config;
import org.hisp.dhis.auth.BasicAuthentication;
import org.hisp.dhis.auth.CookieAuthentication;

public class HttpUtils {
    public static String getBasicAuthString(Dhis2Config config) {
        Validate.isAssignableFrom(BasicAuthentication.class, config.getAuthentication().getClass());
        BasicAuthentication auth = (BasicAuthentication)config.getAuthentication();
        String value = String.format("%s:%s", auth.getUsername(), auth.getPassword());
        return "Basic " + Base64.getEncoder().encodeToString(value.getBytes());
    }

    public static String getSessionCookieAuthString(Dhis2Config config) {
        Validate.isAssignableFrom(CookieAuthentication.class, config.getAuthentication().getClass());
        CookieAuthentication auth = (CookieAuthentication)config.getAuthentication();
        return String.format("JSESSIONID=%s", auth.getValue());
    }

    public static <T extends HttpUriRequestBase> T withAuth(T request, Dhis2Config config) {
        Class<?> authType = config.getAuthentication().getClass();
        if (BasicAuthentication.class.isAssignableFrom(authType)) {
            request.setHeader("Authorization", (Object)HttpUtils.getBasicAuthString(config));
        } else if (CookieAuthentication.class.isAssignableFrom(authType)) {
            request.setHeader("Cookie", (Object)HttpUtils.getSessionCookieAuthString(config));
        } else {
            throw new IllegalStateException(String.format("Invalid authentication type: '%s'", authType));
        }
        return request;
    }

    public static URI build(URIBuilder uriBuilder) {
        try {
            return uriBuilder.build();
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String asString(URI uri) {
        try {
            return URLDecoder.decode(uri.toString(), StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }
}

