/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import org.apache.hc.client5.http.HttpResponseException;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpHead;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.net.URIBuilder;
import org.hisp.dhis.Dhis2Config;
import org.hisp.dhis.model.IdentifiableObject;
import org.hisp.dhis.model.Objects;
import org.hisp.dhis.model.datavalueset.DataValueSetImportOptions;
import org.hisp.dhis.model.event.EventsResult;
import org.hisp.dhis.query.Filter;
import org.hisp.dhis.query.Operator;
import org.hisp.dhis.query.Order;
import org.hisp.dhis.query.Paging;
import org.hisp.dhis.query.Query;
import org.hisp.dhis.query.analytics.AnalyticsQuery;
import org.hisp.dhis.query.analytics.Dimension;
import org.hisp.dhis.query.event.EventsQuery;
import org.hisp.dhis.response.BaseHttpResponse;
import org.hisp.dhis.response.Dhis2ClientException;
import org.hisp.dhis.response.HttpStatus;
import org.hisp.dhis.response.Response;
import org.hisp.dhis.response.Status;
import org.hisp.dhis.response.object.ObjectResponse;
import org.hisp.dhis.response.objects.ObjectsResponse;
import org.hisp.dhis.util.CollectionUtils;
import org.hisp.dhis.util.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseDhis2 {
    private static final Logger log = LoggerFactory.getLogger(BaseDhis2.class);
    protected static final String ID_FIELDS = "id,code,name,created,lastUpdated,attributeValues";
    protected static final String NAME_FIELDS = String.format("%s,shortName,description", "id,code,name,created,lastUpdated,attributeValues");
    protected static final String OPTION_SET_FIELDS = String.format("%s,valueType,version", "id,code,name,created,lastUpdated,attributeValues");
    protected static final String DATA_ELEMENT_FIELDS = String.format("%1$s,aggregationType,valueType,domainType,legendSets[%1$s],optionSet[%2$s]", NAME_FIELDS, OPTION_SET_FIELDS);
    protected static final String CATEGORY_OPTION_FIELDS = String.format("%1$s,shortName,startDate,endDate,formName,organisationUnits[%1$s]", "id,code,name,created,lastUpdated,attributeValues");
    protected static final String CATEGORY_FIELDS = String.format("%s,dataDimensionType,dataDimension", NAME_FIELDS);
    protected static final String ORG_UNIT_FIELDS = String.format("%s,path,level,parent[%s],openingDate,closedDate,comment,url,contactPerson,address,email,phoneNumber", NAME_FIELDS, NAME_FIELDS);
    protected static final String TE_ATTRIBUTE_FIELDS = String.format("%s,valueType,confidential,unique", NAME_FIELDS);
    protected static final String RESOURCE_SYSTEM_INFO = "system/info";
    protected static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final Set<Integer> ERROR_STATUS_CODES = CollectionUtils.set(401, 403, 404);
    protected final Dhis2Config config;
    protected final ObjectMapper objectMapper;
    protected final CloseableHttpClient httpClient;

    public BaseDhis2(Dhis2Config config) {
        Validate.notNull((Object)config, (String)"Config must be specified", (Object[])new Object[0]);
        this.config = config;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.objectMapper.setDateFormat((DateFormat)new SimpleDateFormat(DATE_FORMAT));
        this.httpClient = HttpClients.createDefault();
    }

    protected <T> T getObject(URIBuilder uriBuilder, Query query, Class<T> type) {
        URI url = this.getQuery(uriBuilder, query);
        return this.getObjectFromUrl(url, type);
    }

    protected boolean objectExists(URIBuilder uriBuilder) {
        boolean bl;
        block8: {
            HttpHead request = this.withAuth(new HttpHead(HttpUtils.build(uriBuilder)));
            CloseableHttpResponse response = this.httpClient.execute((ClassicHttpRequest)request);
            try {
                boolean bl2 = bl = HttpStatus.OK.value() == response.getCode();
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    return false;
                }
            }
            response.close();
        }
        return bl;
    }

    protected URI getQuery(URIBuilder uriBuilder, Query query) {
        Order order;
        for (Filter filter : query.getFilters()) {
            String filterValue = filter.getProperty() + ":" + filter.getOperator().value() + ":" + this.getQueryValue(filter);
            uriBuilder.addParameter("filter", filterValue);
        }
        Paging paging = query.getPaging();
        if (paging.hasPaging()) {
            if (paging.hasPage()) {
                uriBuilder.addParameter("page", String.valueOf(paging.getPage()));
            }
            if (paging.hasPageSize()) {
                uriBuilder.addParameter("pageSize", String.valueOf(paging.getPageSize()));
            }
        } else {
            uriBuilder.addParameter("paging", "false");
        }
        if ((order = query.getOrder()).hasOrder()) {
            String orderValue = order.getProperty() + ":" + order.getDirection().name().toLowerCase();
            uriBuilder.addParameter("order", orderValue);
        }
        return HttpUtils.build(uriBuilder);
    }

    protected <T> T getAnalyticsResponse(URIBuilder uriBuilder, AnalyticsQuery query, Class<T> type) {
        URI url = this.getAnalyticsQuery(uriBuilder, query);
        return this.getObjectFromUrl(url, type);
    }

    protected URI getAnalyticsQuery(URIBuilder uriBuilder, AnalyticsQuery query) {
        for (Dimension dimension : query.getDimensions()) {
            this.addParameter(uriBuilder, "dimension", dimension.getDimensionValue());
        }
        for (Dimension filter : query.getFilters()) {
            this.addParameter(uriBuilder, "filter", filter.getDimensionValue());
        }
        this.addParameter(uriBuilder, "aggregationType", (Object)query.getAggregationType());
        this.addParameter(uriBuilder, "startDate", query.getStartDate());
        this.addParameter(uriBuilder, "endDate", query.getEndDate());
        this.addParameter(uriBuilder, "skipMeta", query.getSkipMeta());
        this.addParameter(uriBuilder, "skipData", query.getSkipData());
        this.addParameter(uriBuilder, "skipRounding", query.getSkipRounding());
        this.addParameter(uriBuilder, "ignoreLimit", query.getIgnoreLimit());
        this.addParameter(uriBuilder, "inputIdScheme", query.getInputIdScheme());
        this.addParameter(uriBuilder, "outputIdScheme", query.getOutputIdScheme());
        return HttpUtils.build(uriBuilder);
    }

    protected URI getDataValueSetImportQuery(URIBuilder uriBuilder, DataValueSetImportOptions options) {
        this.addParameter(uriBuilder, "async", "true");
        this.addParameter(uriBuilder, "dataElementIdScheme", options.getDataElementIdScheme());
        this.addParameter(uriBuilder, "orgUnitIdScheme", options.getOrgUnitIdScheme());
        this.addParameter(uriBuilder, "categoryOptionComboIdScheme", options.getCategoryOptionComboIdScheme());
        this.addParameter(uriBuilder, "idScheme", options.getIdScheme());
        this.addParameter(uriBuilder, "dryRun", options.getDryRun());
        this.addParameter(uriBuilder, "preheatCache", options.getPreheatCache());
        this.addParameter(uriBuilder, "skipAudit", options.getSkipAudit());
        return HttpUtils.build(uriBuilder);
    }

    protected EventsResult getEventsResponse(URIBuilder uriBuilder, EventsQuery query) {
        URI url = this.getEventsQuery(uriBuilder, query);
        return this.getObjectFromUrl(url, EventsResult.class);
    }

    protected URI getEventsQuery(URIBuilder uriBuilder, EventsQuery query) {
        this.addParameter(uriBuilder, "program", query.getProgram());
        this.addParameter(uriBuilder, "programStage", query.getProgramStage());
        this.addParameter(uriBuilder, "programStatus", (Object)query.getProgramStatus());
        this.addParameter(uriBuilder, "followUp", query.getFollowUp());
        this.addParameter(uriBuilder, "trackedEntityInstance", query.getTrackedEntityInstance());
        this.addParameter(uriBuilder, "orgUnit", query.getOrgUnit());
        this.addParameter(uriBuilder, "ouMode", (Object)query.getOuMode());
        this.addParameter(uriBuilder, "status", (Object)query.getStatus());
        this.addParameter(uriBuilder, "occuredAfter", query.getOccurredAfter());
        this.addParameter(uriBuilder, "occuredBefore", query.getOccurredBefore());
        this.addParameter(uriBuilder, "scheduledAfter", query.getScheduledAfter());
        this.addParameter(uriBuilder, "scheduledBefore", query.getScheduledBefore());
        this.addParameter(uriBuilder, "updatedAfter", query.getUpdatedAfter());
        this.addParameter(uriBuilder, "updatedBefore", query.getUpdatedBefore());
        this.addParameter(uriBuilder, "dataElementIdScheme", query.getDataElementIdScheme());
        this.addParameter(uriBuilder, "categoryOptionComboIdScheme", query.getCategoryOptionComboIdScheme());
        this.addParameter(uriBuilder, "orgUnitIdScheme", query.getOrgUnitIdScheme());
        this.addParameter(uriBuilder, "programIdScheme", query.getProgramIdScheme());
        this.addParameter(uriBuilder, "programStageIdScheme", query.getProgramStageIdScheme());
        this.addParameter(uriBuilder, "idScheme", query.getIdScheme());
        return HttpUtils.build(uriBuilder);
    }

    private void addParameter(URIBuilder uriBuilder, String parameter, Object value) {
        if (value != null) {
            uriBuilder.addParameter(parameter, value.toString());
        }
    }

    private Object getQueryValue(Filter filter) {
        if (Operator.IN == filter.getOperator()) {
            return "[" + filter.getValue() + "]";
        }
        return filter.getValue();
    }

    protected <T> T getObject(String path, String id, Class<T> type) {
        try {
            URI url = this.config.getResolvedUriBuilder().appendPath(path).appendPath(id).build();
            return this.getObjectFromUrl(url, type);
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected <T extends BaseHttpResponse> T executeJsonPostPutRequest(HttpUriRequestBase request, Object object, Class<T> type) {
        this.validateRequestObject(object);
        String requestBody = this.toJsonString(object);
        log.debug("Request body: '{}'", (Object)requestBody);
        StringEntity entity = new StringEntity(requestBody, StandardCharsets.UTF_8);
        request.setHeader("Content-Type", (Object)ContentType.APPLICATION_JSON.getMimeType());
        request.setEntity((HttpEntity)entity);
        return this.executeRequest(request, type);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T extends BaseHttpResponse> T executeRequest(HttpUriRequestBase request, Class<T> type) {
        this.withAuth(request);
        try (CloseableHttpResponse response = this.httpClient.execute((ClassicHttpRequest)request);){
            this.handleErrors((HttpResponse)response, request.getRequestUri());
            String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
            log.debug("Response body: '{}'", (Object)responseBody);
            BaseHttpResponse responseMessage = (BaseHttpResponse)this.objectMapper.readValue(responseBody, type);
            responseMessage.setHeaders(BaseDhis2.asList(response.getHeaders()));
            responseMessage.setHttpStatusCode(response.getCode());
            BaseHttpResponse baseHttpResponse = responseMessage;
            return (T)baseHttpResponse;
        }
        catch (IOException ex) {
            throw this.newDhis2ClientException(ex);
        }
        catch (ParseException ex) {
            throw new Dhis2ClientException("HTTP response could not be parsed", ex);
        }
    }

    protected Response executeRequest(HttpUriRequestBase request) {
        Response response;
        block8: {
            this.withAuth(request);
            CloseableHttpResponse response2 = this.httpClient.execute((ClassicHttpRequest)request);
            try {
                this.handleErrors((HttpResponse)response2, request.getRequestUri());
                HttpStatus httpStatus = HttpStatus.valueOf(response2.getCode());
                Status status = httpStatus != null && httpStatus.is2xxSuccessful() ? Status.OK : Status.ERROR;
                Response resp = new Response();
                resp.setHeaders(BaseDhis2.asList(response2.getHeaders()));
                resp.setStatus(status);
                resp.setHttpStatusCode(response2.getCode());
                response = resp;
                if (response2 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response2 != null) {
                        try {
                            response2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw this.newDhis2ClientException(ex);
                }
            }
            response2.close();
        }
        return response;
    }

    protected HttpPost getPostRequest(URI url, HttpEntity entity) {
        HttpPost request = this.withAuth(new HttpPost(url));
        request.setHeader("Content-Type", (Object)ContentType.APPLICATION_JSON.getMimeType());
        request.setEntity(entity);
        return request;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T> T getObjectFromUrl(URI url, Class<T> type) {
        log.debug("Get object from URL: '{}'", (Object)url);
        try (CloseableHttpResponse response = this.getJsonHttpResponse(url);){
            this.handleErrors((HttpResponse)response, url.toString());
            String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
            log.debug("Response body: '{}'", (Object)responseBody);
            Object object = this.objectMapper.readValue(responseBody, type);
            return (T)object;
        }
        catch (IOException ex) {
            throw new Dhis2ClientException("Failed to fetch object", ex);
        }
        catch (ParseException ex) {
            throw new Dhis2ClientException("HTTP response could not be parsed", ex);
        }
    }

    protected CloseableHttpResponse getJsonHttpResponse(URI url) {
        HttpGet request = this.withAuth(new HttpGet(url));
        request.setHeader("Accept", (Object)ContentType.APPLICATION_JSON.getMimeType());
        log.debug("GET request URL: '{}'", (Object)HttpUtils.asString(url));
        try {
            return this.httpClient.execute((ClassicHttpRequest)request);
        }
        catch (IOException ex) {
            throw new Dhis2ClientException("Request failed", ex);
        }
    }

    private void handleErrors(HttpResponse response, String url) {
        int code = response.getCode();
        if (ERROR_STATUS_CODES.contains(code)) {
            String message = String.format("%s (%d)", this.getErrorMessage(code), code);
            log.debug("Error URL: '{}'", (Object)url);
            throw new Dhis2ClientException(message, code);
        }
    }

    private String getErrorMessage(int code) {
        if (401 == code) {
            return "Authentication failed";
        }
        if (403 == code) {
            return "Access was denied";
        }
        if (404 == code) {
            return "Object not found";
        }
        if (409 == code) {
            return "Conflict";
        }
        if (code >= 400 && code < 500) {
            return "Client error";
        }
        if (code >= 500 && code < 600) {
            return "Server error";
        }
        return "Error";
    }

    private void validateRequestObject(Object object) {
        if (object == null) {
            throw new Dhis2ClientException("Request object is null", 400);
        }
    }

    protected void writeToFile(CloseableHttpResponse response, File file) {
        try (FileOutputStream fileOut = FileUtils.openOutputStream((File)file);
             InputStream in = response.getEntity().getContent();){
            IOUtils.copy((InputStream)in, (OutputStream)fileOut);
        }
        catch (IOException ex) {
            throw new Dhis2ClientException("Failed to write to file", ex);
        }
    }

    protected <T extends HttpUriRequestBase> T withAuth(T request) {
        return HttpUtils.withAuth(request, this.config);
    }

    protected String toJsonString(Object object) {
        try {
            String json = this.objectMapper.writeValueAsString(object);
            log.debug("Object JSON: '{}'", (Object)json);
            return json;
        }
        catch (IOException ex) {
            throw new Dhis2ClientException("Failed to deserialize JSON", ex);
        }
    }

    protected Dhis2ClientException newDhis2ClientException(IOException ex) {
        int statusCode = -1;
        if (ex instanceof HttpResponseException) {
            statusCode = ((HttpResponseException)ex).getStatusCode();
        }
        return new Dhis2ClientException(ex.getMessage(), ex.getCause(), statusCode);
    }

    protected static <T> ArrayList<T> asList(T[] array) {
        return new ArrayList<T>(Arrays.asList(array));
    }

    protected ObjectResponse saveMetadataObject(String path, IdentifiableObject object) {
        return this.saveObject(path, (Object)object, ObjectResponse.class);
    }

    protected <T extends BaseHttpResponse> T saveObject(String path, Object object, Class<T> type) {
        URI url = this.config.getResolvedUrl(path);
        return this.executeJsonPostPutRequest((HttpUriRequestBase)new HttpPost(url), object, type);
    }

    protected <T extends BaseHttpResponse> T saveObject(URIBuilder uriBuilder, Object object, Class<T> type) {
        URI url = HttpUtils.build(uriBuilder);
        return this.executeJsonPostPutRequest((HttpUriRequestBase)new HttpPost(url), object, type);
    }

    protected ObjectsResponse saveMetadataObjects(Objects objects) {
        URI url = this.config.getResolvedUrl("metadata");
        return this.executeJsonPostPutRequest((HttpUriRequestBase)new HttpPost(url), objects, ObjectsResponse.class);
    }

    protected ObjectResponse updateMetadataObject(String path, IdentifiableObject object) {
        return this.updateObject(path, object, ObjectResponse.class);
    }

    protected <T extends BaseHttpResponse> T updateObject(String path, Object object, Class<T> type) {
        URI url = this.config.getResolvedUrl(path);
        return this.executeJsonPostPutRequest((HttpUriRequestBase)new HttpPut(url), object, type);
    }

    protected ObjectResponse removeMetadataObject(String path) {
        return this.removeObject(path, ObjectResponse.class);
    }

    protected <T extends BaseHttpResponse> T removeObject(String path, Class<T> type) {
        URI url = this.config.getResolvedUrl(path);
        return this.executeRequest((HttpUriRequestBase)new HttpDelete(url), type);
    }

    protected <T> T getObject(String path, Class<T> type) {
        return this.getObjectFromUrl(this.config.getResolvedUrl(path), type);
    }

    protected Response addToCollection(String path, String id, String collection, String item) {
        URI url = HttpUtils.build(this.config.getResolvedUriBuilder().appendPath(path).appendPath(id).appendPath(collection).appendPath(item));
        Response response = this.executeRequest((HttpUriRequestBase)new HttpPost(url));
        Status status = response != null && response.getHttpStatus() != null && response.getHttpStatus().is2xxSuccessful() ? Status.OK : Status.ERROR;
        return new Response(status, response.getHttpStatusCode(), response.getMessage());
    }
}

