/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.hisp.dhis.model.Attribute;

public class AttributeValue {
    @JsonProperty
    private Attribute attribute;
    @JsonProperty
    private String value;

    public AttributeValue(Attribute attribute, String value) {
        this.attribute = attribute;
        this.value = value;
    }

    @JsonIgnore
    public boolean hasValue() {
        return StringUtils.isNotEmpty((CharSequence)this.value);
    }

    @JsonIgnore
    public boolean isDouble() {
        return NumberUtils.isCreatable((String)this.value);
    }

    @JsonIgnore
    public Double getDoubleValue() {
        return this.isDouble() ? Double.valueOf(this.value) : null;
    }

    @JsonIgnore
    public boolean isInteger() {
        return StringUtils.isNumeric((CharSequence)this.value);
    }

    @JsonIgnore
    public Integer getIntegerValue() {
        return this.isInteger() ? Integer.valueOf(this.value) : null;
    }

    public int hashCode() {
        return Objects.hash(this.attribute.getId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!this.getClass().isAssignableFrom(o.getClass())) {
            return false;
        }
        AttributeValue other = (AttributeValue)o;
        return Objects.equals(this.attribute.getId(), other.getAttribute().getId());
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public String getValue() {
        return this.value;
    }

    @JsonProperty
    public void setAttribute(Attribute attribute) {
        this.attribute = attribute;
    }

    @JsonProperty
    public void setValue(String value) {
        this.value = value;
    }

    public AttributeValue() {
    }
}

